/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.completion.AllClassesGetter;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.JavaCompletionUtil;
import com.intellij.codeInsight.completion.scope.JavaCompletionProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.tree.java.PsiReferenceExpressionImpl;
import com.intellij.util.Processor;
import gnu.trove.THashSet;
import java.util.Set;

class LimitedAccessibleClassPreprocessor
implements Processor<PsiClass> {
    private static final Logger LOG = Logger.getInstance(LimitedAccessibleClassPreprocessor.class);
    private final PsiElement myContext;
    private final CompletionParameters myParameters;
    private final boolean myFilterByScope;
    private final Processor<? super PsiClass> myProcessor;
    private final int myLimit = Registry.intValue((String)"ide.completion.variant.limit");
    private int myCount;
    private final Set<String> myQNames = new THashSet();
    private final boolean myPkgContext;
    private final String myPackagePrefix;

    LimitedAccessibleClassPreprocessor(CompletionParameters parameters2, boolean filterByScope, Processor<? super PsiClass> processor2) {
        this.myContext = parameters2.getPosition();
        this.myParameters = parameters2;
        this.myFilterByScope = filterByScope;
        this.myProcessor = processor2;
        this.myPkgContext = JavaCompletionUtil.inSomePackage(this.myContext);
        this.myPackagePrefix = LimitedAccessibleClassPreprocessor.getPackagePrefix(this.myContext, this.myParameters.getOffset());
    }

    private static String getPackagePrefix(PsiElement context, int offset) {
        char c;
        int i;
        CharSequence fileText = context.getContainingFile().getViewProvider().getContents();
        for (i = offset - 1; i >= 0 && (Character.isJavaIdentifierPart(c = fileText.charAt(i)) || c == '.'); --i) {
        }
        String prefix = fileText.subSequence(i + 1, offset).toString();
        int j = prefix.lastIndexOf(46);
        return j > 0 ? prefix.substring(0, j) : "";
    }

    public boolean process(PsiClass psiClass) {
        if (this.myParameters.getInvocationCount() < 2) {
            if (PsiReferenceExpressionImpl.seemsScrambled(psiClass) || JavaCompletionProcessor.seemsInternal(psiClass)) {
                return true;
            }
            String name2 = psiClass.getName();
            if (name2 != null && !name2.isEmpty() && Character.isLowerCase(name2.charAt(0)) && !Registry.is((String)"ide.completion.show.lower.case.classes")) {
                return true;
            }
        }
        assert (psiClass != null);
        if (AllClassesGetter.isAcceptableInContext(this.myContext, psiClass, this.myFilterByScope, this.myPkgContext)) {
            String qName = psiClass.getQualifiedName();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Processing class " + qName);
            }
            if (qName != null && qName.startsWith(this.myPackagePrefix) && this.myQNames.add(qName)) {
                if (!this.myProcessor.process((Object)psiClass)) {
                    return false;
                }
                if (++this.myCount > this.myLimit) {
                    LOG.debug("Limit reached");
                    return false;
                }
            }
        }
        return true;
    }
}

