/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.annoPackages;

import com.intellij.codeInsight.AnnotationTargetUtil;
import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.Nullability;
import com.intellij.codeInsight.NullabilityAnnotationInfo;
import com.intellij.codeInsight.NullableNotNullManager;
import com.intellij.codeInsight.annoPackages.AnnotationPackageSupport;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Jsr305Support
implements AnnotationPackageSupport {
    public static final String JAVAX_ANNOTATION_NULLABLE = "javax.annotation.Nullable";
    public static final String JAVAX_ANNOTATION_NONNULL = "javax.annotation.Nonnull";
    public static final String TYPE_QUALIFIER_NICKNAME = "javax.annotation.meta.TypeQualifierNickname";
    private final NullableNotNullManager myManager;

    Jsr305Support(NullableNotNullManager manager) {
        this.myManager = manager;
    }

    @Override
    @Nullable
    public NullabilityAnnotationInfo getNullabilityByContainerAnnotation(@NotNull PsiAnnotation annotation, // Could not load outer class - annotation placement on inner may be incorrect
    PsiAnnotation.TargetType @NotNull [] placeTargetTypes, boolean superPackage) {
        PsiModifierList modList;
        if (superPackage) {
            return null;
        }
        PsiClass declaration2 = annotation.resolveAnnotationType();
        PsiModifierList psiModifierList = modList = declaration2 == null ? null : declaration2.getModifierList();
        if (modList == null) {
            return null;
        }
        PsiAnnotation tqDefault = AnnotationUtil.findAnnotation((PsiModifierListOwner)declaration2, (boolean)true, (String[])new String[]{"javax.annotation.meta.TypeQualifierDefault"});
        if (tqDefault == null) {
            return null;
        }
        Set required = AnnotationTargetUtil.extractRequiredAnnotationTargets((PsiAnnotationMemberValue)tqDefault.findAttributeValue(null));
        if (required == null || !required.isEmpty() && !ContainerUtil.intersects((Collection)required, Arrays.asList(placeTargetTypes))) {
            return null;
        }
        for (PsiAnnotation qualifier : modList.getAnnotations()) {
            Nullability nullability = this.getJsr305QualifierNullability(qualifier);
            if (nullability == null) continue;
            return new NullabilityAnnotationInfo(annotation, nullability, true);
        }
        return null;
    }

    @Nullable
    private Nullability getJsr305QualifierNullability(@NotNull PsiAnnotation qualifier) {
        String qName = qualifier.getQualifiedName();
        if (qName == null || !qName.startsWith("javax.annotation.")) {
            return null;
        }
        if (qName.equals(JAVAX_ANNOTATION_NULLABLE) && this.myManager.getNullables().contains(qName)) {
            return Nullability.NULLABLE;
        }
        if (qName.equals(JAVAX_ANNOTATION_NONNULL)) {
            return Jsr305Support.extractNullityFromWhenValue(qualifier);
        }
        return null;
    }

    public static boolean isNullabilityNickName(@NotNull PsiClass candidate) {
        String qname = candidate.getQualifiedName();
        if (qname == null || qname.startsWith("javax.annotation.")) {
            return false;
        }
        return Jsr305Support.getNickNamedNullability(candidate) != Nullability.UNKNOWN;
    }

    @NotNull
    public static Nullability getNickNamedNullability(@NotNull PsiClass psiClass) {
        if (AnnotationUtil.findAnnotation((PsiModifierListOwner)psiClass, (String[])new String[]{TYPE_QUALIFIER_NICKNAME}) == null) {
            return Nullability.UNKNOWN;
        }
        PsiAnnotation nonNull = AnnotationUtil.findAnnotation((PsiModifierListOwner)psiClass, (String[])new String[]{JAVAX_ANNOTATION_NONNULL});
        return nonNull != null ? Jsr305Support.extractNullityFromWhenValue(nonNull) : Nullability.UNKNOWN;
    }

    @NotNull
    private static Nullability extractNullityFromWhenValue(@NotNull PsiAnnotation nonNull) {
        PsiAnnotationMemberValue when = nonNull.findAttributeValue("when");
        if (when instanceof PsiReferenceExpression) {
            String refName = ((PsiReferenceExpression)when).getReferenceName();
            if ("ALWAYS".equals(refName)) {
                return Nullability.NOT_NULL;
            }
            if ("MAYBE".equals(refName) || "NEVER".equals(refName)) {
                return Nullability.NULLABLE;
            }
        }
        if (when == null && JAVAX_ANNOTATION_NONNULL.equals(nonNull.getQualifiedName())) {
            return Nullability.NOT_NULL;
        }
        return Nullability.UNKNOWN;
    }

    @Override
    @NotNull
    public List<String> getNullabilityAnnotations(@NotNull Nullability nullability) {
        switch (nullability) {
            case NOT_NULL: {
                return Collections.singletonList(JAVAX_ANNOTATION_NONNULL);
            }
            case NULLABLE: {
                return Arrays.asList(JAVAX_ANNOTATION_NULLABLE, "javax.annotation.CheckForNull");
            }
        }
        return Collections.emptyList();
    }
}

