/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight;

import com.intellij.codeInsight.TargetElementEvaluatorEx2;
import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.codeInsight.TargetElementUtilExtender;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiJavaModuleReferenceElement;
import com.intellij.psi.PsiJavaReference;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiLabeledStatement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiMethodReferenceUtil;
import com.intellij.psi.PsiMirrorElement;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.light.LightRecordCanonicalConstructor;
import com.intellij.psi.impl.light.LightRecordMember;
import com.intellij.psi.javadoc.PsiDocTag;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.search.searches.FunctionalExpressionSearch;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.BitUtil;
import com.intellij.util.Processor;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaTargetElementEvaluator
extends TargetElementEvaluatorEx2
implements TargetElementUtilExtender {
    private static final int NEW_AS_CONSTRUCTOR = 4;
    private static final int THIS_ACCEPTED = 16;
    private static final int SUPER_ACCEPTED = 32;

    public int getAllAdditionalFlags() {
        return 52;
    }

    public int getAdditionalDefinitionSearchFlags() {
        return 48;
    }

    public int getAdditionalReferenceSearchFlags() {
        return 4;
    }

    @Nullable
    public PsiElement adjustTargetElement(Editor editor, int offset, int flags, @NotNull PsiElement targetElement) {
        if (targetElement instanceof PsiKeyword) {
            if (targetElement.getParent() instanceof PsiThisExpression) {
                if (!BitUtil.isSet((int)flags, (int)16)) {
                    return null;
                }
                PsiType type2 = ((PsiThisExpression)targetElement.getParent()).getType();
                if (!(type2 instanceof PsiClassType)) {
                    return null;
                }
                return ((PsiClassType)type2).resolve();
            }
            if (targetElement.getParent() instanceof PsiSuperExpression) {
                if (!BitUtil.isSet((int)flags, (int)32)) {
                    return null;
                }
                PsiType type3 = ((PsiSuperExpression)targetElement.getParent()).getType();
                if (!(type3 instanceof PsiClassType)) {
                    return null;
                }
                return ((PsiClassType)type3).resolve();
            }
        }
        return super.adjustTargetElement(editor, offset, flags, targetElement);
    }

    public boolean isAcceptableNamedParent(@NotNull PsiElement parent) {
        return !(parent instanceof PsiDocTag) && !(parent instanceof PsiAnonymousClass);
    }

    @NotNull
    public ThreeState isAcceptableReferencedElement(@NotNull PsiElement element, PsiElement referenceOrReferencedElement) {
        if (JavaTargetElementEvaluator.isEnumConstantReference(element, referenceOrReferencedElement)) {
            return ThreeState.NO;
        }
        return super.isAcceptableReferencedElement(element, referenceOrReferencedElement);
    }

    private static boolean isEnumConstantReference(PsiElement element, PsiElement referenceOrReferencedElement) {
        return element != null && element.getParent() instanceof PsiEnumConstant && referenceOrReferencedElement instanceof PsiMethod && ((PsiMethod)referenceOrReferencedElement).isConstructor();
    }

    @Nullable
    public PsiElement adjustReferenceOrReferencedElement(@NotNull PsiFile file, @NotNull Editor editor, int offset, int flags, @Nullable PsiElement refElement) {
        PsiReference ref = null;
        if (refElement == null) {
            PsiElement element;
            ref = TargetElementUtil.findReference((Editor)editor, (int)offset);
            if (ref instanceof PsiJavaReference) {
                refElement = ((PsiJavaReference)ref).advancedResolve(true).getElement();
            } else if (ref == null && (element = file.findElementAt(offset)) != null) {
                PsiElement parent = element.getParent();
                if (parent instanceof PsiFunctionalExpression && (PsiUtil.isJavaToken((PsiElement)element, (IElementType)JavaTokenType.ARROW) || PsiUtil.isJavaToken((PsiElement)element, (IElementType)JavaTokenType.DOUBLE_COLON))) {
                    refElement = LambdaUtil.resolveFunctionalInterfaceClass((PsiFunctionalExpression)((PsiFunctionalExpression)parent));
                } else if (element instanceof PsiKeyword && parent instanceof PsiTypeElement && ((PsiTypeElement)parent).isInferredType()) {
                    refElement = PsiUtil.resolveClassInType((PsiType)((PsiTypeElement)parent).getType());
                }
            }
        }
        if (refElement != null) {
            PsiFile containingFile;
            if (BitUtil.isSet((int)flags, (int)4)) {
                if (ref == null) {
                    ref = TargetElementUtil.findReference((Editor)editor, (int)offset);
                }
                if (ref != null) {
                    PsiElement parent = ref.getElement().getParent();
                    if (parent instanceof PsiAnonymousClass) {
                        parent = parent.getParent();
                    }
                    if (parent instanceof PsiNewExpression) {
                        PsiMethod constructor = ((PsiNewExpression)parent).resolveConstructor();
                        if (constructor != null) {
                            refElement = constructor;
                        } else if (refElement instanceof PsiClass && ((PsiClass)refElement).getConstructors().length > 0) {
                            return null;
                        }
                    }
                }
            }
            if (refElement instanceof PsiMirrorElement) {
                return ((PsiMirrorElement)refElement).getPrototype();
            }
            if (refElement instanceof PsiClass && (containingFile = refElement.getContainingFile()) != null && containingFile.getVirtualFile() == null) {
                String qualifiedName = ((PsiClass)refElement).getQualifiedName();
                if (qualifiedName == null) {
                    return null;
                }
                return JavaPsiFacade.getInstance((Project)refElement.getProject()).findClass(qualifiedName, refElement.getResolveScope());
            }
            if (refElement instanceof LightRecordMember) {
                return ((LightRecordMember)refElement).getRecordComponent();
            }
            if (refElement instanceof LightRecordCanonicalConstructor) {
                return ((LightRecordCanonicalConstructor)refElement).getContainingClass();
            }
        }
        return super.adjustReferenceOrReferencedElement(file, editor, offset, flags, refElement);
    }

    @Nullable
    public PsiElement getNamedElement(@NotNull PsiElement element) {
        if (element instanceof PsiIdentifier) {
            PsiElement grand;
            PsiElement parent = element.getParent();
            if (parent instanceof PsiClass && element.equals(((PsiClass)parent).getNameIdentifier()) || parent instanceof PsiVariable && element.equals(((PsiVariable)parent).getNameIdentifier()) || parent instanceof PsiMethod && element.equals(((PsiMethod)parent).getNameIdentifier()) || parent instanceof PsiLabeledStatement && element.equals(((PsiLabeledStatement)parent).getLabelIdentifier())) {
                return parent;
            }
            if (parent instanceof PsiJavaModuleReferenceElement && (grand = parent.getParent()) instanceof PsiJavaModule) {
                return grand;
            }
        }
        return null;
    }

    @Nullable
    public static PsiReferenceExpression findReferenceExpression(Editor editor) {
        PsiReference ref = TargetElementUtil.findReference((Editor)editor);
        return ref instanceof PsiReferenceExpression ? (PsiReferenceExpression)ref : null;
    }

    @Nullable
    public PsiElement adjustReference(@NotNull PsiReference ref) {
        PsiElement parent = ref.getElement().getParent();
        if (parent instanceof PsiMethodCallExpression) {
            return parent;
        }
        return super.adjustReference(ref);
    }

    @Nullable
    public PsiElement adjustElement(Editor editor, int flags, @Nullable PsiElement element, @Nullable PsiElement contextElement) {
        if (element instanceof PsiAnonymousClass) {
            return ((PsiAnonymousClass)element).getBaseClassType().resolve();
        }
        return element;
    }

    @Nullable
    public Collection<PsiElement> getTargetCandidates(@NotNull PsiReference reference) {
        PsiElement parent = reference.getElement().getParent();
        if (parent instanceof PsiMethodCallExpression || parent instanceof PsiNewExpression && !((PsiNewExpression)parent).isArrayCreation()) {
            PsiElement referee;
            PsiExpression qualifier;
            PsiCallExpression callExpr = (PsiCallExpression)parent;
            boolean allowStatics = false;
            PsiExpression psiExpression = qualifier = callExpr instanceof PsiMethodCallExpression ? ((PsiMethodCallExpression)callExpr).getMethodExpression().getQualifierExpression() : ((PsiNewExpression)callExpr).getQualifier();
            if (qualifier == null) {
                allowStatics = true;
            } else if (qualifier instanceof PsiJavaCodeReferenceElement && (referee = ((PsiJavaCodeReferenceElement)qualifier).advancedResolve(true).getElement()) instanceof PsiClass) {
                allowStatics = true;
            }
            PsiResolveHelper helper = JavaPsiFacade.getInstance((Project)parent.getProject()).getResolveHelper();
            PsiElement[] candidates = PsiUtil.mapElements((ResolveResult[])helper.getReferencedMethodCandidates(callExpr, false));
            LinkedHashSet<PsiElement> methods = new LinkedHashSet<PsiElement>();
            for (PsiElement candidate1 : candidates) {
                PsiMethod candidate = (PsiMethod)candidate1;
                if (candidate.hasModifierProperty("static") && !allowStatics) continue;
                List<PsiMethod> supers = Arrays.asList(candidate.findSuperMethods());
                if (supers.isEmpty()) {
                    methods.add((PsiElement)candidate);
                    continue;
                }
                methods.addAll(supers);
            }
            return methods;
        }
        return super.getTargetCandidates(reference);
    }

    @Nullable
    public PsiElement getGotoDeclarationTarget(@NotNull PsiElement element, @Nullable PsiElement navElement) {
        PsiMethod method;
        if (navElement == element && element instanceof PsiCompiledElement && element instanceof PsiMethod && (method = (PsiMethod)element).isConstructor() && method.getParameterList().isEmpty()) {
            PsiElement navClass;
            PsiClass aClass = method.getContainingClass();
            PsiElement psiElement = navClass = aClass == null ? null : aClass.getNavigationElement();
            if (aClass != navClass) {
                return navClass;
            }
        }
        return super.getGotoDeclarationTarget(element, navElement);
    }

    public boolean includeSelfInGotoImplementation(@NotNull PsiElement element) {
        if (element instanceof PsiModifierListOwner && ((PsiModifierListOwner)element).hasModifierProperty("abstract")) {
            return false;
        }
        return super.includeSelfInGotoImplementation(element);
    }

    public boolean acceptImplementationForReference(@Nullable PsiReference reference, @NotNull PsiElement element) {
        if (reference instanceof PsiReferenceExpression && element instanceof PsiMember) {
            return JavaTargetElementEvaluator.getClassesWithMember(reference, (PsiMember)element) != null;
        }
        return super.acceptImplementationForReference(reference, element);
    }

    private static PsiClass @Nullable [] getClassesWithMember(final PsiReference reference, final PsiMember member) {
        return (PsiClass[])ApplicationManager.getApplication().runReadAction((Computable)new Computable<PsiClass[]>(){

            public PsiClass[] compute() {
                PsiClass psiClass;
                PsiClass containingClass = member.getContainingClass();
                PsiExpression expression2 = ((PsiReferenceExpression)reference).getQualifierExpression();
                if (reference instanceof PsiMethodReferenceExpression) {
                    psiClass = PsiMethodReferenceUtil.getQualifierResolveResult((PsiMethodReferenceExpression)((PsiMethodReferenceExpression)reference)).getContainingClass();
                } else if (expression2 != null) {
                    psiClass = PsiUtil.resolveClassInType((PsiType)expression2.getType());
                } else if (member instanceof PsiClass) {
                    psiClass = (PsiClass)member;
                    PsiElement resolve2 = ((PsiReferenceExpression)reference).advancedResolve(true).getElement();
                    if (resolve2 instanceof PsiClass) {
                        containingClass = (PsiClass)resolve2;
                    }
                } else {
                    psiClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)((PsiReferenceExpression)reference), PsiClass.class);
                }
                if (containingClass == null && psiClass == null) {
                    return PsiClass.EMPTY_ARRAY;
                }
                if (containingClass != null) {
                    PsiClass[] inheritors = this.getInheritors(containingClass, psiClass, new HashSet());
                    return inheritors.length == 0 ? null : inheritors;
                }
                return null;
            }

            private PsiClass[] getInheritors(PsiClass containingClass, PsiClass psiClass, Set<? super PsiClass> visited) {
                if (psiClass instanceof PsiTypeParameter) {
                    ArrayList result = new ArrayList();
                    for (PsiClassType classType : psiClass.getExtendsListTypes()) {
                        PsiClass aClass = classType.resolve();
                        if (aClass == null || !visited.add((PsiClass)aClass)) continue;
                        ContainerUtil.addAll(result, (Object[])this.getInheritors(containingClass, aClass, visited));
                    }
                    return result.toArray(PsiClass.EMPTY_ARRAY);
                }
                PsiElementFindProcessor<PsiClass> processor1 = new PsiElementFindProcessor<PsiClass>(containingClass);
                while (psiClass != null) {
                    if (!(processor1.process(psiClass) && ClassInheritorsSearch.search((PsiClass)containingClass).forEach(new PsiElementFindProcessor<PsiClass>(psiClass)) && ClassInheritorsSearch.search((PsiClass)psiClass).forEach(processor1))) {
                        return new PsiClass[]{psiClass};
                    }
                    psiClass = psiClass.getContainingClass();
                }
                return PsiClass.EMPTY_ARRAY;
            }
        });
    }

    @Nullable
    public SearchScope getSearchScope(Editor editor, @NotNull PsiElement element) {
        PsiReferenceExpression referenceExpression;
        PsiReferenceExpression psiReferenceExpression = referenceExpression = editor != null ? JavaTargetElementEvaluator.findReferenceExpression(editor) : null;
        if (referenceExpression != null && element instanceof PsiMethod) {
            if (!PsiUtil.canBeOverridden((PsiMethod)((PsiMethod)element))) {
                return element.getUseScope();
            }
            PsiClass[] memberClass = JavaTargetElementEvaluator.getClassesWithMember((PsiReference)referenceExpression, (PsiMember)element);
            if (memberClass != null && memberClass.length == 1) {
                PsiClass aClass = memberClass[0];
                return (SearchScope)CachedValuesManager.getCachedValue((PsiElement)aClass, () -> new CachedValueProvider.Result((Object)JavaTargetElementEvaluator.getHierarchyScope(aClass, aClass.getUseScope()), new Object[]{PsiModificationTracker.MODIFICATION_COUNT}));
            }
        }
        return super.getSearchScope(editor, element);
    }

    @NotNull
    public static SearchScope getHierarchyScope(@NotNull PsiClass aClass, @NotNull SearchScope scope) {
        ArrayList<PsiClass> classesToSearch = new ArrayList<PsiClass>();
        classesToSearch.add(aClass);
        classesToSearch.addAll(ClassInheritorsSearch.search((PsiClass)aClass, (SearchScope)scope, (boolean)true).findAll());
        HashSet supers = new HashSet();
        for (PsiClass psiClass : classesToSearch) {
            supers.addAll(InheritanceUtil.getSuperClasses((PsiClass)psiClass));
        }
        ArrayList<Object> elements = new ArrayList<Object>();
        elements.addAll(classesToSearch);
        elements.addAll(supers);
        elements.addAll(FunctionalExpressionSearch.search((PsiClass)aClass, (SearchScope)scope).findAll());
        return new LocalSearchScope(PsiUtilCore.toPsiElementArray(elements));
    }

    private static class PsiElementFindProcessor<T extends PsiClass>
    implements Processor<T> {
        private final T myElement;

        PsiElementFindProcessor(T t) {
            this.myElement = t;
        }

        public boolean process(T t) {
            if (InheritanceUtil.isInheritorOrSelf(t, this.myElement, (boolean)true)) {
                return false;
            }
            return !this.myElement.getManager().areElementsEquivalent(this.myElement, t);
        }
    }
}

