/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEmptyStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiLabeledStatement;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiLoopStatement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiParameterListOwner;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.PsiSynchronizedStatement;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.SmartList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockUtils {
    public static PsiStatement addBefore(PsiStatement anchor, PsiStatement ... newStatements) {
        if (newStatements.length == 0) {
            throw new IllegalArgumentException();
        }
        PsiStatement oldStatement = anchor;
        PsiElement parent = oldStatement.getParent();
        while (parent instanceof PsiLabeledStatement) {
            oldStatement = (PsiStatement)parent;
            parent = oldStatement.getParent();
        }
        if (newStatements.length == 1 && oldStatement instanceof PsiEmptyStatement) {
            return (PsiStatement)oldStatement.replace((PsiElement)newStatements[0]);
        }
        if (!(parent instanceof PsiCodeBlock)) {
            oldStatement = BlockUtils.expandSingleStatementToBlockStatement(oldStatement);
            parent = oldStatement.getParent();
        }
        PsiElement result = null;
        for (PsiStatement statement : newStatements) {
            result = parent.addBefore((PsiElement)statement, (PsiElement)oldStatement);
        }
        return (PsiStatement)result;
    }

    public static PsiStatement addAfter(PsiStatement anchor, PsiStatement newStatement) {
        PsiStatement oldStatement = anchor;
        PsiElement parent = oldStatement.getParent();
        while (parent instanceof PsiLabeledStatement) {
            oldStatement = (PsiStatement)parent;
            parent = oldStatement.getParent();
        }
        if (!(parent instanceof PsiCodeBlock)) {
            oldStatement = BlockUtils.expandSingleStatementToBlockStatement(oldStatement);
            parent = oldStatement.getParent();
        }
        return (PsiStatement)parent.addAfter((PsiElement)newStatement, (PsiElement)oldStatement);
    }

    public static <T extends PsiStatement> T expandSingleStatementToBlockStatement(@NotNull T statement) {
        if (statement instanceof PsiBlockStatement) {
            return statement;
        }
        PsiBlockStatement blockStatement = (PsiBlockStatement)JavaPsiFacade.getElementFactory((Project)statement.getProject()).createStatementFromText("{\n}", statement);
        blockStatement.getCodeBlock().add(statement);
        PsiBlockStatement result = (PsiBlockStatement)statement.replace((PsiElement)blockStatement);
        PsiElement sibling = result.getNextSibling();
        if (sibling instanceof PsiWhiteSpace && PsiUtil.isJavaToken((PsiElement)sibling.getNextSibling(), (IElementType)JavaTokenType.ELSE_KEYWORD)) {
            sibling.delete();
        }
        return (T)result.getCodeBlock().getStatements()[0];
    }

    @Nullable
    public static PsiElement getBody(PsiElement element) {
        if (element instanceof PsiLoopStatement) {
            PsiStatement loopBody = ((PsiLoopStatement)element).getBody();
            return loopBody instanceof PsiBlockStatement ? ((PsiBlockStatement)loopBody).getCodeBlock() : loopBody;
        }
        if (element instanceof PsiParameterListOwner) {
            return ((PsiParameterListOwner)element).getBody();
        }
        if (element instanceof PsiSynchronizedStatement) {
            return ((PsiSynchronizedStatement)element).getBody();
        }
        if (element instanceof PsiSwitchStatement) {
            return ((PsiSwitchStatement)element).getBody();
        }
        if (element instanceof PsiClassInitializer) {
            return ((PsiClassInitializer)element).getBody();
        }
        if (element instanceof PsiCatchSection) {
            return ((PsiCatchSection)element).getCatchBlock();
        }
        throw new AssertionError((Object)("can't get body from " + element));
    }

    public static void unwrapTryBlock(PsiTryStatement tryStatement) {
        PsiElement last;
        PsiCodeBlock tryBlock = tryStatement.getTryBlock();
        if (tryBlock == null) {
            return;
        }
        PsiElement parent = tryStatement.getParent();
        boolean singleStatement = false;
        if (parent instanceof PsiStatement) {
            PsiStatement[] statements = tryBlock.getStatements();
            if (statements.length == 1 && !(statements[0] instanceof PsiDeclarationStatement)) {
                singleStatement = true;
            } else {
                tryStatement = BlockUtils.expandSingleStatementToBlockStatement(tryStatement);
            }
        } else if (parent instanceof PsiCodeBlock) {
            if (BlockUtils.containsConflictingDeclarations(tryBlock, (PsiCodeBlock)parent)) {
                tryStatement = BlockUtils.expandSingleStatementToBlockStatement(tryStatement);
            }
        } else {
            return;
        }
        tryBlock = tryStatement.getTryBlock();
        assert (tryBlock != null);
        PsiElement first = singleStatement ? BlockUtils.skip(tryBlock.getFirstBodyElement(), true) : tryBlock.getFirstBodyElement();
        PsiElement psiElement = last = singleStatement ? BlockUtils.skip(tryBlock.getLastBodyElement(), false) : tryBlock.getLastBodyElement();
        assert (first != null && last != null);
        tryStatement.getParent().addRangeBefore(first, last, (PsiElement)tryStatement);
        tryStatement.delete();
    }

    private static PsiElement skip(PsiElement element, boolean forward) {
        if (!(element instanceof PsiWhiteSpace)) {
            return element;
        }
        return forward ? element.getNextSibling() : element.getPrevSibling();
    }

    public static boolean containsConflictingDeclarations(@NotNull PsiCodeBlock block, @NotNull PsiCodeBlock parentBlock) {
        PsiStatement[] statements = block.getStatements();
        if (statements.length == 0) {
            return false;
        }
        int endOffset = block.getTextRange().getEndOffset();
        List affectedBlocks = (List)SyntaxTraverser.psiTraverser((PsiElement)parentBlock).filter(PsiCodeBlock.class).filter(cb -> cb.getTextRange().getEndOffset() > endOffset).addAllTo((Collection)new SmartList());
        Project project = block.getProject();
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)project);
        PsiResolveHelper resolveHelper = facade.getResolveHelper();
        for (PsiStatement statement : statements) {
            PsiElement[] variables;
            if (!(statement instanceof PsiDeclarationStatement)) continue;
            PsiDeclarationStatement declaration2 = (PsiDeclarationStatement)statement;
            for (PsiElement variable : variables = declaration2.getDeclaredElements()) {
                if (!(variable instanceof PsiLocalVariable)) continue;
                PsiLocalVariable localVariable = (PsiLocalVariable)variable;
                String variableName2 = localVariable.getName();
                for (PsiCodeBlock codeBlock : affectedBlocks) {
                    PsiVariable target = resolveHelper.resolveAccessibleReferencedVariable(variableName2, (PsiElement)codeBlock);
                    if (target instanceof PsiLocalVariable) {
                        return true;
                    }
                    if (!(target instanceof PsiField)) continue;
                    for (PsiCodeBlock affectedBlock : affectedBlocks) {
                        if (SyntaxTraverser.psiTraverser((PsiElement)affectedBlock).filter(PsiReferenceExpression.class).filter(ref -> ref.resolve() == target).isEmpty()) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public static void inlineCodeBlock(@NotNull PsiStatement orig, PsiCodeBlock codeBlock) {
        PsiJavaToken lBrace = codeBlock.getLBrace();
        PsiJavaToken rBrace = codeBlock.getRBrace();
        if (lBrace == null || rBrace == null) {
            return;
        }
        PsiElement[] children = codeBlock.getChildren();
        if (children.length > 2) {
            PsiElement added = orig.getParent().addRangeBefore(children[1], children[children.length - 2], (PsiElement)orig);
            CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((PsiManager)orig.getManager());
            codeStyleManager.reformat(added);
        }
        orig.delete();
    }

    public static PsiBlockStatement createBlockStatement(Project project) {
        return (PsiBlockStatement)JavaPsiFacade.getElementFactory((Project)project).createStatementFromText("{}", null);
    }
}

