/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options;

import com.intellij.application.options.codeStyle.OptionTreeWithPreviewPanel;
import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.java.JavaBundle;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.ui.OnePixelDivider;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsCustomizable;
import com.intellij.psi.codeStyle.JavaCodeStyleSettings;
import com.intellij.psi.codeStyle.LanguageCodeStyleSettingsProvider;
import com.intellij.ui.border.CustomLineBorder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaDocFormattingPanel
extends OptionTreeWithPreviewPanel {
    private JCheckBox myEnableCheckBox;
    private final JPanel myJavaDocPanel = new JPanel(new BorderLayout());

    public JavaDocFormattingPanel(CodeStyleSettings settings) {
        super(settings);
        this.init();
    }

    protected void init() {
        super.init();
        this.myEnableCheckBox = new JCheckBox(JavaBundle.message((String)"checkbox.enable.javadoc.formatting", (Object[])new Object[0]));
        this.myEnableCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JavaDocFormattingPanel.this.update();
            }
        });
        this.myPanel.setBorder((Border)new CustomLineBorder(OnePixelDivider.BACKGROUND, 1, 0, 0, 0));
        this.myJavaDocPanel.add("Center", this.myPanel);
        this.myJavaDocPanel.add((Component)this.myEnableCheckBox, "North");
    }

    public LanguageCodeStyleSettingsProvider.SettingsType getSettingsType() {
        return LanguageCodeStyleSettingsProvider.SettingsType.LANGUAGE_SPECIFIC;
    }

    public JComponent getPanel() {
        return this.myJavaDocPanel;
    }

    private void update() {
        JavaDocFormattingPanel.setEnabled(this.getPanel(), this.myEnableCheckBox.isSelected());
        this.myEnableCheckBox.setEnabled(true);
    }

    protected void initTables() {
        this.initCustomOptions(JavaDocFormattingPanel.getAlignmentGroup());
        this.initCustomOptions(JavaDocFormattingPanel.getBlankLinesGroup());
        this.initCustomOptions(JavaDocFormattingPanel.getInvalidTagsGroup());
        this.initBooleanField("WRAP_COMMENTS", JavaBundle.message((String)"checkbox.wrap.at.right.margin", (Object[])new Object[0]), JavaDocFormattingPanel.getOtherGroup());
        this.initCustomOptions(JavaDocFormattingPanel.getOtherGroup());
    }

    protected int getRightMargin() {
        return 47;
    }

    protected String getPreviewText() {
        return "package sample;\npublic class Sample {\n  /**\n   * This is a method description that is long enough to exceed right margin.\n   *\n   * Another paragraph of the description placed after blank line.\n   * <p/>\n   * Line with manual\n   * line feed.\n   * @param i short named parameter description\n   * @param longParameterName long named parameter description\n   * @param missingDescription\n   * @return return description.\n   * @throws XXXException description.\n   * @throws YException description.\n   * @throws ZException\n   *\n   * @invalidTag   */\n  public abstract String sampleMethod(int i, int longParameterName, int missingDescription) throws XXXException, YException, ZException;\n\n  /** One-line comment */\n  public abstract String sampleMethod2();\n\n  /**\n   * Simple method description\n   * @return\n   */\n  public abstract String sampleMethod3();\n";
    }

    private static void setEnabled(JComponent c, boolean enabled) {
        Component[] children;
        c.setEnabled(enabled);
        for (Component child : children = c.getComponents()) {
            if (!(child instanceof JComponent)) continue;
            JavaDocFormattingPanel.setEnabled((JComponent)child, enabled);
        }
    }

    public void apply(CodeStyleSettings settings) {
        super.apply(settings);
        ((JavaCodeStyleSettings)settings.getCustomSettings(JavaCodeStyleSettings.class)).ENABLE_JAVADOC_FORMATTING = this.myEnableCheckBox.isSelected();
    }

    protected void resetImpl(CodeStyleSettings settings) {
        super.resetImpl(settings);
        this.myEnableCheckBox.setSelected(((JavaCodeStyleSettings)settings.getCustomSettings(JavaCodeStyleSettings.class)).ENABLE_JAVADOC_FORMATTING);
        this.update();
    }

    public boolean isModified(CodeStyleSettings settings) {
        return super.isModified(settings) || this.myEnableCheckBox.isSelected() != ((JavaCodeStyleSettings)settings.getCustomSettings(JavaCodeStyleSettings.class)).ENABLE_JAVADOC_FORMATTING;
    }

    @NotNull
    protected final FileType getFileType() {
        return JavaFileType.INSTANCE;
    }

    protected void customizeSettings() {
        LanguageCodeStyleSettingsProvider provider = LanguageCodeStyleSettingsProvider.forLanguage((Language)JavaLanguage.INSTANCE);
        if (provider != null) {
            provider.customizeSettings((CodeStyleSettingsCustomizable)this, this.getSettingsType());
        }
    }

    protected String getTabTitle() {
        return JavaBundle.message((String)"title.javadoc", (Object[])new Object[0]);
    }

    @Nullable
    public Language getDefaultLanguage() {
        return JavaLanguage.INSTANCE;
    }

    public static String getOtherGroup() {
        return JavaBundle.message((String)"group.javadoc.other", (Object[])new Object[0]);
    }

    public static String getInvalidTagsGroup() {
        return JavaBundle.message((String)"group.javadoc.invalid.tags", (Object[])new Object[0]);
    }

    public static String getBlankLinesGroup() {
        return JavaBundle.message((String)"group.javadoc.blank.lines", (Object[])new Object[0]);
    }

    public static String getAlignmentGroup() {
        return JavaBundle.message((String)"group.javadoc.alignment", (Object[])new Object[0]);
    }
}

