/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.android;

import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.android.AndroidJpsUtil;
import org.jetbrains.jps.android.builder.AndroidPackagingBuildTarget;
import org.jetbrains.jps.android.model.JpsAndroidModuleExtension;
import org.jetbrains.jps.android.model.impl.JpsAndroidFinalPackageElement;
import org.jetbrains.jps.builders.BuildTarget;
import org.jetbrains.jps.builders.TargetOutputIndex;
import org.jetbrains.jps.incremental.artifacts.builders.LayoutElementBuilderService;
import org.jetbrains.jps.incremental.artifacts.instructions.ArtifactCompilerInstructionCreator;
import org.jetbrains.jps.incremental.artifacts.instructions.ArtifactInstructionsBuilderContext;
import org.jetbrains.jps.model.java.JpsJavaExtensionService;
import org.jetbrains.jps.model.module.JpsModule;
import org.jetbrains.jps.model.module.JpsModuleReference;

public class AndroidFinalPackageElementBuilder
extends LayoutElementBuilderService<JpsAndroidFinalPackageElement> {
    public AndroidFinalPackageElementBuilder() {
        super(JpsAndroidFinalPackageElement.class);
    }

    public void generateInstructions(JpsAndroidFinalPackageElement element, ArtifactCompilerInstructionCreator instructionCreator, ArtifactInstructionsBuilderContext builderContext) {
        String apkPath = AndroidFinalPackageElementBuilder.getApkPath(element);
        if (apkPath != null) {
            instructionCreator.addExtractDirectoryInstruction(new File(apkPath), "");
        }
    }

    public Collection<? extends BuildTarget<?>> getDependencies(@NotNull JpsAndroidFinalPackageElement element, TargetOutputIndex outputIndex) {
        JpsModule module = (JpsModule)element.getModuleReference().resolve();
        return module != null ? Collections.singletonList(new AndroidPackagingBuildTarget(module)) : Collections.emptyList();
    }

    @Nullable
    private static String getApkPath(JpsAndroidFinalPackageElement element) {
        JpsModule module;
        JpsModuleReference ref = element.getModuleReference();
        JpsModule jpsModule = module = ref != null ? (JpsModule)ref.resolve() : null;
        if (module == null) {
            return null;
        }
        JpsAndroidModuleExtension extension = AndroidJpsUtil.getExtension(module);
        if (extension == null) {
            return null;
        }
        return AndroidFinalPackageElementBuilder.getApkPath(extension);
    }

    @Nullable
    public static String getApkPath(@NotNull JpsAndroidModuleExtension extension) {
        File moduleOutputDir = JpsJavaExtensionService.getInstance().getOutputDirectory(extension.getModule(), false);
        if (moduleOutputDir == null) {
            return null;
        }
        String apkPath = AndroidJpsUtil.getApkPath(extension, moduleOutputDir);
        return apkPath != null ? FileUtil.toSystemIndependentName((String)apkPath) : null;
    }
}

