/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcsUtil;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangeListManagerEx;
import com.intellij.openapi.vcs.changes.IgnoredFileContentProvider;
import com.intellij.openapi.vcs.changes.IgnoredFileGenerator;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.WaitForProgressToShow;
import com.intellij.vcsUtil.VcsUtil;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.SystemIndependent;

public final class VcsImplUtil {
    private static final Logger LOG = Logger.getInstance(VcsImplUtil.class);

    public static void showErrorMessage(Project project, String message, String title2) {
        Runnable task2 = () -> Messages.showErrorDialog((Project)project, (String)message, (String)title2);
        WaitForProgressToShow.runOrInvokeLaterAboveProgress((Runnable)task2, null, (Project)project);
    }

    @NotNull
    public static String getShortVcsRootName(@NotNull Project project, @NotNull VirtualFile root) {
        String relativePath;
        VirtualFile projectDir = project.getBaseDir();
        String repositoryPath = root.getPresentableUrl();
        if (projectDir != null && (relativePath = VfsUtilCore.getRelativePath((VirtualFile)root, (VirtualFile)projectDir, (char)File.separatorChar)) != null) {
            repositoryPath = relativePath;
        }
        return repositoryPath.isEmpty() ? root.getName() : repositoryPath;
    }

    @Nullable
    public static IgnoredFileContentProvider findIgnoredFileContentProvider(@NotNull AbstractVcs vcs) {
        return VcsImplUtil.findIgnoredFileContentProvider(vcs.getProject(), vcs.getKeyInstanceMethod());
    }

    @Nullable
    public static IgnoredFileContentProvider findIgnoredFileContentProvider(@NotNull Project project, @NotNull VcsKey vcsKey) {
        IgnoredFileContentProvider ignoreContentProvider = IgnoredFileContentProvider.IGNORE_FILE_CONTENT_PROVIDER.extensions((AreaInstance)project).filter(provider -> provider.getSupportedVcs().equals((Object)vcsKey)).findFirst().orElse(null);
        if (ignoreContentProvider == null) {
            LOG.debug("Cannot get ignore content provider for vcs " + vcsKey.getName());
            return null;
        }
        return ignoreContentProvider;
    }

    public static void proposeUpdateIgnoreFile(@NotNull Project project, @NotNull AbstractVcs vcs, @NotNull VirtualFile ignoreFileRoot) {
        VcsImplUtil.generateIgnoreFile(project, vcs, ignoreFileRoot, true);
    }

    public static void generateIgnoreFileIfNeeded(@NotNull Project project, @NotNull AbstractVcs vcs, @NotNull VirtualFile ignoreFileRoot) {
        VcsImplUtil.generateIgnoreFile(project, vcs, ignoreFileRoot, false);
    }

    private static void generateIgnoreFile(@NotNull Project project, @NotNull AbstractVcs vcs, @NotNull VirtualFile ignoreFileRoot, boolean notify) {
        IgnoredFileGenerator ignoredFileGenerator = (IgnoredFileGenerator)project.getService(IgnoredFileGenerator.class);
        if (ignoredFileGenerator == null) {
            LOG.debug("Cannot find ignore file ignoredFileGenerator for " + vcs.getName() + " VCS");
            return;
        }
        ignoredFileGenerator.generateFile(ignoreFileRoot, vcs, notify);
    }

    private static boolean isFileSharedInVcs(@NotNull Project project, @NotNull ChangeListManagerEx changeListManager, @NotNull String filePath) {
        VirtualFile file = LocalFileSystem.getInstance().findFileByPath(filePath);
        if (file == null) {
            return false;
        }
        FileStatus fileStatus = changeListManager.getStatus(file);
        return VcsUtil.isFileUnderVcs((Project)project, (String)filePath) && fileStatus != FileStatus.UNKNOWN && fileStatus != FileStatus.IGNORED;
    }

    public static boolean isProjectSharedInVcs(@NotNull Project project) {
        return (Boolean)ReadAction.compute(() -> {
            if (project.isDisposed()) {
                return false;
            }
            @SystemIndependent String projectFilePath = project.getProjectFilePath();
            ChangeListManagerEx changeListManager = (ChangeListManagerEx)ChangeListManager.getInstance((Project)project);
            return !changeListManager.isInUpdate() && projectFilePath != null && VcsImplUtil.isFileSharedInVcs(project, changeListManager, projectFilePath);
        });
    }
}

