/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.visible.filters;

import com.intellij.vcs.log.VcsLogFilter;
import com.intellij.vcs.log.VcsLogFilterCollection;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class VcsLogFilterCollectionImpl
implements VcsLogFilterCollection {
    @NotNull
    private final Map<VcsLogFilterCollection.FilterKey, VcsLogFilter> myFilters = new TreeMap<VcsLogFilterCollection.FilterKey, VcsLogFilter>(Comparator.comparing(key -> key.getName()));

    VcsLogFilterCollectionImpl(@NotNull Collection<? extends VcsLogFilter> filters) {
        for (VcsLogFilter vcsLogFilter : filters) {
            this.myFilters.put(vcsLogFilter.getKey(), vcsLogFilter);
        }
    }

    @Nullable
    public <T extends VcsLogFilter> T get(@NotNull VcsLogFilterCollection.FilterKey<T> key) {
        return (T)this.myFilters.get(key);
    }

    @NotNull
    public Collection<VcsLogFilter> getFilters() {
        return this.myFilters.values();
    }

    public String toString() {
        return "filters: (" + this.myFilters + ")";
    }
}

