/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.details.commit;

import com.intellij.openapi.vcs.ui.FontUtil;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.panels.Wrapper;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.vcs.log.VcsLogBundle;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.VcsRefType;
import com.intellij.vcs.log.ui.details.commit.CommitDetailsPanelKt;
import com.intellij.vcs.log.ui.frame.WrappedFlowLayout;
import com.intellij.vcs.log.ui.render.LabelIcon;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReferencesPanel
extends JPanel {
    public static final int H_GAP = 4;
    protected static final int V_GAP = 0;
    private final int myRefsLimit;
    @NotNull
    private List<VcsRef> myReferences;
    @NotNull
    protected MultiMap<VcsRefType, VcsRef> myGroupedVisibleReferences;

    public ReferencesPanel() {
        this((LayoutManager)new WrappedFlowLayout(JBUIScale.scale((int)4), JBUIScale.scale((int)0)), -1);
    }

    public ReferencesPanel(LayoutManager layout, int limit) {
        super(layout);
        this.myRefsLimit = limit;
        this.myReferences = Collections.emptyList();
        this.myGroupedVisibleReferences = MultiMap.create();
        this.setOpaque(false);
    }

    public void setReferences(@NotNull List<VcsRef> references) {
        if (this.myReferences.equals(references)) {
            return;
        }
        this.myReferences = references;
        List visibleReferences = this.myRefsLimit > 0 ? ContainerUtil.getFirstItems(this.myReferences, (int)this.myRefsLimit) : this.myReferences;
        this.myGroupedVisibleReferences = ContainerUtil.groupBy((Iterable)visibleReferences, VcsRef::getType);
        this.update();
    }

    public void update() {
        this.removeAll();
        int height = this.getIconHeight();
        JBLabel firstLabel = null;
        for (Map.Entry typeAndRefs : this.myGroupedVisibleReferences.entrySet()) {
            VcsRefType type = (VcsRefType)typeAndRefs.getKey();
            Collection refs = (Collection)typeAndRefs.getValue();
            int refIndex = 0;
            for (VcsRef reference : refs) {
                Icon icon2 = this.createIcon(type, refs, refIndex, height);
                String ending = refIndex != refs.size() - 1 ? "," : "";
                String text2 = reference.getName() + ending;
                JBLabel label = this.createLabel(text2, icon2);
                if (firstLabel == null) {
                    firstLabel = label;
                    this.add((Component)label);
                } else {
                    this.addWrapped(label, firstLabel);
                }
                ++refIndex;
            }
        }
        if (this.getHiddenReferencesSize() > 0) {
            JBLabel label = this.createRestLabel(this.getHiddenReferencesSize());
            this.addWrapped(label, Objects.requireNonNull(firstLabel));
        }
        this.setVisible(!this.myGroupedVisibleReferences.isEmpty());
        this.revalidate();
        this.repaint();
    }

    private int getHiddenReferencesSize() {
        return this.myRefsLimit > 0 ? this.myReferences.size() - Math.min(this.myReferences.size(), this.myRefsLimit) : 0;
    }

    protected int getIconHeight() {
        return this.getFontMetrics(this.getLabelsFont()).getHeight();
    }

    @NotNull
    protected JBLabel createRestLabel(int restSize) {
        return this.createLabel(VcsLogBundle.message((String)"vcs.log.details.references.more.label", (Object[])new Object[]{restSize}), null);
    }

    @Nullable
    protected Icon createIcon(@NotNull VcsRefType type, @NotNull Collection<VcsRef> refs, int refIndex, int height) {
        if (refIndex == 0) {
            Color color = type.getBackgroundColor();
            return new LabelIcon(this, height, this.getBackground(), refs.size() > 1 ? ContainerUtil.newArrayList((Object[])new Color[]{color, color}) : Collections.singletonList(color));
        }
        return null;
    }

    private void addWrapped(@NotNull JBLabel label, @NotNull JBLabel referent) {
        Wrapper wrapper = new Wrapper((JComponent)label);
        wrapper.setVerticalSizeReferent((JComponent)referent);
        this.add((Component)wrapper);
    }

    @NotNull
    protected JBLabel createLabel(@Nls @NotNull String text2, @Nullable Icon icon2) {
        JBLabel label = new JBLabel(text2, icon2, 2);
        label.setFont(this.getLabelsFont());
        label.setIconTextGap(0);
        label.setHorizontalAlignment(2);
        label.setVerticalTextPosition(0);
        label.setCopyable(true);
        return label;
    }

    @NotNull
    protected Font getLabelsFont() {
        return FontUtil.getCommitMetadataFont();
    }

    @Override
    public Dimension getMaximumSize() {
        return new Dimension(super.getMaximumSize().width, super.getPreferredSize().height);
    }

    @Override
    public Color getBackground() {
        return CommitDetailsPanelKt.getCommitDetailsBackground();
    }
}

