/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.actions;

import com.intellij.openapi.actionSystem.ActionButtonComponent;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.impl.AutoPopupSupportingListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.ui.popup.util.PopupState;
import com.intellij.vcs.log.VcsLogDataKeys;
import com.intellij.vcs.log.VcsLogUi;
import java.awt.Component;
import java.awt.event.InputEvent;
import org.jetbrains.annotations.NotNull;

public class VcsLogToolbarPopupActionGroup
extends DefaultActionGroup {
    private final PopupState myPopupState = new PopupState();

    public boolean isDumbAware() {
        return true;
    }

    public boolean canBePerformed(@NotNull DataContext context) {
        return true;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (this.myPopupState.isRecentlyHidden()) {
            return;
        }
        ListPopup popup = JBPopupFactory.getInstance().createActionGroupPopup(null, (ActionGroup)this, e.getDataContext(), JBPopupFactory.ActionSelectionAid.MNEMONICS, true, "Vcs.Log.Toolbar.Popup");
        popup.addListener((JBPopupListener)this.myPopupState);
        AutoPopupSupportingListener.installOn((JBPopup)popup);
        InputEvent inputEvent = e.getInputEvent();
        if (inputEvent == null) {
            popup.showInFocusCenter();
        } else {
            Component component = inputEvent.getComponent();
            if (component instanceof ActionButtonComponent) {
                popup.showUnderneathOf(component);
            } else {
                popup.showInCenterOf(component);
            }
        }
    }

    public void update(@NotNull AnActionEvent e) {
        Project project = e.getProject();
        VcsLogUi logUi = (VcsLogUi)e.getData(VcsLogDataKeys.VCS_LOG_UI);
        e.getPresentation().setEnabledAndVisible(project != null && logUi != null);
    }
}

