/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.actions;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.util.textCompletion.TextCompletionValueDescriptor;
import com.intellij.util.textCompletion.ValuesCompletionProvider;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

public abstract class TwoStepCompletionProvider<T>
extends ValuesCompletionProvider<T> {
    private static final Logger LOG = Logger.getInstance(TwoStepCompletionProvider.class);
    private static final int TIMEOUT = 100;

    public TwoStepCompletionProvider(@NotNull TextCompletionValueDescriptor<T> presentation) {
        super(presentation, Collections.emptyList());
    }

    public void fillCompletionVariants(@NotNull CompletionParameters parameters, @NotNull String prefix, @NotNull CompletionResultSet result2) {
        this.addValues(result2, this.sortVariants(this.collectSync(result2)));
        Future future2 = ApplicationManager.getApplication().executeOnPooledThread(() -> this.sortVariants(this.collectAsync(result2)));
        while (true) {
            try {
                List moreValues;
                do {
                    ProgressManager.checkCanceled();
                } while ((moreValues = (List)future2.get(100L, TimeUnit.MILLISECONDS)) == null);
                this.addValues(result2, moreValues);
            }
            catch (InterruptedException | CancellationException e) {
            }
            catch (TimeoutException e) {
                continue;
            }
            catch (ExecutionException e) {
                LOG.error((Throwable)e);
            }
            catch (ProcessCanceledException e) {
                future2.cancel(true);
                throw e;
            }
            break;
        }
        result2.stopHere();
    }

    @NotNull
    private List<? extends T> sortVariants(@NotNull Stream<? extends T> result2) {
        return result2.sorted((Comparator<T>)this.myDescriptor).collect(Collectors.toList());
    }

    private void addValues(@NotNull CompletionResultSet result2, @NotNull Collection<? extends T> values) {
        for (T completionVariant : values) {
            result2.addElement(this.installInsertHandler(this.myDescriptor.createLookupBuilder(completionVariant)));
        }
    }

    @NotNull
    protected abstract Stream<? extends T> collectSync(@NotNull CompletionResultSet var1);

    @NotNull
    protected abstract Stream<? extends T> collectAsync(@NotNull CompletionResultSet var1);
}

