/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.actions;

import com.intellij.openapi.actionSystem.ActionButtonComponent;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.actionSystem.impl.AutoPopupSupportingListener;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.VcsLogBundle;
import com.intellij.vcs.log.VcsLogDataKeys;
import com.intellij.vcs.log.VcsLogUi;
import com.intellij.vcs.log.graph.PermanentGraph;
import com.intellij.vcs.log.impl.MainVcsLogUiProperties;
import com.intellij.vcs.log.impl.VcsLogUiProperties;
import com.intellij.vcs.log.ui.VcsLogInternalDataKeys;
import com.intellij.vcs.log.util.GraphSortPresentationUtil;
import icons.VcsLogIcons;
import java.awt.Component;
import org.jetbrains.annotations.NotNull;

public class IntelliSortChooserPopupAction
extends DumbAwareAction {
    public IntelliSortChooserPopupAction() {
        super(VcsLogBundle.messagePointer((String)"action.IntelliSortChooserPopupAction.text", (Object[])new Object[0]), VcsLogBundle.messagePointer((String)"action.IntelliSortChooserPopupAction.description", (Object[])new Object[0]), VcsLogIcons.IntelliSort);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        VcsLogUi logUI = (VcsLogUi)e.getRequiredData(VcsLogDataKeys.VCS_LOG_UI);
        VcsLogUiProperties properties = (VcsLogUiProperties)e.getRequiredData(VcsLogInternalDataKeys.LOG_UI_PROPERTIES);
        DefaultActionGroup settingsGroup = new DefaultActionGroup(ContainerUtil.map((Object[])PermanentGraph.SortType.values(), sortType -> new SelectIntelliSortTypeAction(logUI, properties, (PermanentGraph.SortType)sortType)));
        ListPopup popup = JBPopupFactory.getInstance().createActionGroupPopup(null, (ActionGroup)settingsGroup, e.getDataContext(), JBPopupFactory.ActionSelectionAid.MNEMONICS, true, "ToolwindowPopup");
        AutoPopupSupportingListener.installOn((JBPopup)popup);
        Component component = e.getInputEvent().getComponent();
        if (component instanceof ActionButtonComponent) {
            popup.showUnderneathOf(component);
        } else {
            popup.showInCenterOf(component);
        }
    }

    public void update(@NotNull AnActionEvent e) {
        super.update(e);
        VcsLogUiProperties properties = (VcsLogUiProperties)e.getData(VcsLogInternalDataKeys.LOG_UI_PROPERTIES);
        e.getPresentation().setEnabled(properties != null);
        if (properties != null && properties.exists(MainVcsLogUiProperties.BEK_SORT_TYPE)) {
            String sortName = GraphSortPresentationUtil.getLocalizedName(properties.get(MainVcsLogUiProperties.BEK_SORT_TYPE));
            String description = VcsLogBundle.message((String)"vcs.log.action.intellisort.title", (Object[])new Object[]{sortName});
            e.getPresentation().setDescription(description);
            e.getPresentation().setText(description);
        }
    }

    private static class SelectIntelliSortTypeAction
    extends ToggleAction
    implements DumbAware {
        private final PermanentGraph.SortType mySortType;
        private final VcsLogUi myUI;
        private final VcsLogUiProperties myProperties;

        SelectIntelliSortTypeAction(@NotNull VcsLogUi ui2, @NotNull VcsLogUiProperties properties, @NotNull PermanentGraph.SortType sortType) {
            super(() -> GraphSortPresentationUtil.getLocalizedName(sortType), () -> GraphSortPresentationUtil.getLocalizedDescription(sortType) + ".", null);
            this.myUI = ui2;
            this.myProperties = properties;
            this.mySortType = sortType;
        }

        public void update(@NotNull AnActionEvent e) {
            super.update(e);
            e.getPresentation().setEnabled(!this.myUI.getDataPack().isEmpty() && this.myProperties.exists(MainVcsLogUiProperties.BEK_SORT_TYPE));
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            return this.myProperties.exists(MainVcsLogUiProperties.BEK_SORT_TYPE) && this.myProperties.get(MainVcsLogUiProperties.BEK_SORT_TYPE).equals((Object)this.mySortType);
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            if (state && this.myProperties.exists(MainVcsLogUiProperties.BEK_SORT_TYPE)) {
                this.myProperties.set(MainVcsLogUiProperties.BEK_SORT_TYPE, this.mySortType);
            }
        }
    }
}

