/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ex.ToolWindowManagerListener;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.ui.content.ContentManagerListener;
import com.intellij.ui.content.TabbedContent;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.vcs.log.impl.PostponableLogRefresher;
import com.intellij.vcs.log.impl.VcsLogContentUtil;
import com.intellij.vcs.log.impl.VcsLogEditorUtilKt;
import com.intellij.vcs.log.impl.VcsLogManager;
import com.intellij.vcs.log.statistics.VcsLogUsageTriggerCollector;
import com.intellij.vcs.log.visible.VisiblePackRefresher;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class VcsLogTabsWatcher
implements Disposable {
    private static final Logger LOG = Logger.getInstance(VcsLogTabsWatcher.class);
    @NotNull
    private final Project myProject;
    @NotNull
    private final PostponableLogRefresher myRefresher;
    @NotNull
    private final Disposable myListenersDisposable = Disposer.newDisposable();

    public VcsLogTabsWatcher(@NotNull Project project, @NotNull PostponableLogRefresher refresher) {
        this.myProject = project;
        this.myRefresher = refresher;
        MessageBusConnection connection = project.getMessageBus().connect((Disposable)this);
        connection.subscribe(ToolWindowManagerListener.TOPIC, (Object)new MyToolWindowManagerListener());
        connection.subscribe(FileEditorManagerListener.FILE_EDITOR_MANAGER, (Object)new MyFileManagerListener());
        this.installContentListeners();
    }

    @NotNull
    public Disposable addTabToWatch(@NotNull String logId, @NotNull VisiblePackRefresher refresher, @NotNull VcsLogManager.LogWindowKind kind, boolean isClosedOnDispose) {
        PostponableLogRefresher.VcsLogWindow window;
        switch (kind) {
            case TOOL_WINDOW: {
                window = new VcsLogToolWindowTab(logId, refresher, isClosedOnDispose);
                break;
            }
            case EDITOR: {
                window = new VcsLogEditorTab(logId, refresher, isClosedOnDispose);
                break;
            }
            default: {
                window = new PostponableLogRefresher.VcsLogWindow(logId, refresher);
            }
        }
        return this.myRefresher.addLogWindow(window);
    }

    private void installContentListeners() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        ToolWindow toolWindow = this.getToolWindow();
        if (toolWindow != null) {
            VcsLogTabsWatcher.addContentManagerListener(toolWindow, new MyRefreshPostponedEventsListener(toolWindow), this.myListenersDisposable);
        }
    }

    private void removeContentListeners() {
        Disposer.dispose((Disposable)this.myListenersDisposable);
    }

    private void selectionChanged(@NotNull String tabId) {
        PostponableLogRefresher.VcsLogWindow logWindow = (PostponableLogRefresher.VcsLogWindow)ContainerUtil.find(this.myRefresher.getLogWindows(), window -> window.getId().equals(tabId));
        if (logWindow != null) {
            LOG.debug("Selected log window '" + logWindow + "'");
            VcsLogUsageTriggerCollector.triggerUsage(VcsLogUsageTriggerCollector.VcsLogEvent.TAB_NAVIGATED, null);
            this.myRefresher.refresherActivated(logWindow.getRefresher(), false);
        }
    }

    private void closeLogTabs() {
        ToolWindow window = this.getToolWindow();
        if (window != null) {
            List<String> toolWindowTabs = this.getToolWindowTabsToClose();
            for (String tabId : toolWindowTabs) {
                boolean closed = VcsLogContentUtil.closeLogTab(window.getContentManager(), tabId);
                LOG.assertTrue(closed, (Object)("Could not find content component for tab " + tabId + "\nExisting content: " + Arrays.toString(window.getContentManager().getContents()) + "\nTabs to close: " + toolWindowTabs));
            }
        }
        List<String> editorTabs = this.getEditorTabsToClose();
        boolean closed = VcsLogEditorUtilKt.closeLogTabs(this.myProject, editorTabs);
        LOG.assertTrue(closed, (Object)("Could not close tabs: " + editorTabs));
    }

    @NotNull
    private List<String> getToolWindowTabsToClose() {
        return ((StreamEx)StreamEx.of(this.myRefresher.getLogWindows()).select(VcsLogToolWindowTab.class).filter(VcsLogToolWindowTab::isClosedOnDispose)).map(PostponableLogRefresher.VcsLogWindow::getId).toList();
    }

    @NotNull
    private List<String> getEditorTabsToClose() {
        return ((StreamEx)StreamEx.of(this.myRefresher.getLogWindows()).select(VcsLogEditorTab.class).filter(VcsLogEditorTab::isClosedOnDispose)).map(PostponableLogRefresher.VcsLogWindow::getId).toList();
    }

    @Nullable
    private ToolWindow getToolWindow() {
        return ToolWindowManager.getInstance((Project)this.myProject).getToolWindow("Version Control");
    }

    public void dispose() {
        this.closeLogTabs();
        this.removeContentListeners();
    }

    @Nullable
    private static String getSelectedToolWindowTabId(@Nullable ToolWindow toolWindow) {
        if (toolWindow == null || !toolWindow.isVisible()) {
            return null;
        }
        Content content2 = toolWindow.getContentManager().getSelectedContent();
        if (content2 != null) {
            return VcsLogContentUtil.getId(content2);
        }
        return null;
    }

    @NotNull
    private static Set<String> getSelectedEditorTabIds(@NotNull Project project) {
        return VcsLogEditorUtilKt.findSelectedLogIds(project);
    }

    private static void addContentManagerListener(@NotNull ToolWindow window, @NotNull ContentManagerListener listener2, @NotNull Disposable disposable) {
        window.addContentManagerListener(listener2);
        Disposer.register((Disposable)disposable, () -> {
            ContentManager contentManager;
            if (!window.isDisposed() && (contentManager = window.getContentManagerIfCreated()) != null) {
                contentManager.removeContentManagerListener(listener2);
            }
        });
    }

    private static abstract class VcsLogTabsListener
    implements ToolWindowManagerListener,
    PropertyChangeListener,
    ContentManagerListener {
        @NotNull
        private final ToolWindow myToolWindow;

        private VcsLogTabsListener(@NotNull Project project, @NotNull ToolWindow toolWindow, @NotNull Disposable disposable) {
            this.myToolWindow = toolWindow;
            project.getMessageBus().connect(disposable).subscribe(ToolWindowManagerListener.TOPIC, (Object)this);
            Disposer.register((Disposable)disposable, () -> {
                for (Content content2 : this.myToolWindow.getContentManager().getContents()) {
                    if (!(content2 instanceof TabbedContent)) continue;
                    content2.removePropertyChangeListener((PropertyChangeListener)this);
                }
            });
        }

        protected abstract void selectionChanged(@NotNull String var1);

        private void selectionChanged() {
            String tabId = VcsLogTabsWatcher.getSelectedToolWindowTabId(this.myToolWindow);
            if (tabId != null) {
                this.selectionChanged(tabId);
            }
        }

        public void selectionChanged(@NotNull ContentManagerEvent event) {
            String tabId;
            if (ContentManagerEvent.ContentOperation.add.equals((Object)event.getOperation()) && (tabId = VcsLogContentUtil.getId(event.getContent())) != null) {
                this.selectionChanged(tabId);
            }
        }

        public void contentAdded(@NotNull ContentManagerEvent event) {
            Content content2 = event.getContent();
            if (content2 instanceof TabbedContent) {
                content2.addPropertyChangeListener((PropertyChangeListener)this);
            }
        }

        public void contentRemoved(@NotNull ContentManagerEvent event) {
            Content content2 = event.getContent();
            if (content2 instanceof TabbedContent) {
                content2.removePropertyChangeListener((PropertyChangeListener)this);
            }
        }

        public void toolWindowShown(@NotNull String id, @NotNull ToolWindow toolWindow) {
            if (this.myToolWindow == toolWindow) {
                this.selectionChanged();
            }
        }

        @Override
        public void propertyChange(@NotNull PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("component")) {
                this.selectionChanged();
            }
        }
    }

    private class MyRefreshPostponedEventsListener
    extends VcsLogTabsListener {
        private MyRefreshPostponedEventsListener(ToolWindow toolWindow) {
            super(VcsLogTabsWatcher.this.myProject, toolWindow, VcsLogTabsWatcher.this.myListenersDisposable);
        }

        @Override
        protected void selectionChanged(@NotNull String tabId) {
            VcsLogTabsWatcher.this.selectionChanged(tabId);
        }
    }

    private class MyFileManagerListener
    implements FileEditorManagerListener {
        private MyFileManagerListener() {
        }

        public void selectionChanged(@NotNull FileEditorManagerEvent e) {
            FileEditor editor = e.getNewEditor();
            if (editor != null) {
                for (String tabId : VcsLogEditorUtilKt.getLogIds(editor)) {
                    VcsLogTabsWatcher.this.selectionChanged(tabId);
                }
            }
        }
    }

    private final class MyToolWindowManagerListener
    implements ToolWindowManagerListener {
        private MyToolWindowManagerListener() {
        }

        public void toolWindowsRegistered(@NotNull List<String> ids) {
            if (ids.contains("Version Control")) {
                VcsLogTabsWatcher.this.installContentListeners();
            }
        }

        public void toolWindowUnregistered(@NotNull String id, @NotNull ToolWindow toolWindow) {
            if (id.equals("Version Control")) {
                VcsLogTabsWatcher.this.removeContentListeners();
            }
        }
    }

    private final class VcsLogEditorTab
    extends PostponableLogRefresher.VcsLogWindow {
        private final boolean myIsClosedOnDispose;

        private VcsLogEditorTab(@NotNull String id, VisiblePackRefresher refresher, boolean isClosedOnDispose) {
            super(id, refresher);
            this.myIsClosedOnDispose = isClosedOnDispose;
        }

        @Override
        public boolean isVisible() {
            return VcsLogTabsWatcher.getSelectedEditorTabIds(VcsLogTabsWatcher.this.myProject).contains(this.getId());
        }

        public boolean isClosedOnDispose() {
            return this.myIsClosedOnDispose;
        }
    }

    private final class VcsLogToolWindowTab
    extends PostponableLogRefresher.VcsLogWindow {
        private final boolean myIsClosedOnDispose;

        private VcsLogToolWindowTab(@NotNull String id, VisiblePackRefresher refresher, boolean isClosedOnDispose) {
            super(id, refresher);
            this.myIsClosedOnDispose = isClosedOnDispose;
        }

        @Override
        public boolean isVisible() {
            String selectedTab = VcsLogTabsWatcher.getSelectedToolWindowTabId(VcsLogTabsWatcher.this.getToolWindow());
            return this.getId().equals(selectedTab);
        }

        public boolean isClosedOnDispose() {
            return this.myIsClosedOnDispose;
        }
    }
}

