/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.impl;

import com.google.common.primitives.Ints;
import com.google.common.util.concurrent.SettableFuture;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.util.EmptyConsumer;
import com.intellij.util.concurrency.FutureResult;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsCommitMetadata;
import com.intellij.vcs.log.VcsFullCommitDetails;
import com.intellij.vcs.log.VcsLog;
import com.intellij.vcs.log.VcsLogProvider;
import com.intellij.vcs.log.VcsLogRefs;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.impl.VcsGoToRefComparator;
import com.intellij.vcs.log.ui.AbstractVcsLogUi;
import com.intellij.vcs.log.ui.table.VcsLogGraphTable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsLogImpl
implements VcsLog {
    @NotNull
    private final VcsLogData myLogData;
    @NotNull
    private final AbstractVcsLogUi myUi;

    public VcsLogImpl(@NotNull VcsLogData manager, @NotNull AbstractVcsLogUi ui2) {
        this.myLogData = manager;
        this.myUi = ui2;
    }

    @NotNull
    public List<CommitId> getSelectedCommits() {
        return this.myUi.getTable().getModel().getCommitIds(this.myUi.getTable().getSelectedRows());
    }

    @NotNull
    public List<VcsCommitMetadata> getSelectedShortDetails() {
        return this.myUi.getTable().getModel().getCommitMetadata(this.myUi.getTable().getSelectedRows());
    }

    @NotNull
    public List<VcsFullCommitDetails> getSelectedDetails() {
        return this.myUi.getTable().getModel().getFullDetails(this.myUi.getTable().getSelectedRows());
    }

    public void requestSelectedDetails(@NotNull Consumer<? super List<VcsFullCommitDetails>> consumer) {
        List rowsList = Ints.asList((int[])this.myUi.getTable().getSelectedRows());
        this.myLogData.getCommitDetailsGetter().loadCommitsData((List)this.getTable().getModel().convertToCommitIds(rowsList), (Consumer)consumer, EmptyConsumer.getInstance(), (ProgressIndicator)null);
    }

    @Nullable
    public Collection<String> getContainingBranches(@NotNull Hash commitHash, @NotNull VirtualFile root) {
        return this.myLogData.getContainingBranchesGetter().getContainingBranchesQuickly(root, commitHash);
    }

    @NotNull
    public Future<Boolean> jumpToReference(String reference) {
        if (StringUtil.isEmptyOrSpaces((String)reference)) {
            return new FutureResult((Object)false);
        }
        SettableFuture future2 = SettableFuture.create();
        VcsLogRefs refs = this.myUi.getDataPack().getRefs();
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            List matchingRefs = refs.stream().filter(ref -> ref.getName().startsWith(reference)).collect(Collectors.toList());
            ApplicationManager.getApplication().invokeLater(() -> {
                if (matchingRefs.isEmpty()) {
                    future2.setFuture(this.myUi.jumpToHash(reference));
                } else {
                    VcsRef ref = Collections.min(matchingRefs, new VcsGoToRefComparator(this.myUi.getDataPack().getLogProviders()));
                    future2.setFuture(this.myUi.jumpToCommit(ref.getCommitHash(), ref.getRoot()));
                }
            });
        });
        return future2;
    }

    @NotNull
    public Map<VirtualFile, VcsLogProvider> getLogProviders() {
        return this.myLogData.getLogProviders();
    }

    @NotNull
    private VcsLogGraphTable getTable() {
        return this.myUi.getTable();
    }
}

