/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.impl;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsFullCommitDetails;
import com.intellij.vcs.log.VcsShortCommitDetails;
import com.intellij.vcs.log.VcsUser;
import com.intellij.vcs.log.impl.MergedChange;
import com.intellij.vcs.log.impl.VcsCommitMetadataImpl;
import com.intellij.vcs.log.impl.VcsFileStatusInfo;
import com.intellij.vcs.log.impl.VcsFileStatusInfoMerger;
import com.intellij.vcs.log.impl.VcsStatusMerger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Experimental
public class VcsChangesLazilyParsedDetails
extends VcsCommitMetadataImpl
implements VcsFullCommitDetails {
    private static final Logger LOG = Logger.getInstance(VcsChangesLazilyParsedDetails.class);
    protected static final Changes EMPTY_CHANGES = new EmptyChanges();
    @NotNull
    private final ChangesParser myChangesParser;
    @NotNull
    private final AtomicReference<Changes> myChanges = new AtomicReference();

    public VcsChangesLazilyParsedDetails(@NotNull Project project, @NotNull Hash hash, @NotNull List<Hash> parents, long commitTime, @NotNull VirtualFile root, @NotNull String subject, @NotNull VcsUser author, @NotNull String message, @NotNull VcsUser committer, long authorTime, @NotNull List<List<VcsFileStatusInfo>> reportedChanges, @NotNull ChangesParser changesParser) {
        super(hash, parents, commitTime, root, subject, author, message, committer, authorTime);
        this.myChangesParser = changesParser;
        this.myChanges.set(reportedChanges.isEmpty() ? EMPTY_CHANGES : new UnparsedChanges(project, reportedChanges, (sources, parent) -> this.myChangesParser.parseStatusInfo(project, this, (List<VcsFileStatusInfo>)sources, (int)parent)));
    }

    @NotNull
    public Collection<Change> getChanges() {
        return this.myChanges.get().getMergedChanges();
    }

    @NotNull
    public Collection<Change> getChanges(int parent) {
        return this.myChanges.get().getChanges(parent);
    }

    public int size() {
        return this.myChanges.get().size();
    }

    @NotNull
    protected Changes getChangesObject() {
        return this.myChanges.get();
    }

    public static interface ChangesParser {
        public List<Change> parseStatusInfo(@NotNull Project var1, @NotNull VcsShortCommitDetails var2, @NotNull List<VcsFileStatusInfo> var3, int var4);
    }

    protected static class ParsedChanges
    implements Changes {
        @NotNull
        private final Collection<Change> myMergedChanges;
        @NotNull
        private final List<? extends Collection<Change>> myChanges;

        ParsedChanges(@NotNull Collection<Change> mergedChanges, @NotNull List<? extends Collection<Change>> changes) {
            this.myMergedChanges = mergedChanges;
            this.myChanges = changes;
        }

        @Override
        @NotNull
        public Collection<Change> getMergedChanges() {
            return this.myMergedChanges;
        }

        @Override
        @NotNull
        public Collection<Change> getChanges(int parent) {
            return this.myChanges.get(parent);
        }

        @Override
        public int size() {
            int size = 0;
            for (Collection<Change> collection : this.myChanges) {
                size += collection.size();
            }
            return size;
        }
    }

    private static class MyMergedChange
    extends MergedChange {
        @NotNull
        private final Supplier<List<Change>> mySourceChanges = Suppliers.memoize(() -> {
            ArrayList sourceChanges = new ArrayList();
            for (int parent = 0; parent < statusInfo.getMergedStatusInfos().size(); ++parent) {
                List statusInfos = Collections.singletonList(statusInfo.getMergedStatusInfos().get(parent));
                sourceChanges.addAll((Collection)parser.apply(statusInfos, parent));
            }
            return sourceChanges;
        });

        MyMergedChange(@NotNull Change change, @NotNull VcsStatusMerger.MergedStatusInfo<VcsFileStatusInfo> statusInfo, @NotNull BiFunction<List<VcsFileStatusInfo>, Integer, List<Change>> parser) {
            super(change);
        }

        @Override
        public List<Change> getSourceChanges() {
            return (List)this.mySourceChanges.get();
        }
    }

    protected class UnparsedChanges
    implements Changes {
        @NotNull
        protected final Project myProject;
        @NotNull
        protected final List<List<VcsFileStatusInfo>> myChangesOutput;
        @NotNull
        private final VcsStatusMerger<VcsFileStatusInfo> myStatusMerger = new VcsFileStatusInfoMerger();
        @NotNull
        private final BiFunction<List<VcsFileStatusInfo>, Integer, List<Change>> myParser;

        public UnparsedChanges(@NotNull Project project, @NotNull List<List<VcsFileStatusInfo>> changesOutput, BiFunction<List<VcsFileStatusInfo>, Integer, List<Change>> parser) {
            this.myProject = project;
            this.myChangesOutput = changesOutput;
            this.myParser = parser;
        }

        @NotNull
        protected ParsedChanges parseChanges() {
            List<Change> mergedChanges = this.parseMergedChanges();
            List<Collection<Change>> changes = this.computeChanges(mergedChanges);
            ParsedChanges parsedChanges = new ParsedChanges(mergedChanges, changes);
            VcsChangesLazilyParsedDetails.this.myChanges.compareAndSet(this, parsedChanges);
            return parsedChanges;
        }

        @NotNull
        private List<Change> parseMergedChanges() {
            List<VcsStatusMerger.MergedStatusInfo<VcsFileStatusInfo>> statuses = this.getMergedStatusInfo();
            List<Change> changes = this.myParser.apply(ContainerUtil.map(statuses, VcsStatusMerger.MergedStatusInfo::getStatusInfo), 0);
            if (changes.size() != statuses.size()) {
                LOG.error("Incorrectly parsed statuses " + statuses + " to changes " + changes);
            }
            if (VcsChangesLazilyParsedDetails.this.getParents().size() <= 1) {
                return changes;
            }
            ArrayList<Change> wrappedChanges = new ArrayList<Change>(statuses.size());
            for (int i = 0; i < statuses.size(); ++i) {
                wrappedChanges.add(new MyMergedChange(changes.get(i), statuses.get(i), this.myParser));
            }
            return wrappedChanges;
        }

        @Override
        @NotNull
        public Collection<Change> getMergedChanges() {
            return this.parseChanges().getMergedChanges();
        }

        @Override
        @NotNull
        public Collection<Change> getChanges(int parent) {
            return this.parseChanges().getChanges(parent);
        }

        @Override
        public int size() {
            int size = 0;
            for (List<VcsFileStatusInfo> changesToParent : this.myChangesOutput) {
                size += changesToParent.size();
            }
            return size;
        }

        @NotNull
        private List<Collection<Change>> computeChanges(@NotNull Collection<Change> mergedChanges) {
            if (this.myChangesOutput.size() == 1) {
                return Collections.singletonList(mergedChanges);
            }
            ArrayList<Collection<Change>> changes = new ArrayList<Collection<Change>>(this.myChangesOutput.size());
            for (int i = 0; i < this.myChangesOutput.size(); ++i) {
                ProgressManager.checkCanceled();
                changes.add(this.myParser.apply(this.myChangesOutput.get(i), i));
            }
            return changes;
        }

        @NotNull
        private List<VcsStatusMerger.MergedStatusInfo<VcsFileStatusInfo>> getMergedStatusInfo() {
            return this.myStatusMerger.merge(this.myChangesOutput);
        }

        @ApiStatus.Internal
        @NotNull
        public Collection<VcsFileStatusInfo> getMergedStatuses() {
            HashSet<VcsFileStatusInfo> result2 = new HashSet<VcsFileStatusInfo>();
            for (VcsStatusMerger.MergedStatusInfo<VcsFileStatusInfo> mergedStatusInfo : this.getMergedStatusInfo()) {
                result2.add(mergedStatusInfo.getStatusInfo());
            }
            return result2;
        }
    }

    protected static class EmptyChanges
    implements Changes {
        protected EmptyChanges() {
        }

        @Override
        @NotNull
        public Collection<Change> getMergedChanges() {
            return ContainerUtil.emptyList();
        }

        @Override
        @NotNull
        public Collection<Change> getChanges(int parent) {
            return ContainerUtil.emptyList();
        }

        @Override
        public int size() {
            return 0;
        }
    }

    protected static interface Changes {
        @NotNull
        public Collection<Change> getMergedChanges();

        @NotNull
        public Collection<Change> getChanges(int var1);

        public int size();
    }
}

