/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.impl;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.TimedVcsCommit;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class TimedVcsCommitImpl
implements TimedVcsCommit {
    @NotNull
    private final Hash myHash;
    @NotNull
    private final List<Hash> myParents;
    private final long myTime;

    public TimedVcsCommitImpl(@NotNull Hash hash, @NotNull List<Hash> parents, long timeStamp) {
        this.myHash = hash;
        this.myParents = parents;
        this.myTime = timeStamp;
    }

    @NotNull
    public final Hash getId() {
        return this.myHash;
    }

    @NotNull
    public final List<Hash> getParents() {
        return this.myParents;
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof TimedVcsCommitImpl)) {
            return false;
        }
        return this.myHash.equals(((TimedVcsCommitImpl)obj).myHash);
    }

    public final int hashCode() {
        return this.myHash.hashCode();
    }

    public String toString() {
        return this.myHash.toShortString() + "|-" + StringUtil.join((Collection)ContainerUtil.map(this.myParents, hash -> hash.toShortString()), (String)",") + ":" + this.myTime;
    }

    public final long getTimestamp() {
        return this.myTime;
    }
}

