/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.graph.utils.impl;

import com.intellij.vcs.log.graph.utils.Flags;
import com.intellij.vcs.log.graph.utils.IntToIntMap;
import com.intellij.vcs.log.graph.utils.impl.AbstractIntToIntMap;
import org.jetbrains.annotations.NotNull;

public class PermanentListIntToIntMap
extends AbstractIntToIntMap
implements IntToIntMap {
    public static final int DEFAULT_BLOCK_SIZE = 30;
    @NotNull
    private final Flags myVisibleIndexes;
    private final int myLongSize;
    private final int myShortSize;
    private final int myBlockSize;
    private final int @NotNull [] myStrongShortIndexes;

    @NotNull
    public static IntToIntMap newInstance(@NotNull Flags visibleIndexes, int shortSize) {
        return PermanentListIntToIntMap.newInstance(visibleIndexes, shortSize, 30);
    }

    @NotNull
    public static IntToIntMap newInstance(@NotNull Flags visibleIndexes, int shortSize, int blockSize) {
        if (shortSize < 0) {
            throw new NegativeArraySizeException("shortSize < 0: " + shortSize);
        }
        if (shortSize == 0) {
            return PermanentListIntToIntMap.createEmptyIntToIntMap(visibleIndexes);
        }
        int[] strongShortIndexes = new int[(shortSize - 1) / blockSize + 1];
        int currentShortIndex = -1;
        for (int longIndex = 0; longIndex < visibleIndexes.size(); ++longIndex) {
            if (!visibleIndexes.get(longIndex) || ++currentShortIndex % blockSize != 0) continue;
            strongShortIndexes[currentShortIndex / blockSize] = longIndex;
        }
        return new PermanentListIntToIntMap(visibleIndexes, shortSize, blockSize, strongShortIndexes);
    }

    @NotNull
    private static IntToIntMap createEmptyIntToIntMap(final @NotNull Flags visibleIndexes) {
        return new IntToIntMap(){

            @Override
            public int shortSize() {
                return 0;
            }

            @Override
            public int longSize() {
                return visibleIndexes.size();
            }

            @Override
            public int getLongIndex(int shortIndex) {
                return 0;
            }

            @Override
            public int getShortIndex(int longIndex) {
                return 0;
            }
        };
    }

    private PermanentListIntToIntMap(@NotNull Flags visibleIndexes, int shortSize, int blockSize, int @NotNull [] strongShortIndexes) {
        this.myVisibleIndexes = visibleIndexes;
        this.myLongSize = visibleIndexes.size();
        this.myShortSize = shortSize;
        this.myBlockSize = blockSize;
        this.myStrongShortIndexes = strongShortIndexes;
    }

    @Override
    public int shortSize() {
        return this.myShortSize;
    }

    @Override
    public int longSize() {
        return this.myLongSize;
    }

    @Override
    public int getLongIndex(int shortIndex) {
        this.checkShortIndex(shortIndex);
        int strongIndex = shortIndex / this.myBlockSize;
        int sub = shortIndex - strongIndex * this.myBlockSize;
        for (int longIndex = this.myStrongShortIndexes[strongIndex]; longIndex < this.myLongSize; ++longIndex) {
            if (this.myVisibleIndexes.get(longIndex)) {
                --sub;
            }
            if (sub != -1) continue;
            return longIndex;
        }
        throw new IllegalStateException("Not found long index for short index: " + shortIndex + ". Long & short size is: " + this.myLongSize + ", " + this.myShortSize + ".");
    }
}

