/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.graph.utils.impl;

import com.intellij.vcs.log.graph.utils.IntList;
import com.intellij.vcs.log.graph.utils.TimestampGetter;
import com.intellij.vcs.log.graph.utils.impl.FullIntList;
import com.intellij.vcs.log.graph.utils.impl.SmartDeltaCompressor;
import it.unimi.dsi.fastutil.ints.Int2LongOpenHashMap;
import org.jetbrains.annotations.NotNull;

public final class IntTimestampGetter
implements TimestampGetter {
    private static final int DEFAULT_BLOCK_SIZE = 30;
    private static final long MAX_DELTA = 0x7FFFFFF5L;
    private static final int BROKEN_DELTA = Integer.MAX_VALUE;
    private final IntList myDeltas;
    @NotNull
    private final Int2LongOpenHashMap myBrokenDeltas;
    private final int myBlockSize;
    private final long[] mySaveTimestamps;

    @NotNull
    public static IntTimestampGetter newInstance(@NotNull TimestampGetter delegateGetter) {
        return IntTimestampGetter.newInstance(delegateGetter, 30);
    }

    @NotNull
    public static IntTimestampGetter newInstance(@NotNull TimestampGetter delegateGetter, int blockSize) {
        if (delegateGetter.size() < 0) {
            throw new NegativeArraySizeException("delegateGetter.size() < 0: " + delegateGetter.size());
        }
        if (delegateGetter.size() == 0) {
            throw new IllegalArgumentException("Empty TimestampGetter not supported");
        }
        long[] saveTimestamps = new long[(delegateGetter.size() - 1) / blockSize + 1];
        for (int i = 0; i < saveTimestamps.length; ++i) {
            saveTimestamps[i] = delegateGetter.getTimestamp(blockSize * i);
        }
        Int2LongOpenHashMap brokenDeltas = new Int2LongOpenHashMap();
        int[] deltas = new int[delegateGetter.size()];
        for (int i = 0; i < delegateGetter.size(); ++i) {
            int intDelta;
            int blockIndex = i - i % blockSize;
            long delta = delegateGetter.getTimestamp(i) - delegateGetter.getTimestamp(blockIndex);
            deltas[i] = intDelta = IntTimestampGetter.deltaToInt(delta);
            if (intDelta != Integer.MAX_VALUE) continue;
            brokenDeltas.put(i, delta);
        }
        brokenDeltas.trim();
        return new IntTimestampGetter(deltas, blockSize, saveTimestamps, brokenDeltas);
    }

    private static int deltaToInt(long delta) {
        if (delta >= 0L && delta <= 0x7FFFFFF5L) {
            return (int)delta;
        }
        if (delta < 0L && -delta <= 0x7FFFFFF5L) {
            return (int)delta;
        }
        return Integer.MAX_VALUE;
    }

    private IntTimestampGetter(int[] deltas, int blockSize, long[] saveTimestamps, @NotNull Int2LongOpenHashMap brokenDeltas) {
        this.myDeltas = SmartDeltaCompressor.newInstance(new FullIntList(deltas));
        this.myBlockSize = blockSize;
        this.mySaveTimestamps = saveTimestamps;
        this.myBrokenDeltas = brokenDeltas;
    }

    @Override
    public int size() {
        return this.myDeltas.size();
    }

    @Override
    public long getTimestamp(int index) {
        this.checkRange(index);
        int relativeSaveIndex = index / this.myBlockSize;
        long timestamp = this.mySaveTimestamps[relativeSaveIndex];
        return timestamp + this.getDelta(index);
    }

    private long getDelta(int index) {
        int delta = this.myDeltas.get(index);
        if (delta != Integer.MAX_VALUE) {
            return delta;
        }
        return this.myBrokenDeltas.get(index);
    }

    private void checkRange(int index) {
        if (index < 0) {
            throw new IndexOutOfBoundsException("index < 0:" + index);
        }
        if (index >= this.size()) {
            throw new IndexOutOfBoundsException("index: " + index + " >= size: " + this.size());
        }
    }
}

