/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.graph.impl.facade.bek;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.vcs.log.graph.api.LinearGraph;
import com.intellij.vcs.log.graph.utils.LinearGraphUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class BekChecker {
    private static final Logger LOG = Logger.getInstance(BekChecker.class);

    public static void checkLinearGraph(@NotNull LinearGraph linearGraph) {
        Pair<Integer, Integer> reversedEdge = BekChecker.findReversedEdge(linearGraph);
        if (reversedEdge != null) {
            LOG.error("Illegal edge: up node " + reversedEdge.first + ", downNode " + reversedEdge.second);
        }
    }

    @Nullable
    public static Pair<Integer, Integer> findReversedEdge(@NotNull LinearGraph linearGraph) {
        for (int i = 0; i < linearGraph.nodesCount(); ++i) {
            for (int downNode : LinearGraphUtils.getDownNodes(linearGraph, i)) {
                if (downNode > i) continue;
                return Pair.create((Object)i, (Object)downNode);
            }
            for (int upNode : LinearGraphUtils.getUpNodes(linearGraph, i)) {
                if (upNode < i) continue;
                return Pair.create((Object)upNode, (Object)i);
            }
        }
        return null;
    }
}

