/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.graph.collapsing;

import com.intellij.vcs.log.graph.api.LinearGraph;
import com.intellij.vcs.log.graph.utils.Flags;
import com.intellij.vcs.log.graph.utils.UnsignedBitSet;
import org.jetbrains.annotations.NotNull;

class GraphNodesVisibility {
    @NotNull
    private final LinearGraph myLinearGraph;
    @NotNull
    private UnsignedBitSet myNodeVisibilityById;

    GraphNodesVisibility(@NotNull LinearGraph linearGraph, @NotNull UnsignedBitSet nodeVisibilityById) {
        this.myLinearGraph = linearGraph;
        this.myNodeVisibilityById = nodeVisibilityById;
    }

    @NotNull
    UnsignedBitSet getNodeVisibilityById() {
        return this.myNodeVisibilityById;
    }

    void setNodeVisibilityById(@NotNull UnsignedBitSet nodeVisibilityById) {
        this.myNodeVisibilityById = nodeVisibilityById;
    }

    boolean isVisible(int nodeIndex) {
        return this.myNodeVisibilityById.get(this.nodeId(nodeIndex));
    }

    void show(int nodeIndex) {
        this.myNodeVisibilityById.set(this.nodeId(nodeIndex), true);
    }

    void hide(int nodeIndex) {
        this.myNodeVisibilityById.set(this.nodeId(nodeIndex), false);
    }

    Flags asFlags() {
        return new Flags(){

            @Override
            public int size() {
                return GraphNodesVisibility.this.myLinearGraph.nodesCount();
            }

            @Override
            public boolean get(int index) {
                return GraphNodesVisibility.this.myNodeVisibilityById.get(GraphNodesVisibility.this.nodeId(index));
            }

            @Override
            public void set(int index, boolean value) {
                GraphNodesVisibility.this.myNodeVisibilityById.set(GraphNodesVisibility.this.nodeId(index), value);
            }

            @Override
            public void setAll(boolean value) {
                for (int index = 0; index < this.size(); ++index) {
                    this.set(index, value);
                }
            }
        };
    }

    private int nodeId(int nodeIndex) {
        return this.myLinearGraph.getNodeId(nodeIndex);
    }
}

