/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.data;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.AbstractProgressIndicatorBase;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsLogProgress
implements Disposable {
    @NotNull
    private final Object myLock = new Object();
    @NotNull
    private final List<ProgressListener> myListeners = new ArrayList<ProgressListener>();
    @NotNull
    private final Set<VcsLogProgressIndicator> myTasksWithVisibleProgress = new HashSet<VcsLogProgressIndicator>();
    @NotNull
    private final Set<ProgressIndicator> myTasksWithSilentProgress = new HashSet<ProgressIndicator>();
    private boolean myDisposed = false;

    public VcsLogProgress(@NotNull Disposable parent) {
        Disposer.register((Disposable)parent, (Disposable)this);
    }

    @NotNull
    public ProgressIndicator createProgressIndicator(@NotNull ProgressKey key) {
        return this.createProgressIndicator(true, key);
    }

    @NotNull
    public ProgressIndicator createProgressIndicator(boolean visible, @NotNull ProgressKey key) {
        if (ApplicationManager.getApplication().isHeadlessEnvironment()) {
            return new EmptyProgressIndicator();
        }
        return new VcsLogProgressIndicator(visible, key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addProgressIndicatorListener(@NotNull ProgressListener listener2, @Nullable Disposable parentDisposable) {
        Object object = this.myLock;
        synchronized (object) {
            this.myListeners.add(listener2);
            if (parentDisposable != null) {
                Disposer.register((Disposable)parentDisposable, () -> this.removeProgressIndicatorListener(listener2));
            }
            if (this.isRunning()) {
                Set<ProgressKey> keys = this.getRunningKeys();
                ApplicationManager.getApplication().invokeLater(() -> listener2.progressStarted(keys));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeProgressIndicatorListener(@NotNull ProgressListener listener2) {
        Object object = this.myLock;
        synchronized (object) {
            this.myListeners.remove(listener2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRunning() {
        Object object = this.myLock;
        synchronized (object) {
            return !this.myTasksWithVisibleProgress.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public Set<ProgressKey> getRunningKeys() {
        Object object = this.myLock;
        synchronized (object) {
            return ContainerUtil.map2Set(this.myTasksWithVisibleProgress, VcsLogProgressIndicator::getKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void started(@NotNull VcsLogProgressIndicator indicator) {
        Object object = this.myLock;
        synchronized (object) {
            if (this.myDisposed) {
                indicator.cancel();
                return;
            }
            if (indicator.isVisible()) {
                Set<ProgressKey> oldKeys = this.getRunningKeys();
                this.myTasksWithVisibleProgress.add(indicator);
                if (this.myTasksWithVisibleProgress.size() == 1) {
                    ProgressKey key = indicator.getKey();
                    this.fireNotification(listener2 -> listener2.progressStarted(Collections.singleton(key)));
                } else {
                    this.keysUpdated(oldKeys);
                }
            } else {
                this.myTasksWithSilentProgress.add((ProgressIndicator)indicator);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopped(@NotNull VcsLogProgressIndicator indicator) {
        Object object = this.myLock;
        synchronized (object) {
            if (indicator.isVisible()) {
                this.myTasksWithVisibleProgress.remove((Object)indicator);
                if (this.myTasksWithVisibleProgress.isEmpty()) {
                    this.fireNotification(ProgressListener::progressStopped);
                }
            } else {
                this.myTasksWithSilentProgress.remove((Object)indicator);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void keysUpdated(@NotNull Set<ProgressKey> oldKeys) {
        Object object = this.myLock;
        synchronized (object) {
            Set<ProgressKey> newKeys = this.getRunningKeys();
            if (!oldKeys.equals(newKeys)) {
                this.fireNotification(listener2 -> listener2.progressChanged(newKeys));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireNotification(@NotNull Consumer<? super ProgressListener> action) {
        Object object = this.myLock;
        synchronized (object) {
            ArrayList<ProgressListener> list = new ArrayList<ProgressListener>(this.myListeners);
            ApplicationManager.getApplication().invokeLater(() -> list.forEach(action));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Object object = this.myLock;
        synchronized (object) {
            this.myDisposed = true;
            for (ProgressIndicator progressIndicator : this.myTasksWithVisibleProgress) {
                progressIndicator.cancel();
            }
            for (ProgressIndicator progressIndicator : this.myTasksWithSilentProgress) {
                progressIndicator.cancel();
            }
        }
    }

    public static void updateCurrentKey(@NotNull ProgressKey key) {
        ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
        if (indicator instanceof VcsLogProgressIndicator) {
            ((VcsLogProgressIndicator)indicator).updateKey(key);
        }
    }

    public static class ProgressKey {
        @NotNull
        private final String myName;

        public ProgressKey(@NonNls @NotNull String name) {
            this.myName = name;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ProgressKey key = (ProgressKey)o;
            return Objects.equals(this.myName, key.myName);
        }

        public int hashCode() {
            return Objects.hash(this.myName);
        }
    }

    public static interface ProgressListener {
        public void progressStarted(@NotNull Collection<? extends ProgressKey> var1);

        public void progressChanged(@NotNull Collection<? extends ProgressKey> var1);

        public void progressStopped();
    }

    private class VcsLogProgressIndicator
    extends AbstractProgressIndicatorBase {
        @NotNull
        private ProgressKey myKey;
        private final boolean myVisible;

        private VcsLogProgressIndicator(@NotNull boolean visible, ProgressKey key) {
            this.myKey = key;
            this.myVisible = visible;
            if (!visible) {
                this.dontStartActivity();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void start() {
            Object object = this.getLock();
            synchronized (object) {
                super.start();
                VcsLogProgress.this.started(this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stop() {
            Object object = this.getLock();
            synchronized (object) {
                super.stop();
                VcsLogProgress.this.stopped(this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void updateKey(@NotNull ProgressKey key) {
            Object object = VcsLogProgress.this.myLock;
            synchronized (object) {
                Set<ProgressKey> oldKeys = VcsLogProgress.this.getRunningKeys();
                this.myKey = key;
                VcsLogProgress.this.keysUpdated(oldKeys);
            }
        }

        public boolean isVisible() {
            return this.myVisible;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public ProgressKey getKey() {
            Object object = VcsLogProgress.this.myLock;
            synchronized (object) {
                return this.myKey;
            }
        }
    }
}

