/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.extensions.ExtensionNotApplicableException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.VcsDirectoryMapping;
import com.intellij.openapi.vcs.impl.ProjectLevelVcsManagerImpl;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.GuiUtils;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;

final class PlatformVcsDetector
implements StartupActivity.DumbAware {
    PlatformVcsDetector() {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            throw ExtensionNotApplicableException.INSTANCE;
        }
    }

    public void runActivity(@NotNull Project project) {
        GuiUtils.invokeLaterIfNeeded(() -> {
            AbstractVcs vcs;
            String projectBasePath = project.getBasePath();
            if (projectBasePath == null) {
                return;
            }
            ProjectLevelVcsManagerImpl vcsManager2 = ProjectLevelVcsManagerImpl.getInstanceImpl(project);
            Path file = Paths.get(projectBasePath, new String[0]);
            if (!vcsManager2.needAutodetectMappings()) {
                return;
            }
            VirtualFile virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByPath(FileUtil.toSystemIndependentName((String)file.toString()));
            if (virtualFile != null && (vcs = vcsManager2.findVersioningVcs(virtualFile)) != null && vcs != vcsManager2.getVcsFor(virtualFile)) {
                vcsManager2.setAutoDirectoryMappings(Collections.singletonList(new VcsDirectoryMapping(virtualFile.getPath(), vcs.getName())));
            }
        }, (ModalityState)ModalityState.NON_MODAL, (Condition)project.getDisposed());
    }
}

