/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.vfs;

import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.ByteBackedContentRevision;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.vfs.AbstractVcsVirtualFile;
import com.intellij.openapi.vcs.vfs.VcsFileSystem;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.containers.ContainerUtil;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class ContentRevisionVirtualFile
extends AbstractVcsVirtualFile {
    @NotNull
    private final ContentRevision myContentRevision;
    private volatile byte[] myContent;
    private volatile boolean myContentLoadFailed;
    private final Object LOCK = new Object();
    private static final Map<ContentRevision, ContentRevisionVirtualFile> ourMap = ContainerUtil.createWeakMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ContentRevisionVirtualFile create(@NotNull ContentRevision contentRevision) {
        Map<ContentRevision, ContentRevisionVirtualFile> map2 = ourMap;
        synchronized (map2) {
            ContentRevisionVirtualFile revisionVirtualFile = ourMap.get(contentRevision);
            if (revisionVirtualFile == null) {
                revisionVirtualFile = new ContentRevisionVirtualFile(contentRevision);
                ourMap.put(contentRevision, revisionVirtualFile);
            }
            return revisionVirtualFile;
        }
    }

    private ContentRevisionVirtualFile(@NotNull ContentRevision contentRevision) {
        super(contentRevision.getFile().getPath(), (VirtualFileSystem)VcsFileSystem.getInstance());
        this.myContentRevision = contentRevision;
        this.setCharset(StandardCharsets.UTF_8);
    }

    public boolean isDirectory() {
        return false;
    }

    @Override
    public byte @NotNull [] contentsToByteArray() {
        if (this.myContentLoadFailed) {
            return ArrayUtilRt.EMPTY_BYTE_ARRAY;
        }
        if (this.myContent == null) {
            this.loadContent();
        }
        return this.myContent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadContent() {
        try {
            byte[] bytes;
            if (this.myContentRevision instanceof ByteBackedContentRevision) {
                bytes = ((ByteBackedContentRevision)this.myContentRevision).getContentAsBytes();
            } else {
                String content2 = this.myContentRevision.getContent();
                byte[] byArray = bytes = content2 != null ? content2.getBytes(this.getCharset()) : null;
            }
            if (bytes == null) {
                throw new VcsException("Could not load content");
            }
            Object object = this.LOCK;
            synchronized (object) {
                this.myContent = bytes;
                this.myContentLoadFailed = false;
                this.setRevision(this.myContentRevision.getRevisionNumber().asString());
            }
        }
        catch (VcsException e) {
            Object object = this.LOCK;
            synchronized (object) {
                this.myContentLoadFailed = true;
                this.myContent = ArrayUtilRt.EMPTY_BYTE_ARRAY;
                this.setRevision("0");
            }
            this.showLoadingContentFailedMessage(e);
        }
    }

    @NotNull
    public ContentRevision getContentRevision() {
        return this.myContentRevision;
    }
}

