/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.ui;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.impl.TrafficLightRenderer;
import com.intellij.codeInsight.intention.IntentionManager;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionProfileWrapper;
import com.intellij.ide.ui.LafManager;
import com.intellij.ide.ui.LafManagerListener;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SpellCheckingEditorCustomizationProvider;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.impl.EditorMarkupModelImpl;
import com.intellij.openapi.editor.markup.ErrorStripeRenderer;
import com.intellij.openapi.editor.markup.UIController;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.CommitMessageI;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.ui.AdditionalPageAtBottomEditorCustomization;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.EditorCustomization;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.EditorTextFieldProvider;
import com.intellij.ui.ErrorStripeEditorCustomization;
import com.intellij.ui.SeparatorFactory;
import com.intellij.ui.SoftWrapsEditorCustomization;
import com.intellij.ui.TitledSeparator;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.components.BorderLayoutPanel;
import com.intellij.vcs.commit.CommitMessageUi;
import com.intellij.vcs.commit.message.BodyLimitSettings;
import com.intellij.vcs.commit.message.CommitMessageInspectionProfile;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CommitMessage
extends JPanel
implements Disposable,
DataProvider,
CommitMessageUi,
CommitMessageI,
LafManagerListener {
    public static final Key<CommitMessage> DATA_KEY = Key.create((String)"Vcs.CommitMessage.Panel");
    private static final EditorCustomization COLOR_SCHEME_FOR_CURRENT_UI_THEME_CUSTOMIZATION = editor -> {
        editor.setBackgroundColor(null);
        editor.setColorsScheme(CommitMessage.getCommitMessageColorScheme());
    };
    @NotNull
    private final EditorTextField myEditorField;
    @Nullable
    private final TitledSeparator mySeparator;
    @NotNull
    private List<ChangeList> myChangeLists = Collections.emptyList();

    @NotNull
    private static EditorColorsScheme getCommitMessageColorScheme() {
        boolean isEditorDark;
        boolean isLaFDark = ColorUtil.isDark((Color)UIUtil.getPanelBackground());
        return isLaFDark == (isEditorDark = EditorColorsManager.getInstance().isDarkEditor()) ? EditorColorsManager.getInstance().getGlobalScheme() : EditorColorsManager.getInstance().getSchemeForCurrentUITheme();
    }

    public CommitMessage(@NotNull Project project) {
        this(project, true, true, true);
    }

    public CommitMessage(@NotNull Project project, boolean withSeparator, boolean showToolbar, boolean runInspections) {
        super(new BorderLayout());
        this.myEditorField = CommitMessage.createCommitMessageEditor(project, runInspections);
        this.myEditorField.getDocument().putUserData(DATA_KEY, (Object)this);
        this.add((Component)this.myEditorField, "Center");
        if (withSeparator) {
            this.mySeparator = SeparatorFactory.createSeparator((String)VcsBundle.message((String)"label.commit.comment", (Object[])new Object[0]), (JComponent)this.myEditorField.getComponent());
            BorderLayoutPanel separatorPanel = JBUI.Panels.simplePanel().addToBottom((Component)this.mySeparator).addToTop(Box.createVerticalGlue());
            BorderLayoutPanel labelPanel = (BorderLayoutPanel)JBUI.Panels.simplePanel((Component)separatorPanel).withBorder(BorderFactory.createEmptyBorder());
            if (showToolbar) {
                labelPanel.addToRight((Component)this.createToolbar(true));
            }
            this.add((Component)labelPanel, "North");
        } else {
            this.mySeparator = null;
            if (showToolbar) {
                this.add((Component)this.createToolbar(false), "East");
            }
        }
        this.setBorder(BorderFactory.createEmptyBorder());
        this.updateOnInspectionProfileChanged(project);
        ApplicationManager.getApplication().getMessageBus().connect((Disposable)this).subscribe(LafManagerListener.TOPIC, (Object)this);
    }

    private void updateOnInspectionProfileChanged(@NotNull Project project) {
        project.getMessageBus().connect((Disposable)this).subscribe(CommitMessageInspectionProfile.TOPIC, () -> {
            Editor editor = this.myEditorField.getEditor();
            if (editor instanceof EditorEx) {
                RightMarginCustomization.customize(project, (EditorEx)editor);
            }
        });
    }

    public void lookAndFeelChanged(@NotNull LafManager source) {
        Editor editor = this.myEditorField.getEditor();
        if (editor instanceof EditorEx) {
            COLOR_SCHEME_FOR_CURRENT_UI_THEME_CUSTOMIZATION.customize((EditorEx)editor);
        }
    }

    @NotNull
    private JComponent createToolbar(boolean horizontal) {
        ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar("CommitMessage", CommitMessage.getToolbarActions(), horizontal);
        toolbar.updateActionsImmediately();
        toolbar.setReservePlaceAutoPopupIcon(false);
        toolbar.getComponent().setBorder(BorderFactory.createEmptyBorder());
        toolbar.setTargetComponent((JComponent)this);
        return toolbar.getComponent();
    }

    @Nullable
    public Object getData(@NotNull @NonNls String dataId) {
        if (VcsDataKeys.COMMIT_MESSAGE_CONTROL.is(dataId)) {
            return this;
        }
        return null;
    }

    public void setSeparatorText(@NotNull String text2) {
        if (this.mySeparator != null) {
            this.mySeparator.setText(text2);
        }
    }

    public void setCommitMessage(@Nullable String currentDescription) {
        this.setText(currentDescription);
    }

    @Deprecated
    public static EditorTextField createCommitTextEditor(@NotNull Project project, boolean forceSpellCheckOn) {
        return CommitMessage.createCommitMessageEditor(project, false);
    }

    @NotNull
    private static EditorTextField createCommitMessageEditor(@NotNull Project project, boolean runInspections) {
        HashSet<Object> features = new HashSet<Object>();
        features.add(new RightMarginCustomization(project));
        features.add(SoftWrapsEditorCustomization.ENABLED);
        features.add(AdditionalPageAtBottomEditorCustomization.DISABLED);
        features.add(COLOR_SCHEME_FOR_CURRENT_UI_THEME_CUSTOMIZATION);
        if (runInspections) {
            features.add(ErrorStripeEditorCustomization.ENABLED);
            features.add(new InspectionCustomization(project));
        } else {
            ContainerUtil.addIfNotNull(features, (Object)SpellCheckingEditorCustomizationProvider.getInstance().getEnabledCustomization());
        }
        EditorTextField editorField = EditorTextFieldProvider.getInstance().getEditorField(FileTypes.PLAIN_TEXT.getLanguage(), project, features);
        editorField.setFontInheritedFromLAF(false);
        return editorField;
    }

    public static boolean isCommitMessage(@NotNull PsiElement element) {
        Document document = PsiDocumentManager.getInstance((Project)element.getProject()).getDocument(element.getContainingFile());
        return document != null && document.getUserData(DATA_KEY) != null;
    }

    @Nullable
    public static Editor getEditor(@NotNull Document document) {
        CommitMessage commitMessage2 = (CommitMessage)document.getUserData(DATA_KEY);
        return commitMessage2 != null ? commitMessage2.getEditorField().getEditor() : null;
    }

    @NotNull
    private static ActionGroup getToolbarActions() {
        return (ActionGroup)ActionManager.getInstance().getAction("Vcs.MessageActionGroup");
    }

    @NotNull
    public EditorTextField getEditorField() {
        return this.myEditorField;
    }

    @NotNull
    public String getText() {
        return this.getComment();
    }

    public void setText(@Nullable String initialMessage) {
        this.myEditorField.setText(initialMessage == null ? "" : StringUtil.convertLineSeparators((String)initialMessage));
    }

    public void focus() {
        this.requestFocusInMessage();
    }

    @NotNull
    public String getComment() {
        return StringUtil.trimTrailing((String)this.myEditorField.getDocument().getCharsSequence().toString());
    }

    public void requestFocusInMessage() {
        IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)this.myEditorField, true));
        this.myEditorField.selectAll();
    }

    public void dispose() {
        this.removeAll();
        this.myEditorField.getDocument().putUserData(DATA_KEY, null);
    }

    public synchronized void setChangeList(@NotNull ChangeList value) {
        this.setChangeLists(Collections.singletonList(value));
    }

    public synchronized void setChangeLists(@NotNull List<ChangeList> value) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.myChangeLists = ContainerUtil.newUnmodifiableList(value);
    }

    @NotNull
    public synchronized List<ChangeList> getChangeLists() {
        return this.myChangeLists;
    }

    private static class ConditionalTrafficLightRenderer
    extends TrafficLightRenderer {
        ConditionalTrafficLightRenderer(@NotNull Project project, @NotNull Document document) {
            super(project, document);
        }

        protected void refresh(@Nullable EditorMarkupModelImpl editorMarkupModel) {
            super.refresh(editorMarkupModel);
            if (editorMarkupModel != null) {
                editorMarkupModel.setTrafficLightIconVisible(this.hasHighSeverities(this.getErrorCount()));
            }
        }

        private boolean hasHighSeverities(int @NotNull [] errorCount) {
            HighlightSeverity minSeverity = ((HighlightDisplayLevel)ObjectUtils.notNull((Object)HighlightDisplayLevel.find((String)"TYPO"), (Object)HighlightDisplayLevel.DO_NOT_SHOW)).getSeverity();
            for (int i = 0; i < errorCount.length; ++i) {
                if (errorCount[i] <= 0 || this.getSeverityRegistrar().compare(this.getSeverityRegistrar().getSeverityByIndex(i), minSeverity) <= 0) continue;
                return true;
            }
            return false;
        }

        @NotNull
        protected UIController createUIController(@NotNull Editor editor) {
            return new TrafficLightRenderer.SimplifiedUIController((TrafficLightRenderer)this);
        }
    }

    private static class InspectionCustomization
    implements EditorCustomization {
        @NotNull
        private final Project myProject;

        InspectionCustomization(@NotNull Project project) {
            this.myProject = project;
        }

        public void customize(@NotNull EditorEx editor) {
            PsiFile file = PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile((Document)editor.getDocument());
            if (file != null) {
                file.putUserData(InspectionProfileWrapper.CUSTOMIZATION_KEY, profile -> new InspectionProfileWrapper((InspectionProfileImpl)CommitMessageInspectionProfile.getInstance(this.myProject)));
            }
            editor.putUserData(IntentionManager.SHOW_INTENTION_OPTIONS_KEY, (Object)false);
            ((EditorMarkupModelImpl)editor.getMarkupModel()).setErrorStripeRenderer((ErrorStripeRenderer)new ConditionalTrafficLightRenderer(this.myProject, (Document)editor.getDocument()));
        }
    }

    private static class RightMarginCustomization
    implements EditorCustomization {
        @NotNull
        private final Project myProject;

        private RightMarginCustomization(@NotNull Project project) {
            this.myProject = project;
        }

        public void customize(@NotNull EditorEx editor) {
            RightMarginCustomization.customize(this.myProject, editor);
        }

        private static void customize(@NotNull Project project, @NotNull EditorEx editor) {
            BodyLimitSettings settings = CommitMessageInspectionProfile.getBodyLimitSettings(project);
            editor.getSettings().setRightMargin(settings.getRightMargin());
            editor.getSettings().setRightMarginShown(settings.isShowRightMargin());
            editor.getSettings().setWrapWhenTypingReachesRightMargin(settings.isWrapOnTyping());
        }
    }
}

