/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.impl.projectlevelman;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.impl.projectlevelman.FileWatchRequestModifier;
import com.intellij.openapi.vcs.impl.projectlevelman.NewMappings;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.util.Alarm;
import org.jetbrains.annotations.NotNull;

public class FileWatchRequestsManager {
    private final FileWatchRequestModifier myModifier;
    private final Alarm myAlarm;

    public FileWatchRequestsManager(@NotNull Project project, @NotNull NewMappings newMappings) {
        this(project, newMappings, LocalFileSystem.getInstance());
    }

    public FileWatchRequestsManager(@NotNull Project project, @NotNull NewMappings newMappings, @NotNull LocalFileSystem localFileSystem) {
        this.myModifier = new FileWatchRequestModifier(project, newMappings, localFileSystem);
        this.myAlarm = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, (Disposable)newMappings);
    }

    public void ping() {
        this.myAlarm.cancelAllRequests();
        this.myAlarm.addRequest((Runnable)this.myModifier, 0);
    }

    protected void pingImmediately() {
        this.myModifier.run();
    }
}

