/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.impl;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.patch.RelativePathCalculator;
import com.intellij.openapi.vcs.impl.VcsPathPresenter;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import org.jetbrains.annotations.NotNull;

public class PlatformVcsPathPresenter
extends VcsPathPresenter {
    @NotNull
    public String getPresentableRelativePathFor(VirtualFile file) {
        return FileUtil.toSystemDependentName((String)file.getPath());
    }

    @NotNull
    public String getPresentableRelativePath(ContentRevision fromRevision, ContentRevision toRevision) {
        FilePath path2 = toRevision.getFile();
        FilePath originalPath = fromRevision.getFile();
        return PlatformVcsPathPresenter.getPresentableRelativePath(path2, originalPath);
    }

    @NotNull
    public static String getPresentableRelativePath(@NotNull FilePath path2, @NotNull FilePath originalPath) {
        RelativePathCalculator calculator = new RelativePathCalculator(path2.getPath(), originalPath.getPath());
        return calculator.execute().replace("/", File.separator);
    }
}

