/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.history;

import com.intellij.diff.DiffManager;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.requests.MessageDiffRequest;
import com.intellij.diff.util.DiffUserDataKeysEx;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogBuilder;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.CurrentContentRevision;
import com.intellij.openapi.vcs.changes.actions.diff.ShowDiffAction;
import com.intellij.openapi.vcs.changes.actions.diff.ShowDiffContext;
import com.intellij.openapi.vcs.changes.ui.SimpleChangesBrowser;
import com.intellij.openapi.vcs.diff.DiffProvider;
import com.intellij.openapi.vcs.history.ShortVcsRevisionNumber;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.impl.BackgroundableActionLock;
import com.intellij.openapi.vcs.impl.VcsBackgroundableActions;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcsUtil.VcsFileUtil;
import com.intellij.vcsUtil.VcsUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class VcsDiffUtil {
    public static void showDiffFor(@NotNull Project project, @NotNull Collection<? extends Change> changes, @NotNull String revNumTitle1, @NotNull String revNumTitle2, @NotNull FilePath filePath) {
        if (filePath.isDirectory()) {
            VcsDiffUtil.showChangesDialog(project, VcsDiffUtil.getDialogTitle(filePath, revNumTitle1, revNumTitle2), new ArrayList<Change>(changes));
        } else if (changes.isEmpty()) {
            DiffManager.getInstance().showDiff(project, (DiffRequest)new MessageDiffRequest("No Changes Found"));
        } else {
            final HashMap<Key, String> revTitlesMap = new HashMap<Key, String>(2);
            revTitlesMap.put(DiffUserDataKeysEx.VCS_DIFF_LEFT_CONTENT_TITLE, revNumTitle1);
            revTitlesMap.put(DiffUserDataKeysEx.VCS_DIFF_RIGHT_CONTENT_TITLE, revNumTitle2);
            ShowDiffContext showDiffContext = new ShowDiffContext(){

                @Override
                @NotNull
                public Map<Key<?>, Object> getChangeContext(@NotNull Change change) {
                    return revTitlesMap;
                }
            };
            ShowDiffAction.showDiffForChange(project, changes, 0, showDiffContext);
        }
    }

    @NotNull
    private static String getDialogTitle(@NotNull FilePath filePath, @NotNull String revNumTitle1, @NotNull String revNumTitle2) {
        return String.format("Difference between %s and %s versions in %s", revNumTitle1, revNumTitle2, filePath.getName());
    }

    @NotNull
    public static String getRevisionTitle(@NotNull String revision, boolean localMark) {
        return revision + (localMark ? " (" + VcsBundle.message((String)"diff.title.local", (Object[])new Object[0]) + ")" : "");
    }

    public static void putFilePathsIntoChangeContext(@NotNull Change change, @NotNull Map<Key<?>, Object> context) {
        ContentRevision afterRevision = change.getAfterRevision();
        ContentRevision beforeRevision = change.getBeforeRevision();
        FilePath aFile = afterRevision == null ? null : afterRevision.getFile();
        FilePath bFile = beforeRevision == null ? null : beforeRevision.getFile();
        context.put(DiffUserDataKeysEx.VCS_DIFF_RIGHT_CONTENT_TITLE, VcsDiffUtil.getRevisionTitle(afterRevision, aFile, null));
        context.put(DiffUserDataKeysEx.VCS_DIFF_LEFT_CONTENT_TITLE, VcsDiffUtil.getRevisionTitle(beforeRevision, bFile, aFile));
    }

    @NotNull
    public static String getRevisionTitle(@Nullable ContentRevision revision, @Nullable FilePath file, @Nullable FilePath baseFile) {
        return VcsDiffUtil.getShortHash(revision) + (file == null || VcsFileUtil.CASE_SENSITIVE_FILE_PATH_HASHING_STRATEGY.equals((Object)baseFile, (Object)file) ? "" : " (" + VcsDiffUtil.getRelativeFileName(baseFile, file) + ")");
    }

    @NotNull
    private static String getShortHash(@Nullable ContentRevision revision) {
        if (revision == null) {
            return "";
        }
        VcsRevisionNumber revisionNumber = revision.getRevisionNumber();
        if (revisionNumber instanceof ShortVcsRevisionNumber) {
            return ((ShortVcsRevisionNumber)revisionNumber).toShortString();
        }
        return revisionNumber.asString();
    }

    @NotNull
    private static String getRelativeFileName(@Nullable FilePath baseFile, @NotNull FilePath file) {
        if (baseFile == null || !baseFile.getName().equals(file.getName())) {
            return file.getName();
        }
        FilePath aParentPath = baseFile.getParentPath();
        if (aParentPath == null) {
            return file.getName();
        }
        return VcsFileUtil.relativePath(aParentPath.getIOFile(), file.getIOFile());
    }

    public static void showChangesDialog(@NotNull Project project, @NotNull String title2, @NotNull List<? extends Change> changes) {
        DialogBuilder dialogBuilder = new DialogBuilder(project);
        dialogBuilder.setTitle(title2);
        dialogBuilder.setActionDescriptors(new DialogBuilder.ActionDescriptor[]{new DialogBuilder.CloseDialogAction()});
        SimpleChangesBrowser changesBrowser2 = new SimpleChangesBrowser(project, false, true);
        changesBrowser2.setChangesToDisplay(changes);
        dialogBuilder.setCenterPanel((JComponent)changesBrowser2);
        dialogBuilder.setPreferredFocusComponent(changesBrowser2.getPreferredFocusedComponent());
        dialogBuilder.setDimensionServiceKey("VcsDiffUtil.ChangesDialog");
        dialogBuilder.showNotModal();
    }

    @NotNull
    public static List<Change> createChangesWithCurrentContentForFile(@NotNull FilePath filePath, @Nullable ContentRevision beforeContentRevision) {
        return Collections.singletonList(new Change(beforeContentRevision, CurrentContentRevision.create((FilePath)filePath)));
    }

    public static void showChangesWithWorkingDirLater(final @NotNull Project project, final @NotNull VirtualFile file, final @NotNull VcsRevisionNumber targetRevNumber, final @NotNull DiffProvider provider) {
        final BackgroundableActionLock lock = BackgroundableActionLock.getLock(project, new Object[]{VcsBackgroundableActions.COMPARE_WITH, file});
        Task.Backgroundable task2 = new Task.Backgroundable(project, VcsBundle.message((String)"file.history.diff.with.local.process", (Object[])new Object[0]), true){
            private Collection<Change> changes;
            private VcsRevisionNumber currentRevNumber;

            public void run(@NotNull ProgressIndicator indicator) {
                try {
                    this.changes = provider.compareWithWorkingDir(file, targetRevNumber);
                    this.currentRevNumber = provider.getCurrentRevision(file);
                }
                catch (VcsException e) {
                    String title2 = String.format("Compare with %s failed", VcsUtil.getShortRevisionString((VcsRevisionNumber)targetRevNumber));
                    String message = String.format("Couldn't compare %s with revision [%s];\n %s", file, VcsUtil.getShortRevisionString((VcsRevisionNumber)targetRevNumber), e.getMessage());
                    VcsNotifier.getInstance(project).notifyError(title2, message);
                }
            }

            public void onSuccess() {
                if (this.changes != null) {
                    String currentRevTitle = this.currentRevNumber != null ? VcsDiffUtil.getRevisionTitle(VcsUtil.getShortRevisionString((VcsRevisionNumber)this.currentRevNumber), true) : VcsBundle.message((String)"diff.title.local", (Object[])new Object[0]);
                    VcsDiffUtil.showDiffFor(project, this.changes, VcsDiffUtil.getRevisionTitle(VcsUtil.getShortRevisionString((VcsRevisionNumber)targetRevNumber), false), currentRevTitle, VcsUtil.getFilePath((VirtualFile)file));
                }
            }

            public void onFinished() {
                lock.unlock();
            }
        };
        lock.lock();
        ProgressManager.getInstance().run((Task)task2);
    }
}

