/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.history;

import com.intellij.openapi.vcs.history.TreeNodeOnVcsRevision;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.ui.dualView.DualView;
import com.intellij.ui.dualView.DualViewColumnInfo;
import com.intellij.ui.table.TableView;
import com.intellij.util.ui.ColumnInfo;
import java.awt.FontMetrics;
import java.util.Comparator;
import java.util.Enumeration;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class FileHistoryColumnWrapper<T>
extends DualViewColumnInfo<TreeNodeOnVcsRevision, T> {
    @NotNull
    private final ColumnInfo<VcsFileRevision, T> myBaseColumn;

    FileHistoryColumnWrapper(@NotNull ColumnInfo<VcsFileRevision, T> additionalColumn) {
        super(additionalColumn.getName());
        this.myBaseColumn = additionalColumn;
    }

    public Comparator<TreeNodeOnVcsRevision> getComparator() {
        Comparator comparator = this.myBaseColumn.getComparator();
        if (comparator == null) {
            return null;
        }
        return (o1, o2) -> {
            if (o1 == null) {
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            VcsFileRevision revision1 = o1.getRevision();
            VcsFileRevision revision2 = o2.getRevision();
            return comparator.compare(revision1, revision2);
        };
    }

    public String getName() {
        return this.myBaseColumn.getName();
    }

    public void setName(String s) {
        this.myBaseColumn.setName(s);
    }

    public Class getColumnClass() {
        return this.myBaseColumn.getColumnClass();
    }

    public boolean isCellEditable(TreeNodeOnVcsRevision o) {
        return this.myBaseColumn.isCellEditable((Object)o.getRevision());
    }

    public void setValue(TreeNodeOnVcsRevision o, T aValue) {
        this.myBaseColumn.setValue((Object)o.getRevision(), aValue);
    }

    public TableCellRenderer getRenderer(TreeNodeOnVcsRevision p0) {
        return this.myBaseColumn.getRenderer((Object)p0.getRevision());
    }

    public TableCellEditor getEditor(TreeNodeOnVcsRevision item) {
        return this.myBaseColumn.getEditor((Object)item.getRevision());
    }

    public String getMaxStringValue() {
        String superValue = this.myBaseColumn.getMaxStringValue();
        if (superValue != null) {
            return superValue;
        }
        return this.getMaxValue(this.myBaseColumn.getName());
    }

    @Nullable
    private String getMaxValue(@NotNull String columnHeader) {
        TableColumn column;
        TableView table = this.getDualView().getFlatView();
        if (table.getRowCount() == 0) {
            return null;
        }
        Enumeration<TableColumn> columns = table.getColumnModel().getColumns();
        int idx = 0;
        while (columns.hasMoreElements() && !columnHeader.equals((column = columns.nextElement()).getHeaderValue())) {
            ++idx;
        }
        if (idx >= table.getColumnModel().getColumnCount() - 1) {
            return null;
        }
        FontMetrics fm = table.getFontMetrics(table.getFont().deriveFont(1));
        Object header = table.getColumnModel().getColumn(idx).getHeaderValue();
        double maxValue = fm.stringWidth((String)header);
        String value = (String)header;
        for (int i = 0; i < table.getRowCount(); ++i) {
            int newWidth;
            Object at = table.getValueAt(i, idx);
            if (!(at instanceof String) || !((double)(newWidth = fm.stringWidth((String)at)) > maxValue)) continue;
            maxValue = newWidth;
            value = (String)at;
        }
        return value + "ww";
    }

    public int getAdditionalWidth() {
        return this.myBaseColumn.getAdditionalWidth();
    }

    public int getWidth(JTable table) {
        return this.myBaseColumn.getWidth(table);
    }

    public boolean shouldBeShownIsTheTree() {
        return true;
    }

    public boolean shouldBeShownIsTheTable() {
        return true;
    }

    public T valueOf(TreeNodeOnVcsRevision o) {
        return (T)this.myBaseColumn.valueOf((Object)o.getRevision());
    }

    protected abstract DualView getDualView();
}

