/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.ex;

import com.intellij.diff.util.DiffUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.actions.MoveChangesToAnotherListAction;
import com.intellij.openapi.vcs.ex.LineStatusActionBase;
import com.intellij.openapi.vcs.ex.LineStatusTrackerI;
import com.intellij.openapi.vcs.ex.LocalRange;
import com.intellij.openapi.vcs.ex.PartialLocalLineStatusTracker;
import java.util.BitSet;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class MoveChangesLineStatusAction
extends LineStatusActionBase {
    @Override
    protected boolean isEnabled(@NotNull LineStatusTrackerI<?> tracker, @NotNull Editor editor) {
        return tracker instanceof PartialLocalLineStatusTracker;
    }

    @Override
    protected void doAction(@NotNull LineStatusTrackerI<?> tracker, @NotNull Editor editor) {
        MoveChangesLineStatusAction.moveToAnotherChangelist((PartialLocalLineStatusTracker)tracker, editor);
    }

    public static void moveToAnotherChangelist(@NotNull PartialLocalLineStatusTracker tracker, @NotNull Editor editor) {
        MoveChangesLineStatusAction.moveToAnotherChangelist(tracker, DiffUtil.getSelectedLines((Editor)editor));
    }

    public static void moveToAnotherChangelist(@NotNull PartialLocalLineStatusTracker tracker, @NotNull BitSet selectedLines) {
        Project project = tracker.getProject();
        List ranges = tracker.getRangesForLines(selectedLines);
        if (ranges == null || ranges.isEmpty()) {
            return;
        }
        LocalChangeList targetList = MoveChangesToAnotherListAction.askTargetChangelist(project, ranges, tracker);
        if (targetList == null) {
            return;
        }
        tracker.moveToChangelist(selectedLines, targetList);
    }

    public static void moveToAnotherChangelist(@NotNull PartialLocalLineStatusTracker tracker, @NotNull LocalRange range) {
        Project project = tracker.getProject();
        LocalChangeList targetList = MoveChangesToAnotherListAction.askTargetChangelist(project, Collections.singletonList(range), tracker);
        if (targetList == null) {
            return;
        }
        tracker.moveToChangelist(range, targetList);
    }
}

