/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui.browser;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ui.ChangeNodeDecorator;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserBase;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNode;
import com.intellij.openapi.vcs.changes.ui.TreeModelBuilder;
import com.intellij.openapi.vcs.changes.ui.browser.ChangesFilterer;
import com.intellij.ui.components.ProgressBarLoadingDecorator;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FilterableChangesBrowser
extends ChangesBrowserBase
implements Disposable {
    private final ChangesFilterer myChangesFilterer;
    private ProgressBarLoadingDecorator myLoadingDecorator;

    protected FilterableChangesBrowser(@NotNull Project project, boolean showCheckboxes, boolean highlightProblems) {
        super(project, showCheckboxes, highlightProblems);
        this.myChangesFilterer = new ChangesFilterer(this.myProject, this::updateTreeOnFilterChange);
        Disposer.register((Disposable)this, (Disposable)this.myChangesFilterer);
    }

    private void updateTreeOnFilterChange() {
        boolean oldKeepTreeState = this.myViewer.isKeepTreeState();
        this.myViewer.setKeepTreeState(true);
        this.myViewer.rebuildTree();
        this.myViewer.setKeepTreeState(oldKeepTreeState);
        this.myViewer.expandDefaults();
        float progress = this.myChangesFilterer.getProgress();
        if (progress == 1.0f) {
            this.myLoadingDecorator.stopLoading();
        } else {
            this.myLoadingDecorator.startLoading();
            this.myLoadingDecorator.getProgressBar().setIndeterminate(progress == 0.0f);
            this.myLoadingDecorator.getProgressBar().setValue((int)(100.0f * progress));
        }
        this.onActiveChangesFilterChanges();
    }

    protected void onActiveChangesFilterChanges() {
    }

    public void dispose() {
    }

    public boolean hasActiveChangesFilter() {
        return this.myChangesFilterer.hasActiveFilter();
    }

    public void clearActiveChangesFilter() {
        this.myChangesFilterer.clearFilter();
    }

    public ChangesFilterer.FilteredState filterChanges(@NotNull List<? extends Change> changes, boolean shouldFilter) {
        if (!shouldFilter) {
            this.myChangesFilterer.setChanges(null);
            return ChangesFilterer.FilteredState.create(changes);
        }
        this.myChangesFilterer.setChanges(changes);
        return this.myChangesFilterer.getFilteredChanges();
    }

    @Override
    @Nullable
    public Object getData(@NotNull String dataId) {
        if (ChangesFilterer.DATA_KEY.is(dataId)) {
            return this.myChangesFilterer;
        }
        return super.getData(dataId);
    }

    @Override
    @NotNull
    protected JComponent createCenterPanel() {
        JComponent centerPanel = super.createCenterPanel();
        this.myLoadingDecorator = new ProgressBarLoadingDecorator((JPanel)JBUI.Panels.simplePanel((Component)centerPanel), (Disposable)this, 300);
        return this.myLoadingDecorator.getComponent();
    }

    protected static void setFilteredChanges(@NotNull TreeModelBuilder builder, @NotNull ChangesFilterer.FilteredState filteredState, @Nullable ChangeNodeDecorator changeNodeDecorator) {
        builder.setChanges(filteredState.getChanges(), changeNodeDecorator);
        FilterableChangesBrowser.setPendingChanges(builder, filteredState.getPending(), changeNodeDecorator);
        FilterableChangesBrowser.setFilteredOutChanges(builder, filteredState.getFilteredOut(), changeNodeDecorator);
    }

    protected static void setPendingChanges(@NotNull TreeModelBuilder builder, @NotNull Collection<? extends Change> changes, @Nullable ChangeNodeDecorator changeNodeDecorator) {
        if (changes.isEmpty()) {
            return;
        }
        ChangesBrowserNode<?> tagNode = builder.createTagNode(VcsBundle.message((String)"changes.nodetitle.filter.pending", (Object[])new Object[0]), false);
        builder.insertChanges(changes, tagNode, changeNodeDecorator);
    }

    protected static void setFilteredOutChanges(@NotNull TreeModelBuilder builder, @NotNull Collection<? extends Change> changes, @Nullable ChangeNodeDecorator changeNodeDecorator) {
        if (changes.isEmpty()) {
            return;
        }
        ChangesBrowserNode<?> tagNode = builder.createTagNode(VcsBundle.message((String)"changes.nodetitle.filtered.out", (Object[])new Object[0]), false);
        builder.insertChanges(changes, tagNode, changeNodeDecorator);
    }
}

