/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.diff.util.DiffUserDataKeysEx;
import com.intellij.ide.HelpIdProvider;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.impl.LaterInvocator;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComponentContainer;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.OptionAction;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangeListManagerImpl;
import com.intellij.openapi.vcs.changes.ChangeViewDiffRequestProcessor;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.CommitExecutor;
import com.intellij.openapi.vcs.changes.CommitExecutorBase;
import com.intellij.openapi.vcs.changes.CommitResultHandler;
import com.intellij.openapi.vcs.changes.InclusionListener;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.RefreshablePanel;
import com.intellij.openapi.vcs.changes.actions.diff.lst.LocalChangeListDiffTool;
import com.intellij.openapi.vcs.changes.ui.ChangeInfoCalculator;
import com.intellij.openapi.vcs.changes.ui.CommitDialogChangesBrowser;
import com.intellij.openapi.vcs.changes.ui.CommitLegendPanel;
import com.intellij.openapi.vcs.changes.ui.DefaultCommitChangeListDialog;
import com.intellij.openapi.vcs.changes.ui.EditChangelistSupport;
import com.intellij.openapi.vcs.checkin.BaseCheckinHandlerFactory;
import com.intellij.openapi.vcs.checkin.BeforeCheckinDialogHandler;
import com.intellij.openapi.vcs.checkin.CheckinHandler;
import com.intellij.openapi.vcs.ui.CommitMessage;
import com.intellij.openapi.vcs.ui.RefreshableOnComponent;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.JBColor;
import com.intellij.ui.SplitterWithSecondHideable;
import com.intellij.ui.components.JBBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.Alarm;
import com.intellij.util.ArrayUtil;
import com.intellij.util.EventDispatcher;
import com.intellij.util.MathUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.AbstractLayoutManager;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.SwingHelper;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.components.BorderLayoutPanel;
import com.intellij.vcs.commit.AbstractCommitWorkflow;
import com.intellij.vcs.commit.CommitExecutorListener;
import com.intellij.vcs.commit.CommitMessageUi;
import com.intellij.vcs.commit.CommitOptions;
import com.intellij.vcs.commit.CommitOptionsKt;
import com.intellij.vcs.commit.CommitOptionsPanel;
import com.intellij.vcs.commit.CommitOptionsUi;
import com.intellij.vcs.commit.CommitWorkflowUiStateListener;
import com.intellij.vcs.commit.SingleChangeListCommitWorkflow;
import com.intellij.vcs.commit.SingleChangeListCommitWorkflowHandler;
import com.intellij.vcs.commit.SingleChangeListCommitWorkflowKt;
import com.intellij.vcs.commit.SingleChangeListCommitWorkflowUi;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import kotlin.jvm.functions.Function0;
import kotlin.sequences.SequencesKt;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CommitChangeListDialog
extends DialogWrapper
implements SingleChangeListCommitWorkflowUi,
ComponentContainer {
    public static final String DIALOG_TITLE = VcsBundle.message((String)"commit.dialog.title", (Object[])new Object[0]);
    private static final String HELP_ID = "reference.dialogs.vcs.commit";
    private static final int LAYOUT_VERSION = 2;
    private static final String SPLITTER_PROPORTION_OPTION = "CommitChangeListDialog.SPLITTER_PROPORTION_2";
    private static final String DETAILS_SPLITTER_PROPORTION_OPTION = "CommitChangeListDialog.DETAILS_SPLITTER_PROPORTION_2";
    private static final String DETAILS_SHOW_OPTION = "CommitChangeListDialog.DETAILS_SHOW_OPTION_";
    private static final float SPLITTER_PROPORTION_OPTION_DEFAULT = 0.5f;
    private static final float DETAILS_SPLITTER_PROPORTION_OPTION_DEFAULT = 0.6f;
    private static final boolean DETAILS_SHOW_OPTION_DEFAULT = true;
    @NotNull
    private final Project myProject;
    @NotNull
    private final SingleChangeListCommitWorkflow myWorkflow;
    @NotNull
    private final EventDispatcher<CommitWorkflowUiStateListener> myStateEventDispatcher = EventDispatcher.create(CommitWorkflowUiStateListener.class);
    @NotNull
    private final EventDispatcher<CommitExecutorListener> myExecutorEventDispatcher = EventDispatcher.create(CommitExecutorListener.class);
    @NotNull
    private final List<DataProvider> myDataProviders = new ArrayList<DataProvider>();
    @NotNull
    private final EventDispatcher<InclusionListener> myInclusionEventDispatcher = EventDispatcher.create(InclusionListener.class);
    @NotNull
    private String myDefaultCommitActionName = "";
    @Nullable
    private CommitAction myCommitAction;
    @NotNull
    private final List<CommitExecutorAction> myExecutorActions = new ArrayList<CommitExecutorAction>();
    @NotNull
    private final CommitOptionsPanel myCommitOptions;
    @NotNull
    private final ChangeInfoCalculator myChangesInfoCalculator;
    @NotNull
    private final JComponent myBrowserBottomPanel = JBBox.createHorizontalBox();
    @NotNull
    private final MyChangeProcessor myDiffDetails;
    @NotNull
    private final CommitMessage myCommitMessageArea;
    @NotNull
    private final CommitLegendPanel myLegend;
    @NotNull
    private final Splitter mySplitter;
    @NotNull
    private final SplitterWithSecondHideable myDetailsSplitter;
    @NotNull
    private final JBLabel myWarningLabel;
    @Nullable
    private final String myHelpId;
    @NotNull
    private final Alarm myOKButtonUpdateAlarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD);
    @NotNull
    private final Runnable myUpdateButtonsRunnable = () -> {
        this.updateButtons();
        this.updateLegend();
    };
    private boolean myDisposed = false;
    private boolean myUpdateDisabled = false;

    public static boolean commitChanges(@NotNull Project project, @NotNull Collection<? extends Change> changes, @Nullable LocalChangeList initialSelection, @Nullable CommitExecutor executor, @Nullable String comment) {
        return CommitChangeListDialog.commitChanges(project, changes, changes, initialSelection, executor, comment);
    }

    public static boolean commitChanges(@NotNull Project project, @NotNull Collection<? extends Change> changes, @NotNull Collection<?> included, @Nullable LocalChangeList initialSelection, @Nullable CommitExecutor executor, @Nullable String comment) {
        if (executor == null) {
            return CommitChangeListDialog.commitChanges(project, new ArrayList<Change>(changes), included, initialSelection, AbstractCommitWorkflow.getCommitExecutors(project, changes), true, null, comment, null, true);
        }
        return CommitChangeListDialog.commitChanges(project, new ArrayList<Change>(changes), included, initialSelection, Collections.singletonList(executor), false, null, comment, null, true);
    }

    public static boolean commitChanges(@NotNull Project project, @NotNull Collection<? extends Change> changes, @Nullable LocalChangeList initialSelection, @NotNull List<? extends CommitExecutor> executors, boolean showVcsCommit, @Nullable String comment, @Nullable CommitResultHandler customResultHandler) {
        return CommitChangeListDialog.commitChanges(project, new ArrayList<Change>(changes), initialSelection, executors, showVcsCommit, comment, customResultHandler, true);
    }

    public static boolean commitChanges(@NotNull Project project, @NotNull List<Change> changes, @Nullable LocalChangeList initialSelection, @NotNull List<? extends CommitExecutor> executors, boolean showVcsCommit, @Nullable String comment, @Nullable CommitResultHandler customResultHandler, boolean cancelIfNoChanges) {
        return CommitChangeListDialog.commitChanges(project, changes, changes, initialSelection, executors, showVcsCommit, null, comment, customResultHandler, cancelIfNoChanges);
    }

    public static boolean commitChanges(@NotNull Project project, @NotNull List<Change> changes, @NotNull Collection<?> included, @Nullable LocalChangeList initialSelection, @NotNull List<? extends CommitExecutor> executors, boolean showVcsCommit, @Nullable AbstractVcs forceCommitInVcs, @Nullable String comment, @Nullable CommitResultHandler customResultHandler, boolean cancelIfNoChanges) {
        ChangeListManager manager = ChangeListManager.getInstance((Project)project);
        LocalChangeList defaultList = manager.getDefaultChangeList();
        List changeLists = manager.getChangeListsCopy();
        HashSet<AbstractVcs> affectedVcses = new HashSet<AbstractVcs>();
        if (forceCommitInVcs != null) {
            affectedVcses.add(forceCommitInVcs);
        }
        for (Object list : changeLists) {
            affectedVcses.addAll(ChangesUtil.getAffectedVcses((Collection)list.getChanges(), (Project)project));
        }
        if (showVcsCommit) {
            List<VirtualFile> unversionedFiles = ChangeListManagerImpl.getInstanceImpl(project).getUnversionedFiles();
            affectedVcses.addAll(ChangesUtil.getAffectedVcsesForFiles(unversionedFiles, (Project)project));
        }
        if (cancelIfNoChanges && affectedVcses.isEmpty()) {
            Messages.showInfoMessage((Project)project, (String)VcsBundle.message((String)"commit.dialog.no.changes.detected.text", (Object[])new Object[0]), (String)VcsBundle.message((String)"commit.dialog.no.changes.detected.title", (Object[])new Object[0]));
            return false;
        }
        AbstractVcs[] vcses = ProjectLevelVcsManager.getInstance((Project)project).getAllActiveVcss();
        for (BaseCheckinHandlerFactory factory : AbstractCommitWorkflow.getCommitHandlerFactories(Arrays.asList(vcses))) {
            BeforeCheckinDialogHandler handler = factory.createSystemReadyHandler(project);
            if (handler == null || handler.beforeCommitDialogShown(project, changes, executors, showVcsCommit)) continue;
            return false;
        }
        boolean isDefaultChangeListFullyIncluded = new HashSet<Change>(changes).containsAll(defaultList.getChanges());
        SingleChangeListCommitWorkflow workflow = new SingleChangeListCommitWorkflow(project, affectedVcses, included, initialSelection, executors, showVcsCommit, isDefaultChangeListFullyIncluded, comment, customResultHandler);
        DefaultCommitChangeListDialog dialog = new DefaultCommitChangeListDialog(workflow);
        return new SingleChangeListCommitWorkflowHandler(workflow, dialog).activate();
    }

    protected CommitChangeListDialog(@NotNull SingleChangeListCommitWorkflow workflow) {
        super(workflow.getProject(), true, Registry.is((String)"ide.perProjectModality") ? DialogWrapper.IdeModalityType.PROJECT : DialogWrapper.IdeModalityType.IDE);
        this.myWorkflow = workflow;
        this.myProject = this.myWorkflow.getProject();
        Disposer.register((Disposable)this.getDisposable(), (Disposable)this);
        List<CommitExecutor> executors = this.myWorkflow.getCommitExecutors();
        if (!this.isDefaultCommitEnabled() && ContainerUtil.isEmpty(executors)) {
            throw new IllegalArgumentException("nothing found to execute commit with");
        }
        this.setTitle(this.isDefaultCommitEnabled() ? DIALOG_TITLE : SingleChangeListCommitWorkflowKt.getPresentableText(executors.get(0)));
        this.myHelpId = this.isDefaultCommitEnabled() ? HELP_ID : CommitChangeListDialog.getHelpId(executors);
        this.myDiffDetails = new MyChangeProcessor(this.myProject, this.myWorkflow.isPartialCommitEnabled());
        this.myCommitMessageArea = new CommitMessage(this.myProject, true, true, this.isDefaultCommitEnabled());
        this.myChangesInfoCalculator = new ChangeInfoCalculator();
        this.myLegend = new CommitLegendPanel(this.myChangesInfoCalculator);
        this.mySplitter = new Splitter(true);
        this.myCommitOptions = new CommitOptionsPanel((Function0<String>)((Function0)() -> this.getDefaultCommitActionName()));
        this.myWarningLabel = new JBLabel();
        JPanel mainPanel = new JPanel((LayoutManager)((Object)new MyOptionsLayout((JComponent)this.mySplitter, this.myCommitOptions, JBUIScale.scale((int)150), JBUIScale.scale((int)400))));
        mainPanel.add((Component)this.mySplitter);
        mainPanel.add((Component)((Object)this.myCommitOptions));
        BorderLayoutPanel rootPane = JBUI.Panels.simplePanel((Component)mainPanel).addToBottom((Component)this.myWarningLabel);
        this.myDetailsSplitter = this.createDetailsSplitter((JPanel)rootPane);
    }

    @NotNull
    public abstract CommitDialogChangesBrowser getBrowser();

    public boolean activate() {
        this.beforeInit();
        this.init();
        this.afterInit();
        return this.showAndGet();
    }

    @Override
    public void deactivate() {
        this.close(0);
    }

    @Override
    public void addStateListener(@NotNull CommitWorkflowUiStateListener listener2, @NotNull Disposable parent) {
        this.myStateEventDispatcher.addListener((EventListener)listener2, parent);
    }

    private void beforeInit() {
        this.getBrowser().setInclusionChangedListener(() -> ((InclusionListener)this.myInclusionEventDispatcher.getMulticaster()).inclusionChanged());
        this.addInclusionListener(() -> this.updateButtons(), (Disposable)this);
        this.getBrowser().getViewer().addSelectionListener(() -> this.refreshDetails(this.getBrowser().getViewer().isModelUpdateInProgress(), true));
        this.initCommitActions(this.myWorkflow.getCommitExecutors());
        this.myCommitOptions.setBorder((Border)JBUI.Borders.emptyLeft((int)10));
        this.myBrowserBottomPanel.add((Component)this.myLegend.getComponent());
        BorderLayoutPanel topPanel = JBUI.Panels.simplePanel().addToCenter((Component)this.getBrowser()).addToBottom((Component)this.myBrowserBottomPanel);
        this.mySplitter.setHonorComponentsMinimumSize(true);
        this.mySplitter.setFirstComponent((JComponent)topPanel);
        this.mySplitter.setSecondComponent((JComponent)this.myCommitMessageArea);
        this.mySplitter.setProportion(PropertiesComponent.getInstance().getFloat(SPLITTER_PROPORTION_OPTION, 0.5f));
        this.myWarningLabel.setForeground((Color)JBColor.RED);
        this.myWarningLabel.setBorder((Border)JBUI.Borders.empty((int)5, (int)5, (int)0, (int)5));
        this.updateWarning();
    }

    private void afterInit() {
        this.updateButtons();
        this.updateLegend();
        this.myCommitMessageArea.setChangeList((ChangeList)this.getChangeList());
        this.myCommitMessageArea.requestFocusInMessage();
        for (EditChangelistSupport support : (EditChangelistSupport[])EditChangelistSupport.EP_NAME.getExtensions((AreaInstance)this.myProject)) {
            support.installSearch(this.myCommitMessageArea.getEditorField(), this.myCommitMessageArea.getEditorField());
        }
        this.showDetailsIfSaved();
        LaterInvocator.markTransparent((ModalityState)ModalityState.stateForComponent((Component)this.getComponent()));
    }

    @NotNull
    private SplitterWithSecondHideable createDetailsSplitter(@NotNull JPanel rootPane) {
        SplitterWithSecondHideable.OnOffListener listener2 = new SplitterWithSecondHideable.OnOffListener(){

            public void on(int hideableHeight) {
                if (hideableHeight == 0) {
                    return;
                }
                CommitChangeListDialog.this.getWindow().addComponentListener(new ComponentAdapter(){

                    @Override
                    public void componentResized(ComponentEvent e) {
                        e.getComponent().removeComponentListener(this);
                        CommitChangeListDialog.this.refreshDetails(false, true);
                    }
                });
                CommitChangeListDialog.this.mySplitter.skipNextLayout();
                CommitChangeListDialog.this.myDetailsSplitter.getComponent().skipNextLayout();
                Dimension dialogSize = CommitChangeListDialog.this.getSize();
                CommitChangeListDialog.this.setSize(dialogSize.width, dialogSize.height + hideableHeight);
                CommitChangeListDialog.this.repaint();
            }

            public void off(int hideableHeight) {
                if (hideableHeight == 0) {
                    return;
                }
                CommitChangeListDialog.this.myDiffDetails.clear();
                CommitChangeListDialog.this.mySplitter.skipNextLayout();
                CommitChangeListDialog.this.myDetailsSplitter.getComponent().skipNextLayout();
                Dimension dialogSize = CommitChangeListDialog.this.getSize();
                CommitChangeListDialog.this.setSize(dialogSize.width, dialogSize.height - hideableHeight);
                CommitChangeListDialog.this.repaint();
            }
        };
        return new SplitterWithSecondHideable(true, "Diff", rootPane, listener2){

            protected RefreshablePanel createDetails() {
                BorderLayoutPanel panel2 = JBUI.Panels.simplePanel((Component)CommitChangeListDialog.this.myDiffDetails.getComponent());
                return new RefreshablePanel((JPanel)panel2){
                    final /* synthetic */ JPanel val$panel;
                    {
                        this.val$panel = jPanel;
                    }

                    public void refresh() {
                    }

                    public JPanel getPanel() {
                        return this.val$panel;
                    }
                };
            }

            protected float getSplitterInitialProportion() {
                float value = PropertiesComponent.getInstance().getFloat(CommitChangeListDialog.DETAILS_SPLITTER_PROPORTION_OPTION, 0.6f);
                return (double)value <= 0.05 || (double)value >= 0.95 ? 0.6f : value;
            }
        };
    }

    private void initCommitActions(@NotNull List<? extends CommitExecutor> executors) {
        this.myExecutorActions.addAll(this.createExecutorActions(executors));
        if (this.isDefaultCommitEnabled()) {
            this.myCommitAction = new CommitAction(this.getDefaultCommitActionName());
            this.myCommitAction.setOptions(this.myExecutorActions);
        } else {
            this.myCommitAction = null;
            this.myExecutorActions.get(0).putValue("DefaultAction", Boolean.TRUE);
        }
    }

    @NotNull
    private List<CommitExecutorAction> createExecutorActions(@NotNull List<? extends CommitExecutor> executors) {
        if (executors.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<CommitExecutorAction> result2 = new ArrayList<CommitExecutorAction>();
        if (this.isDefaultCommitEnabled() && UISettings.getShadowInstance().getAllowMergeButtons()) {
            ActionGroup group = (ActionGroup)ActionManager.getInstance().getAction("Vcs.CommitExecutor.Actions");
            result2.addAll(ContainerUtil.map((Object[])group.getChildren(null), x$0 -> new CommitExecutorAction((AnAction)x$0)));
            result2.addAll(ContainerUtil.map((Collection)ContainerUtil.filter(executors, CommitExecutor::useDefaultAction), x$0 -> new CommitExecutorAction((CommitExecutor)x$0)));
        } else {
            result2.addAll(ContainerUtil.map(executors, x$0 -> new CommitExecutorAction((CommitExecutor)x$0)));
        }
        return result2;
    }

    @Nullable
    private static String getHelpId(@NotNull List<? extends CommitExecutor> executors) {
        return StreamEx.of(executors).select(HelpIdProvider.class).map(HelpIdProvider::getHelpId).nonNull().findFirst().orElse(null);
    }

    private void showDetailsIfSaved() {
        boolean showDetails = PropertiesComponent.getInstance().getBoolean(DETAILS_SHOW_OPTION, true);
        if (showDetails) {
            this.myDetailsSplitter.initOn();
            this.myDetailsSplitter.setInitialProportion();
            UIUtil.runWhenWindowOpened((Window)this.getWindow(), () -> {
                this.myDetailsSplitter.setInitialProportion();
                this.refreshDetails(false, false);
            });
        }
    }

    protected void updateWarning() {
        if (this.myWarningLabel != null) {
            Object[] messages;
            this.myWarningLabel.setVisible(false);
            VcsException updateException = ChangeListManagerImpl.getInstanceImpl(this.myProject).getUpdateException();
            if (updateException != null && !ArrayUtil.isEmpty((Object[])(messages = updateException.getMessages()))) {
                String message = "Warning: not all local changes may be shown due to an error: " + (String)messages[0];
                String htmlMessage = SwingHelper.buildHtml((String)UIUtil.getCssFontDeclaration((Font)UIUtil.getLabelFont()), (String)UIUtil.getHtmlBody((String)StringUtil.escapeXmlEntities((String)message)));
                this.myWarningLabel.setText(htmlMessage);
                this.myWarningLabel.setVisible(true);
            }
        }
    }

    @Nullable
    protected String getHelpId() {
        return this.myHelpId;
    }

    @NotNull
    protected Action getOKAction() {
        return this.myCommitAction != null ? this.myCommitAction : (Action)this.myExecutorActions.get(0);
    }

    protected Action @NotNull [] createActions() {
        ArrayList<Action> result2 = new ArrayList<Action>();
        if (this.myCommitAction != null) {
            result2.add(this.myCommitAction);
        } else {
            result2.addAll(this.myExecutorActions);
        }
        result2.add(this.getCancelAction());
        if (this.myHelpId != null) {
            result2.add(this.getHelpAction());
        }
        return result2.toArray(new Action[0]);
    }

    public void dispose() {
        this.myDisposed = true;
        Disposer.dispose((Disposable)this.getBrowser());
        Disposer.dispose((Disposable)this.myCommitMessageArea);
        Disposer.dispose((Disposable)this.myOKButtonUpdateAlarm);
        super.dispose();
        Disposer.dispose((Disposable)this.myDiffDetails);
        PropertiesComponent.getInstance().setValue(SPLITTER_PROPORTION_OPTION, this.mySplitter.getProportion(), 0.5f);
        float usedProportion = this.myDetailsSplitter.getUsedProportion();
        if (usedProportion > 0.0f) {
            PropertiesComponent.getInstance().setValue(DETAILS_SPLITTER_PROPORTION_OPTION, usedProportion, 0.6f);
        }
        PropertiesComponent.getInstance().setValue(DETAILS_SHOW_OPTION, this.myDetailsSplitter.isOn(), true);
    }

    private void stopUpdate() {
        this.myUpdateDisabled = true;
    }

    private void restartUpdate() {
        this.myUpdateDisabled = false;
        this.myUpdateButtonsRunnable.run();
    }

    public void doCancelAction() {
        ((CommitWorkflowUiStateListener)this.myStateEventDispatcher.getMulticaster()).cancelled();
        super.doCancelAction();
    }

    @NotNull
    protected JComponent createCenterPanel() {
        return this.myDetailsSplitter.getComponent();
    }

    @Deprecated
    @NotNull
    public Set<? extends AbstractVcs> getAffectedVcses() {
        return this.isDefaultCommitEnabled() ? this.myWorkflow.getVcses() : Collections.emptySet();
    }

    public boolean hasDiffs() {
        return !this.getIncludedChanges().isEmpty() || !this.getIncludedUnversionedFiles().isEmpty();
    }

    @NotNull
    public Project getProject() {
        return this.myProject;
    }

    @Deprecated
    public void setCommitMessage(@Nullable String commitMessage2) {
    }

    @Deprecated
    @NotNull
    public String getCommitMessage() {
        return this.myCommitMessageArea.getText();
    }

    @NotNull
    public List<RefreshableOnComponent> getAdditionalComponents() {
        return SequencesKt.toList(CommitOptionsKt.getAllOptions(this.getCommitOptions()));
    }

    private void updateButtons() {
        if (this.myDisposed || this.myUpdateDisabled) {
            return;
        }
        boolean enabled = this.hasDiffs();
        if (this.myCommitAction != null) {
            this.myCommitAction.setEnabled(enabled);
        }
        this.myExecutorActions.forEach(action -> action.updateEnabled(enabled));
        this.myOKButtonUpdateAlarm.cancelAllRequests();
        this.myOKButtonUpdateAlarm.addRequest(this.myUpdateButtonsRunnable, 300, ModalityState.stateForComponent((Component)this.getBrowser()));
    }

    private void updateLegend() {
        if (this.myDisposed || this.myUpdateDisabled) {
            return;
        }
        this.myChangesInfoCalculator.update(this.getDisplayedChanges(), this.getIncludedChanges(), this.getDisplayedUnversionedFiles().size(), this.getIncludedUnversionedFiles().size());
        this.myLegend.update();
    }

    @NonNls
    protected String getDimensionServiceKey() {
        return "CommitChangelistDialog2";
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myCommitMessageArea.getEditorField();
    }

    @NotNull
    public JComponent getComponent() {
        return this.mySplitter;
    }

    public JComponent getPreferredFocusableComponent() {
        return this.getPreferredFocusedComponent();
    }

    @Nullable
    public Object getData(@NotNull String dataId) {
        return StreamEx.of(this.myDataProviders).map(provider -> provider.getData(dataId)).nonNull().findFirst().orElseGet(() -> this.getBrowser().getData(dataId));
    }

    @NotNull
    public CommitMessageUi getCommitMessageUi() {
        return this.myCommitMessageArea;
    }

    @Override
    @NotNull
    public CommitOptionsUi getCommitOptionsUi() {
        return this.myCommitOptions;
    }

    @NotNull
    public String getDefaultCommitActionName() {
        return this.myDefaultCommitActionName;
    }

    public void setDefaultCommitActionName(@NotNull String defaultCommitActionName) {
        this.myDefaultCommitActionName = defaultCommitActionName;
    }

    public void addDataProvider(@NotNull DataProvider provider) {
        this.myDataProviders.add(provider);
    }

    public void addExecutorListener(@NotNull CommitExecutorListener listener2, @NotNull Disposable parent) {
        this.myExecutorEventDispatcher.addListener((EventListener)listener2, parent);
    }

    public void refreshData() {
        this.getBrowser().updateDisplayedChangeLists();
    }

    @Override
    @NotNull
    public LocalChangeList getChangeList() {
        return this.getBrowser().getSelectedChangeList();
    }

    @NotNull
    public List<Change> getDisplayedChanges() {
        return this.getBrowser().getDisplayedChanges();
    }

    @NotNull
    public List<Change> getIncludedChanges() {
        return this.getBrowser().getIncludedChanges();
    }

    @NotNull
    public List<FilePath> getDisplayedUnversionedFiles() {
        return this.getBrowser().getDisplayedUnversionedFiles();
    }

    @NotNull
    public List<FilePath> getIncludedUnversionedFiles() {
        return this.getBrowser().getIncludedUnversionedFiles();
    }

    public void includeIntoCommit(@NotNull Collection<?> items) {
        this.getBrowser().getViewer().includeChanges(items);
    }

    public void addInclusionListener(@NotNull InclusionListener listener2, @NotNull Disposable parent) {
        this.myInclusionEventDispatcher.addListener((EventListener)listener2, parent);
    }

    public boolean confirmCommitWithEmptyMessage() {
        return 0 == Messages.showYesNoDialog((String)VcsBundle.message((String)"confirmation.text.check.in.with.empty.comment", (Object[])new Object[0]), (String)VcsBundle.message((String)"confirmation.title.check.in.with.empty.comment", (Object[])new Object[0]), (Icon)Messages.getWarningIcon());
    }

    public void startBeforeCommitChecks() {
        this.stopUpdate();
    }

    public void endBeforeCommitChecks(@NotNull CheckinHandler.ReturnResult result2) {
        if (result2 == CheckinHandler.ReturnResult.CANCEL) {
            this.restartUpdate();
        } else if (result2 == CheckinHandler.ReturnResult.CLOSE_WINDOW) {
            this.doCancelAction();
        }
    }

    @NotNull
    private CommitOptions getCommitOptions() {
        return this.myWorkflow.getCommitOptions();
    }

    public boolean isDefaultCommitEnabled() {
        return this.myWorkflow.isDefaultCommitEnabled();
    }

    @NotNull
    CommitMessage getCommitMessageComponent() {
        return this.myCommitMessageArea;
    }

    @NotNull
    JComponent getBrowserBottomPanel() {
        return this.myBrowserBottomPanel;
    }

    private void refreshDetails(boolean fromModelRefresh, boolean async) {
        Runnable task2 = () -> {
            if (this.myDetailsSplitter.isOn()) {
                this.myDiffDetails.refresh(fromModelRefresh);
            }
        };
        if (async) {
            ApplicationManager.getApplication().invokeLater(task2, ModalityState.stateForComponent((Component)this.getRootPane()));
        } else {
            task2.run();
        }
    }

    private static class MyOptionsLayout
    extends AbstractLayoutManager {
        @NotNull
        private final JComponent myPanel;
        @NotNull
        private final CommitOptionsPanel myOptions;
        private final int myMinOptionsWidth;
        private final int myMaxOptionsWidth;

        MyOptionsLayout(@NotNull JComponent panel2, @NotNull CommitOptionsPanel options, int minOptionsWidth, int maxOptionsWidth) {
            this.myPanel = panel2;
            this.myOptions = options;
            this.myMinOptionsWidth = minOptionsWidth;
            this.myMaxOptionsWidth = maxOptionsWidth;
        }

        public Dimension preferredLayoutSize(Container parent) {
            Dimension size1 = this.myPanel.getPreferredSize();
            Dimension size2 = this.myOptions.getPreferredSize();
            return new Dimension(size1.width + size2.width, Math.max(size1.height, size2.height));
        }

        public void layoutContainer(@NotNull Container parent) {
            Rectangle bounds = parent.getBounds();
            int preferredWidth = this.myOptions.getPreferredSize().width;
            int optionsWidth = this.myOptions.isEmpty() ? 0 : MathUtil.clamp((int)preferredWidth, (int)this.myMinOptionsWidth, (int)this.myMaxOptionsWidth);
            this.myPanel.setBounds(new Rectangle(0, 0, bounds.width - optionsWidth, bounds.height));
            this.myOptions.setBounds(new Rectangle(bounds.width - optionsWidth, 0, optionsWidth, bounds.height));
        }
    }

    private class MyChangeProcessor
    extends ChangeViewDiffRequestProcessor {
        MyChangeProcessor(Project project, boolean enablePartialCommit) {
            super(project, "CommitDialog");
            this.putContextUserData(DiffUserDataKeysEx.SHOW_READ_ONLY_LOCK, true);
            this.putContextUserData(LocalChangeListDiffTool.ALLOW_EXCLUDE_FROM_COMMIT, enablePartialCommit);
            this.putContextUserData(DiffUserDataKeysEx.LAST_REVISION_WITH_LOCAL, true);
        }

        @Override
        @NotNull
        protected Stream<ChangeViewDiffRequestProcessor.Wrapper> getSelectedChanges() {
            return this.wrap(CommitChangeListDialog.this.getBrowser().getSelectedChanges(), CommitChangeListDialog.this.getBrowser().getSelectedUnversionedFiles());
        }

        @Override
        @NotNull
        protected Stream<ChangeViewDiffRequestProcessor.Wrapper> getAllChanges() {
            return this.wrap(CommitChangeListDialog.this.getDisplayedChanges(), CommitChangeListDialog.this.getDisplayedUnversionedFiles());
        }

        @Override
        protected void selectChange(@NotNull ChangeViewDiffRequestProcessor.Wrapper change) {
            CommitChangeListDialog.this.getBrowser().selectEntries(Collections.singletonList(change.getUserObject()));
        }

        @NotNull
        private Stream<ChangeViewDiffRequestProcessor.Wrapper> wrap(@NotNull Collection<? extends Change> changes, @NotNull Collection<? extends FilePath> unversioned) {
            return Stream.concat(changes.stream().map(ChangeViewDiffRequestProcessor.ChangeWrapper::new), unversioned.stream().map(ChangeViewDiffRequestProcessor.UnversionedFileWrapper::new));
        }

        protected void onAfterNavigate() {
            CommitChangeListDialog.this.doCancelAction();
        }
    }

    private class CommitExecutorAction
    extends AbstractAction {
        @Nullable
        private final CommitExecutor myCommitExecutor;

        CommitExecutorAction(AnAction anAction) {
            this.putValue("AnAction", anAction);
            this.myCommitExecutor = null;
        }

        CommitExecutorAction(CommitExecutor commitExecutor) {
            super(commitExecutor.getActionText());
            this.myCommitExecutor = commitExecutor;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.myCommitExecutor != null) {
                ((CommitExecutorListener)CommitChangeListDialog.this.myExecutorEventDispatcher.getMulticaster()).executorCalled(this.myCommitExecutor);
            }
        }

        public void updateEnabled(boolean hasDiffs) {
            if (this.myCommitExecutor != null) {
                this.setEnabled(hasDiffs || this.myCommitExecutor instanceof CommitExecutorBase && !((CommitExecutorBase)this.myCommitExecutor).areChangesRequired());
            }
        }
    }

    private class CommitAction
    extends AbstractAction
    implements OptionAction {
        private Action @NotNull [] myOptions;

        private CommitAction(String okActionText) {
            super(okActionText);
            this.myOptions = new Action[0];
            this.putValue("DefaultAction", Boolean.TRUE);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ((CommitExecutorListener)CommitChangeListDialog.this.myExecutorEventDispatcher.getMulticaster()).executorCalled(null);
        }

        public Action @NotNull [] getOptions() {
            return this.myOptions;
        }

        public void setOptions(@NotNull List<? extends Action> actions) {
            this.myOptions = actions.toArray(new Action[0]);
        }
    }
}

