/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.ide.dnd.DnDActionInfo;
import com.intellij.ide.dnd.DnDDragStartBean;
import com.intellij.ide.dnd.DnDEvent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManagerImpl;
import com.intellij.openapi.vcs.changes.shelf.ShelveChangesManager;
import com.intellij.openapi.vcs.changes.ui.ChangeListDragBean;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserChangeListNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNode;
import com.intellij.openapi.vcs.changes.ui.ChangesListView;
import com.intellij.openapi.vcs.changes.ui.ChangesTree;
import com.intellij.openapi.vcs.changes.ui.ChangesTreeDnDSupport;
import com.intellij.openapi.vcs.changes.ui.ShelvedChangeListDragBean;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChangesViewDnDSupport
extends ChangesTreeDnDSupport {
    @NotNull
    private final Project myProject;

    public static void install(@NotNull Project project, @NotNull ChangesTree tree, @NotNull Disposable disposable) {
        new ChangesViewDnDSupport(project, tree).install(disposable);
    }

    private ChangesViewDnDSupport(@NotNull Project project, @NotNull ChangesTree tree) {
        super(tree);
        this.myProject = project;
    }

    @Override
    @Nullable
    protected DnDDragStartBean createDragStartBean(@NotNull DnDActionInfo info) {
        if (info.isMove()) {
            Change[] changes = (Change[])ChangesListView.getChanges(this.myProject, this.myTree.getSelectionPaths()).toArray(Change[]::new);
            List<FilePath> unversionedFiles = ChangesListView.getFilePaths(this.myTree.getSelectionPaths(), ChangesBrowserNode.UNVERSIONED_FILES_TAG).collect(Collectors.toList());
            List<FilePath> ignoredFiles = ChangesListView.getFilePaths(this.myTree.getSelectionPaths(), ChangesBrowserNode.IGNORED_FILES_TAG).collect(Collectors.toList());
            if (changes.length > 0 || !unversionedFiles.isEmpty() || !ignoredFiles.isEmpty()) {
                return new DnDDragStartBean((Object)new ChangeListDragBean((JComponent)((Object)this.myTree), changes, unversionedFiles, ignoredFiles));
            }
        }
        return null;
    }

    @Override
    protected boolean canHandleDropEvent(@NotNull DnDEvent aEvent, @NotNull ChangesBrowserNode<?> dropNode) {
        Object attached = aEvent.getAttachedObject();
        if (attached instanceof ChangeListDragBean) {
            ChangeListDragBean dragBean = (ChangeListDragBean)attached;
            dragBean.setTargetNode(dropNode);
            return dragBean.getSourceComponent() == this.myTree && dropNode.canAcceptDrop(dragBean);
        }
        if (attached instanceof ShelvedChangeListDragBean) {
            return dropNode instanceof ChangesBrowserChangeListNode;
        }
        return false;
    }

    public void drop(DnDEvent aEvent) {
        ChangeListDragBean dragBean;
        ChangesBrowserNode changesBrowserNode;
        Object attached = aEvent.getAttachedObject();
        if (attached instanceof ShelvedChangeListDragBean) {
            ShelveChangesManager.unshelveSilentlyWithDnd(this.myProject, (ShelvedChangeListDragBean)attached, ChangesViewDnDSupport.getDropRootNode(this.myTree, aEvent), !ChangesViewDnDSupport.isCopyAction(aEvent));
        } else if (attached instanceof ChangeListDragBean && (changesBrowserNode = (dragBean = (ChangeListDragBean)attached).getTargetNode()) != null) {
            ChangeListManagerImpl changeListManager = ChangeListManagerImpl.getInstanceImpl(this.myProject);
            changesBrowserNode.acceptDrop(changeListManager, dragBean);
        }
    }
}

