/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.changes.ui.ChangeNodeDecorator;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNode;
import com.intellij.openapi.vcs.changes.ui.ChangesTree;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.swing.border.Border;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Deprecated
public abstract class ChangesTreeList<T>
extends ChangesTree {
    @NotNull
    private final List<T> myRawChanges = new ArrayList<T>();
    @Nullable
    private ChangeNodeDecorator myChangeDecorator;

    public ChangesTreeList(@NotNull Project project, @NotNull Collection<T> initiallyIncluded, boolean showCheckboxes, boolean highlightProblems, @Nullable Runnable inclusionListener, @Nullable ChangeNodeDecorator decorator) {
        super(project, showCheckboxes, highlightProblems);
        this.setIncludedChanges(initiallyIncluded);
        this.setInclusionListener(inclusionListener);
        this.myChangeDecorator = decorator;
    }

    public ChangesTreeList(@NotNull Project project, boolean showCheckboxes, boolean highlightProblems) {
        super(project, showCheckboxes, highlightProblems);
    }

    public void setChangeDecorator(@Nullable ChangeNodeDecorator changeDecorator) {
        this.myChangeDecorator = changeDecorator;
        this.rebuildTree();
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2017")
    public void setScrollPaneBorder(Border border) {
    }

    public void setChangesToDisplay(List<? extends T> changes) {
        this.setChangesToDisplay(changes, null);
    }

    public void setChangesToDisplay(List<? extends T> changes, @Nullable VirtualFile toSelect) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.myProject.isDisposed()) {
            return;
        }
        this.myRawChanges.clear();
        this.myRawChanges.addAll(changes);
        this.rebuildTree();
        if (toSelect != null) {
            this.selectFile(toSelect);
        }
    }

    protected abstract DefaultTreeModel buildTreeModel(List<T> var1, ChangeNodeDecorator var2);

    @Override
    public void rebuildTree() {
        DefaultTreeModel newModel = this.buildTreeModel(this.myRawChanges, this.myChangeDecorator);
        this.updateTreeModel(newModel);
    }

    @NotNull
    public List<T> getChanges() {
        return this.getSelectedObjects(this.getRoot());
    }

    @NotNull
    public List<T> getSelectedChanges() {
        TreePath[] paths = this.getSelectionPaths();
        if (paths == null) {
            return Collections.emptyList();
        }
        LinkedHashSet<T> changes = new LinkedHashSet<T>();
        for (TreePath path2 : paths) {
            changes.addAll(this.getSelectedObjects((ChangesBrowserNode)path2.getLastPathComponent()));
        }
        return new ArrayList(changes);
    }

    @NotNull
    private List<T> getSelectedChangesOrAllIfNone() {
        List<T> changes = this.getSelectedChanges();
        if (!changes.isEmpty()) {
            return changes;
        }
        return this.getChanges();
    }

    protected abstract List<T> getSelectedObjects(ChangesBrowserNode<?> var1);

    @Nullable
    protected abstract T getLeadSelectedObject(ChangesBrowserNode<?> var1);

    @Nullable
    public T getHighestLeadSelection() {
        TreePath path2 = this.getSelectionPath();
        if (path2 == null) {
            return null;
        }
        return this.getLeadSelectedObject((ChangesBrowserNode)path2.getLastPathComponent());
    }

    @Nullable
    public T getLeadSelection() {
        TreePath path2 = this.getSelectionPath();
        return (T)(path2 == null ? null : ContainerUtil.getFirstItem(this.getSelectedObjects((ChangesBrowserNode)path2.getLastPathComponent())));
    }

    @NotNull
    public Collection<T> getIncludedChanges() {
        Set<Object> includedSet = this.getIncludedSet();
        return ContainerUtil.filter(this.getChanges(), includedSet::contains);
    }

    public void select(@NotNull Collection<T> changes) {
        this.setSelectedChanges(changes);
    }

    public void setAlwaysExpandList(boolean alwaysExpandList) {
        this.setKeepTreeState(!alwaysExpandList);
    }
}

