/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNodeRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class ChangesBrowserSpecificFilePathsNode<T>
extends ChangesBrowserNode<T> {
    protected final boolean myIsMany;
    @NotNull
    protected final Runnable myDialogShower;
    private final int myManyFileCount;
    private final int myManyDirectoryCount;

    protected ChangesBrowserSpecificFilePathsNode(T userObject, @NotNull Collection<FilePath> files, @NotNull Runnable shower) {
        super(userObject);
        this.myManyDirectoryCount = ContainerUtil.count(files, it -> it.isDirectory());
        this.myManyFileCount = files.size() - this.myManyDirectoryCount;
        this.myIsMany = files.size() > Registry.intValue((String)"vcs.unversioned.files.max.intree", (int)1000);
        this.myDialogShower = shower;
    }

    @Override
    public void render(@NotNull ChangesBrowserNodeRenderer renderer, boolean selected, boolean expanded, boolean hasFocus) {
        super.render(renderer, selected, expanded, hasFocus);
        if (this.isManyFiles()) {
            renderer.append(" ", SimpleTextAttributes.REGULAR_ATTRIBUTES);
            renderer.append("browse", SimpleTextAttributes.LINK_ATTRIBUTES, this.myDialogShower);
        }
    }

    @Override
    public int getFileCount() {
        return this.myIsMany ? this.myManyFileCount : super.getFileCount();
    }

    @Override
    public int getDirectoryCount() {
        return this.myIsMany ? this.myManyDirectoryCount : super.getDirectoryCount();
    }

    public boolean isManyFiles() {
        return this.myIsMany;
    }
}

