/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.ide.CopyProvider;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNode;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import javax.swing.JTree;
import org.jetbrains.annotations.NotNull;

class ChangesBrowserNodeCopyProvider
implements CopyProvider {
    @NotNull
    private final JTree myTree;

    ChangesBrowserNodeCopyProvider(@NotNull JTree tree) {
        this.myTree = tree;
    }

    public boolean isCopyEnabled(@NotNull DataContext dataContext) {
        return this.myTree.getSelectionPaths() != null;
    }

    public boolean isCopyVisible(@NotNull DataContext dataContext) {
        return true;
    }

    public void performCopy(@NotNull DataContext dataContext) {
        List paths = ContainerUtil.sorted(Arrays.asList((Object[])Objects.requireNonNull(this.myTree.getSelectionPaths())), (Comparator)TreeUtil.getDisplayOrderComparator((JTree)this.myTree));
        CopyPasteManager.getInstance().setContents((Transferable)new StringSelection(StringUtil.join((Collection)paths, path2 -> {
            Object node = path2.getLastPathComponent();
            if (node instanceof ChangesBrowserNode) {
                return ((ChangesBrowserNode)node).getTextPresentation();
            }
            return node.toString();
        }, (String)"\n")));
    }
}

