/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.changes.LocallyDeletedChange;
import com.intellij.openapi.vcs.changes.issueLinks.TreeLinkMouseListener;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNodeRenderer;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChangesBrowserLocallyDeletedNode
extends ChangesBrowserNode<LocallyDeletedChange>
implements TreeLinkMouseListener.HaveTooltip {
    public ChangesBrowserLocallyDeletedNode(@NotNull LocallyDeletedChange userObject) {
        super(userObject);
    }

    @Override
    protected boolean isFile() {
        return !this.isDirectory();
    }

    @Override
    protected boolean isDirectory() {
        return ((LocallyDeletedChange)this.getUserObject()).getPath().isDirectory();
    }

    @Override
    public void render(@NotNull ChangesBrowserNodeRenderer renderer, boolean selected, boolean expanded, boolean hasFocus) {
        Icon additionalIcon;
        FilePath filePath = ((LocallyDeletedChange)this.getUserObject()).getPath();
        renderer.appendFileName(filePath.getVirtualFile(), filePath.getName(), FileStatus.NOT_CHANGED.getColor());
        if (renderer.isShowFlatten()) {
            this.appendParentPath(renderer, filePath.getParentPath());
        }
        if (!renderer.isShowFlatten() && this.getFileCount() != 1 || this.getDirectoryCount() != 0) {
            this.appendCount(renderer);
        }
        if ((additionalIcon = ((LocallyDeletedChange)this.getUserObject()).getAddIcon()) != null) {
            renderer.setIcon(additionalIcon);
        } else {
            renderer.setIcon(filePath, filePath.isDirectory() || !this.isLeaf());
        }
    }

    @Nullable
    public String getTooltip() {
        return ((LocallyDeletedChange)this.getUserObject()).getDescription();
    }
}

