/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.diff.actions.impl.GoToChangePopupBuilder;
import com.intellij.diff.chains.AsyncDiffRequestChain;
import com.intellij.diff.chains.DiffRequestChain;
import com.intellij.diff.chains.DiffRequestChainBase;
import com.intellij.diff.chains.DiffRequestProducer;
import com.intellij.diff.chains.DiffRequestProducerException;
import com.intellij.openapi.ListSelection;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.changes.actions.diff.ChangeGoToChangePopupAction;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNodeRenderer;
import com.intellij.openapi.vcs.changes.ui.ChangesGroupingPolicyFactory;
import com.intellij.openapi.vcs.changes.ui.TreeModelBuilder;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChangeDiffRequestChain
extends DiffRequestChainBase
implements GoToChangePopupBuilder.Chain {
    private static final Logger LOG = Logger.getInstance(ChangeDiffRequestChain.class);
    @NotNull
    private final List<? extends Producer> myProducers;

    public ChangeDiffRequestChain(@NotNull List<? extends Producer> producers, int index) {
        super(index);
        if (ContainerUtil.exists(producers, Objects::isNull)) {
            producers = ContainerUtil.skipNulls(producers);
            LOG.error("Producers must not be null");
        }
        this.myProducers = producers;
    }

    @NotNull
    public List<? extends Producer> getRequests() {
        return this.myProducers;
    }

    @NotNull
    public AnAction createGoToChangeAction(@NotNull Consumer<? super Integer> onSelected, int defaultSelection) {
        return ChangeDiffRequestChain.createGoToChangeAction((DiffRequestChain)this, onSelected, defaultSelection);
    }

    @NotNull
    private static ChangeGoToChangePopupAction<DiffRequestChain> createGoToChangeAction(final @NotNull DiffRequestChain chain, final @NotNull Consumer<? super Integer> onSelected, final int defaultSelection) {
        return new ChangeGoToChangePopupAction<DiffRequestChain>(chain){

            @Override
            @NotNull
            protected DefaultTreeModel buildTreeModel(@NotNull Project project, @NotNull ChangesGroupingPolicyFactory grouping2) {
                MultiMap groups = new MultiMap();
                List producers = chain.getRequests();
                for (int i = 0; i < producers.size(); ++i) {
                    Producer producer = (Producer)ObjectUtils.tryCast(producers.get(i), Producer.class);
                    if (producer == null) continue;
                    FilePath filePath = producer.getFilePath();
                    FileStatus fileStatus = producer.getFileStatus();
                    Object tag = producer.getPopupTag();
                    groups.putValue(tag, (Object)new GenericChangesBrowserNode(filePath, fileStatus, i));
                }
                MyTreeModelBuilder builder = new MyTreeModelBuilder(project, grouping2);
                for (Object tag : groups.keySet()) {
                    builder.setGenericNodes(groups.get(tag), tag);
                }
                return builder.build();
            }

            @Override
            protected void onSelected(@Nullable ChangesBrowserNode object) {
                GenericChangesBrowserNode node = (GenericChangesBrowserNode)ObjectUtils.tryCast((Object)object, GenericChangesBrowserNode.class);
                onSelected.consume(node != null ? Integer.valueOf(node.getIndex()) : null);
            }

            @Override
            protected Condition<? super DefaultMutableTreeNode> initialSelection() {
                return node -> node instanceof GenericChangesBrowserNode && ((GenericChangesBrowserNode)node).getIndex() == defaultSelection;
            }
        };
    }

    public static abstract class Async
    extends AsyncDiffRequestChain
    implements GoToChangePopupBuilder.Chain {
        @NotNull
        protected abstract ListSelection<? extends Producer> loadRequestProducers() throws DiffRequestProducerException;

        @Nullable
        public AnAction createGoToChangeAction(@NotNull Consumer<? super Integer> onSelected, int defaultSelection) {
            return ChangeDiffRequestChain.createGoToChangeAction((DiffRequestChain)this, (Consumer<? super Integer>)onSelected, defaultSelection);
        }
    }

    private static class GenericChangesBrowserNode
    extends ChangesBrowserNode<FilePath>
    implements Comparable<GenericChangesBrowserNode> {
        @NotNull
        private final FilePath myFilePath;
        @NotNull
        private final FileStatus myFileStatus;
        private final int myIndex;

        protected GenericChangesBrowserNode(@NotNull FilePath filePath, @NotNull FileStatus fileStatus, int index) {
            super(filePath);
            this.myFilePath = filePath;
            this.myFileStatus = fileStatus;
            this.myIndex = index;
        }

        private int getIndex() {
            return this.myIndex;
        }

        @Override
        protected boolean isFile() {
            return !this.isDirectory();
        }

        @Override
        protected boolean isDirectory() {
            return this.myFilePath.isDirectory();
        }

        @Override
        public void render(@NotNull ChangesBrowserNodeRenderer renderer, boolean selected, boolean expanded, boolean hasFocus) {
            renderer.appendFileName(this.myFilePath.getVirtualFile(), this.myFilePath.getName(), this.myFileStatus.getColor());
            if (renderer.isShowFlatten()) {
                this.appendParentPath(renderer, this.myFilePath.getParentPath());
            }
            if (!renderer.isShowFlatten() && this.getFileCount() != 1 || this.getDirectoryCount() != 0) {
                this.appendCount(renderer);
            }
            renderer.setIcon(this.myFilePath, this.myFilePath.isDirectory() || !this.isLeaf());
        }

        @Override
        public String getTextPresentation() {
            return this.myFilePath.getName();
        }

        @Override
        public String toString() {
            return FileUtil.toSystemDependentName((String)this.myFilePath.getPath());
        }

        @Override
        public int compareTo(@NotNull GenericChangesBrowserNode o) {
            return GenericChangesBrowserNode.compareFilePaths(this.myFilePath, o.myFilePath);
        }
    }

    private static class MyTreeModelBuilder
    extends TreeModelBuilder {
        MyTreeModelBuilder(@NotNull Project project, @NotNull ChangesGroupingPolicyFactory grouping2) {
            super(project, grouping2);
        }

        public void setGenericNodes(@NotNull Collection<GenericChangesBrowserNode> nodes, @Nullable Object tag) {
            ChangesBrowserNode<?> parentNode = this.createTagNode(tag);
            for (GenericChangesBrowserNode node : ContainerUtil.sorted(nodes, Comparator.comparing(data -> ((GenericChangesBrowserNode)data).myFilePath, PATH_COMPARATOR))) {
                this.insertChangeNode(node.myFilePath, parentNode, node);
            }
        }
    }

    public static interface Producer
    extends DiffRequestProducer {
        @NotNull
        public FilePath getFilePath();

        @NotNull
        public FileStatus getFileStatus();

        @Nullable
        default public Object getPopupTag() {
            return null;
        }
    }
}

