/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.shelf;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.shelf.ShelvedBinaryFile;
import com.intellij.openapi.vcs.changes.shelf.ShelvedChange;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import java.io.File;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ShelvedWrapper {
    @Nullable
    private final ShelvedChange myShelvedChange;
    @Nullable
    private final ShelvedBinaryFile myBinaryFile;

    ShelvedWrapper(@NotNull ShelvedChange shelvedChange) {
        this.myShelvedChange = shelvedChange;
        this.myBinaryFile = null;
    }

    ShelvedWrapper(@NotNull ShelvedBinaryFile binaryFile) {
        this.myShelvedChange = null;
        this.myBinaryFile = binaryFile;
    }

    @Nullable
    public ShelvedChange getShelvedChange() {
        return this.myShelvedChange;
    }

    @Nullable
    public ShelvedBinaryFile getBinaryFile() {
        return this.myBinaryFile;
    }

    public String getPath() {
        return (String)ObjectUtils.chooseNotNull((Object)this.getAfterPath(), (Object)this.getBeforePath());
    }

    public String getRequestName() {
        return FileUtil.toSystemDependentName((String)this.getPath());
    }

    String getBeforePath() {
        return this.myShelvedChange != null ? this.myShelvedChange.getBeforePath() : Objects.requireNonNull(this.myBinaryFile).BEFORE_PATH;
    }

    String getAfterPath() {
        return this.myShelvedChange != null ? this.myShelvedChange.getAfterPath() : Objects.requireNonNull(this.myBinaryFile).AFTER_PATH;
    }

    FileStatus getFileStatus() {
        return this.myShelvedChange != null ? this.myShelvedChange.getFileStatus() : Objects.requireNonNull(this.myBinaryFile).getFileStatus();
    }

    Change getChange(@NotNull Project project) {
        return this.myShelvedChange != null ? this.myShelvedChange.getChange() : Objects.requireNonNull(this.myBinaryFile).createChange(project);
    }

    @Nullable
    public VirtualFile getBeforeVFUnderProject(@NotNull Project project) {
        if (this.getBeforePath() == null || project.getBasePath() == null) {
            return null;
        }
        File baseDir = new File(project.getBasePath());
        File file = new File(baseDir, this.getBeforePath());
        return LocalFileSystem.getInstance().refreshAndFindFileByIoFile(file);
    }
}

