/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.shelf;

import com.intellij.diff.DiffContentFactory;
import com.intellij.diff.DiffDialogHints;
import com.intellij.diff.DiffManager;
import com.intellij.diff.chains.DiffRequestChain;
import com.intellij.diff.chains.DiffRequestProducerException;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.DocumentContent;
import com.intellij.diff.contents.EmptyContent;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.requests.SimpleDiffRequest;
import com.intellij.diff.requests.UnknownFileTypeDiffRequest;
import com.intellij.diff.tools.util.DiffNotifications;
import com.intellij.diff.tools.util.SoftHardCacheMap;
import com.intellij.diff.util.DiffUtil;
import com.intellij.openapi.ListSelection;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.AnActionExtensionProvider;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.diff.impl.patch.ApplyPatchContext;
import com.intellij.openapi.diff.impl.patch.BaseRevisionTextPatchEP;
import com.intellij.openapi.diff.impl.patch.PatchEP;
import com.intellij.openapi.diff.impl.patch.PatchSyntaxException;
import com.intellij.openapi.diff.impl.patch.TextFilePatch;
import com.intellij.openapi.diff.impl.patch.apply.ApplyFilePatchBase;
import com.intellij.openapi.diff.impl.patch.apply.GenericPatchApplier;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.fileTypes.UnknownFileType;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.CommitContext;
import com.intellij.openapi.vcs.changes.patch.AppliedTextPatch;
import com.intellij.openapi.vcs.changes.patch.ApplyPatchForBaseRevisionTexts;
import com.intellij.openapi.vcs.changes.patch.PatchDiffRequestFactory;
import com.intellij.openapi.vcs.changes.patch.tool.PatchDiffRequest;
import com.intellij.openapi.vcs.changes.shelf.ShelveChangesManager;
import com.intellij.openapi.vcs.changes.shelf.ShelvedBinaryFile;
import com.intellij.openapi.vcs.changes.shelf.ShelvedChange;
import com.intellij.openapi.vcs.changes.shelf.ShelvedChangeList;
import com.intellij.openapi.vcs.changes.shelf.ShelvedChangesViewManager;
import com.intellij.openapi.vcs.changes.shelf.ShelvedWrapper;
import com.intellij.openapi.vcs.changes.ui.ChangeDiffRequestChain;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import com.intellij.vcsUtil.VcsUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DiffShelvedChangesActionProvider
implements AnActionExtensionProvider {
    private static final Logger LOG = Logger.getInstance(DiffShelvedChangesActionProvider.class);

    public boolean isActive(@NotNull AnActionEvent e) {
        return e.getData(ShelvedChangesViewManager.SHELVED_CHANGELIST_KEY) != null || e.getData(ShelvedChangesViewManager.SHELVED_RECYCLED_CHANGELIST_KEY) != null;
    }

    public void update(@NotNull AnActionEvent e) {
        e.getPresentation().setEnabled(DiffShelvedChangesActionProvider.isEnabled(e.getDataContext()));
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        DiffShelvedChangesActionProvider.showShelvedChangesDiff(e.getDataContext());
    }

    public static boolean isEnabled(DataContext dc) {
        Project project = (Project)CommonDataKeys.PROJECT.getData(dc);
        if (project == null) {
            return false;
        }
        List<ShelvedChangeList> changeLists = ShelvedChangesViewManager.getShelvedLists(dc);
        return changeLists.size() == 1;
    }

    public static void showShelvedChangesDiff(DataContext dc) {
        DiffShelvedChangesActionProvider.showShelvedChangesDiff(dc, false);
    }

    public static void showShelvedChangesDiff(DataContext dc, boolean withLocal) {
        CommitContext commitContext;
        PatchesPreloader preloader;
        ApplyPatchContext patchContext;
        Project project = (Project)CommonDataKeys.PROJECT.getData(dc);
        if (project == null) {
            return;
        }
        if (ChangeListManager.getInstance((Project)project).isFreezedWithNotification(null)) {
            return;
        }
        String base = project.getBasePath();
        if (base == null) {
            LOG.error("No base path for project " + project);
            return;
        }
        ListSelection<ShelvedWrapper> wrappers = ShelvedChangesViewManager.getSelectedChangesOrAll(dc);
        ListSelection diffRequestProducers = wrappers.map(arg_0 -> DiffShelvedChangesActionProvider.lambda$showShelvedChangesDiff$0(project, base, patchContext = new ApplyPatchContext(project.getBaseDir(), 0, false, false), preloader = new PatchesPreloader(project), commitContext = new CommitContext(), withLocal, arg_0));
        if (diffRequestProducers.isEmpty()) {
            return;
        }
        ChangeDiffRequestChain chain = new ChangeDiffRequestChain(diffRequestProducers.getList(), diffRequestProducers.getSelectedIndex());
        DiffManager.getInstance().showDiff(project, (DiffRequestChain)chain, DiffDialogHints.FRAME);
    }

    private static ShelveDiffRequestProducer processBinaryChange(@NotNull Project project, @NotNull String base, @NotNull ShelvedBinaryFile shelvedChange) {
        File file = new File(base, shelvedChange.AFTER_PATH == null ? shelvedChange.BEFORE_PATH : shelvedChange.AFTER_PATH);
        FilePath filePath = VcsUtil.getFilePath((File)file);
        return new BinaryShelveDiffRequestProducer(project, shelvedChange, filePath);
    }

    private static ShelveDiffRequestProducer processTextChange(@NotNull Project project, @NotNull String base, @NotNull ApplyPatchContext patchContext, @NotNull PatchesPreloader preloader, @NotNull CommitContext commitContext, @NotNull ShelvedChange shelvedChange, boolean withLocal) {
        String beforePath = shelvedChange.getBeforePath();
        String afterPath = shelvedChange.getAfterPath();
        FilePath filePath = VcsUtil.getFilePath((File)new File(base, afterPath == null ? beforePath : afterPath));
        try {
            if (FileStatus.ADDED.equals(shelvedChange.getFileStatus())) {
                return new NewFileTextShelveDiffRequestProducer(project, shelvedChange, filePath, preloader, commitContext, withLocal);
            }
            VirtualFile file = ApplyFilePatchBase.findPatchTarget(patchContext, beforePath, afterPath);
            if (file == null || !file.exists()) {
                throw new FileNotFoundException(beforePath);
            }
            return new TextShelveDiffRequestProducer(project, shelvedChange, filePath, file, patchContext, preloader, commitContext, withLocal);
        }
        catch (IOException e) {
            return new PatchShelveDiffRequestProducer(project, shelvedChange, filePath, preloader, commitContext);
        }
    }

    @NotNull
    static AppliedTextPatch createAppliedTextPatch(@NotNull TextFilePatch patch) {
        GenericPatchApplier applier = new GenericPatchApplier("", patch.getHunks());
        applier.execute();
        return AppliedTextPatch.create(applier.getAppliedInfo());
    }

    private static /* synthetic */ ShelveDiffRequestProducer lambda$showShelvedChangesDiff$0(Project project, String base, ApplyPatchContext patchContext, PatchesPreloader preloader, CommitContext commitContext, boolean withLocal, ShelvedWrapper s) {
        ShelvedChange textChange = s.getShelvedChange();
        if (textChange != null) {
            return DiffShelvedChangesActionProvider.processTextChange(project, base, patchContext, preloader, commitContext, textChange, withLocal);
        }
        ShelvedBinaryFile binaryChange = s.getBinaryFile();
        if (binaryChange != null) {
            return DiffShelvedChangesActionProvider.processBinaryChange(project, base, binaryChange);
        }
        return null;
    }

    private static abstract class BaseTextShelveDiffRequestProducer
    extends ShelveDiffRequestProducer {
        @NotNull
        protected final Project myProject;
        @NotNull
        protected final ShelvedChange myChange;

        BaseTextShelveDiffRequestProducer(@NotNull Project project, @NotNull ShelvedChange change, @NotNull FilePath filePath) {
            super(filePath);
            this.myChange = change;
            this.myProject = project;
        }

        @Override
        @NotNull
        public FileStatus getFileStatus() {
            return this.myChange.getFileStatus();
        }

        @Override
        @NotNull
        public ShelvedChange getTextChange() {
            return this.myChange;
        }
    }

    private static class TextShelveDiffRequestProducer
    extends BaseTextShelveDiffRequestProducer {
        @NotNull
        private final VirtualFile myFile;
        @NotNull
        private final ApplyPatchContext myPatchContext;
        @NotNull
        private final PatchesPreloader myPreloader;
        @NotNull
        private final CommitContext myCommitContext;
        private final boolean myWithLocal;

        TextShelveDiffRequestProducer(@NotNull Project project, @NotNull ShelvedChange change, @NotNull FilePath filePath, @NotNull VirtualFile file, @NotNull ApplyPatchContext patchContext, @NotNull PatchesPreloader preloader, @NotNull CommitContext commitContext, boolean withLocal) {
            super(project, change, filePath);
            this.myFile = file;
            this.myPatchContext = patchContext;
            this.myPreloader = preloader;
            this.myCommitContext = commitContext;
            this.myWithLocal = withLocal;
        }

        @NotNull
        public DiffRequest process(@NotNull UserDataHolder context, @NotNull ProgressIndicator indicator) throws DiffRequestProducerException, ProcessCanceledException {
            if (FileTypeRegistry.getInstance().isFileOfType(this.myFile, UnknownFileType.INSTANCE)) {
                return new UnknownFileTypeDiffRequest(this.myFile, this.getName());
            }
            try {
                TextFilePatch patch = this.myPreloader.getPatch(this.myChange, this.myCommitContext);
                if (patch.isDeletedFile()) {
                    return this.createDiffRequestForDeleted(patch);
                }
                String path2 = (String)ObjectUtils.chooseNotNull((Object)patch.getAfterName(), (Object)patch.getBeforeName());
                CharSequence baseContents = ((BaseRevisionTextPatchEP)PatchEP.EP_NAME.findExtensionOrFail(BaseRevisionTextPatchEP.class, (AreaInstance)this.myProject)).provideContent(path2, this.myCommitContext);
                ApplyPatchForBaseRevisionTexts texts = ApplyPatchForBaseRevisionTexts.create(this.myProject, this.myFile, this.myPatchContext.getPathBeforeRename(this.myFile), patch, baseContents);
                if (texts.isBaseRevisionLoaded()) {
                    assert (!texts.isAppliedSomehow());
                    return this.createDiffRequestUsingBase(texts);
                }
                return this.createDiffRequestUsingLocal(texts, patch, context, indicator);
            }
            catch (VcsException e) {
                throw new DiffRequestProducerException("Can't show diff for '" + this.getFilePath() + "'", (Throwable)e);
            }
        }

        @NotNull
        private DiffRequest createDiffRequestForDeleted(@NotNull TextFilePatch patch) {
            String leftTitle;
            DiffContent leftContent;
            DiffContentFactory contentFactory = DiffContentFactory.getInstance();
            if (this.myWithLocal) {
                leftContent = contentFactory.create(this.myProject, this.myFile);
                leftTitle = DiffBundle.message((String)"merge.version.title.current", (Object[])new Object[0]);
            } else {
                leftContent = contentFactory.create(this.myProject, patch.getSingleHunkPatchText(), this.myFile);
                leftTitle = VcsBundle.message((String)"shelve.shelved.version", (Object[])new Object[0]);
            }
            EmptyContent rightContent = contentFactory.createEmpty();
            String rightTitle = null;
            return new SimpleDiffRequest(this.getName(), leftContent, (DiffContent)rightContent, leftTitle, rightTitle);
        }

        @NotNull
        private DiffRequest createDiffRequestUsingBase(@NotNull ApplyPatchForBaseRevisionTexts texts) {
            String leftTitle;
            DiffContent leftContent;
            DiffContentFactory contentFactory = DiffContentFactory.getInstance();
            if (this.myWithLocal) {
                leftContent = contentFactory.create(this.myProject, this.myFile);
                leftTitle = DiffBundle.message((String)"merge.version.title.current", (Object[])new Object[0]);
            } else {
                leftContent = contentFactory.create(this.myProject, Objects.requireNonNull(texts.getBase()), this.myFile);
                leftTitle = DiffBundle.message((String)"merge.version.title.base", (Object[])new Object[0]);
            }
            DocumentContent rightContent = contentFactory.create(this.myProject, texts.getPatched(), this.myFile);
            return new SimpleDiffRequest(this.getName(), leftContent, (DiffContent)rightContent, leftTitle, VcsBundle.message((String)"shelve.shelved.version", (Object[])new Object[0]));
        }

        private DiffRequest createDiffRequestUsingLocal(@NotNull ApplyPatchForBaseRevisionTexts texts, @NotNull TextFilePatch patch, @NotNull UserDataHolder context, @NotNull ProgressIndicator indicator) throws DiffRequestProducerException {
            DiffRequest diffRequest;
            DiffRequest diffRequest2 = diffRequest = this.myChange.isConflictingChange() ? PatchDiffRequestFactory.createConflictDiffRequest(this.myProject, this.myFile, patch, VcsBundle.message((String)"shelve.shelved.version", (Object[])new Object[0]), texts, this.getName()) : PatchDiffRequestFactory.createDiffRequest(this.myProject, this.myChange.getChange(), this.getName(), context, indicator);
            if (!this.myWithLocal) {
                DiffUtil.addNotification((JComponent)DiffNotifications.createNotification((String)VcsBundle.message((String)"shelve.base.content.not.found.or.not.applicable.error", (Object[])new Object[0])), (UserDataHolder)diffRequest);
            }
            return diffRequest;
        }
    }

    private static class NewFileTextShelveDiffRequestProducer
    extends BaseTextShelveDiffRequestProducer {
        @NotNull
        private final PatchesPreloader myPreloader;
        @NotNull
        private final CommitContext myCommitContext;
        private final boolean myWithLocal;

        NewFileTextShelveDiffRequestProducer(@NotNull Project project, @NotNull ShelvedChange change, @NotNull FilePath filePath, @NotNull PatchesPreloader preloader, @NotNull CommitContext commitContext, boolean withLocal) {
            super(project, change, filePath);
            this.myPreloader = preloader;
            this.myCommitContext = commitContext;
            this.myWithLocal = withLocal;
        }

        @NotNull
        public DiffRequest process(@NotNull UserDataHolder context, @NotNull ProgressIndicator indicator) throws DiffRequestProducerException, ProcessCanceledException {
            VirtualFile file = this.myFilePath.getVirtualFile();
            if (this.myWithLocal && file != null) {
                try {
                    TextFilePatch patch = this.myPreloader.getPatch(this.myChange, this.myCommitContext);
                    DiffContentFactory contentFactory = DiffContentFactory.getInstance();
                    DiffContent leftContent = contentFactory.create(this.myProject, file);
                    DocumentContent rightContent = contentFactory.create(this.myProject, patch.getSingleHunkPatchText(), file);
                    return new SimpleDiffRequest(this.getName(), leftContent, (DiffContent)rightContent, DiffBundle.message((String)"merge.version.title.current", (Object[])new Object[0]), VcsBundle.message((String)"shelve.shelved.version", (Object[])new Object[0]));
                }
                catch (VcsException e) {
                    throw new DiffRequestProducerException("Can't show diff for '" + this.getFilePath() + "'", (Throwable)e);
                }
            }
            return PatchDiffRequestFactory.createDiffRequest(this.myProject, this.myChange.getChange(), this.getName(), context, indicator);
        }
    }

    private static class PatchShelveDiffRequestProducer
    extends BaseTextShelveDiffRequestProducer {
        private final PatchesPreloader myPreloader;
        private final CommitContext myCommitContext;

        PatchShelveDiffRequestProducer(@NotNull Project project, @NotNull ShelvedChange change, @NotNull FilePath filePath, @NotNull PatchesPreloader preloader, @NotNull CommitContext commitContext) {
            super(project, change, filePath);
            this.myPreloader = preloader;
            this.myCommitContext = commitContext;
        }

        @NotNull
        public DiffRequest process(@NotNull UserDataHolder context, @NotNull ProgressIndicator indicator) throws DiffRequestProducerException {
            try {
                TextFilePatch patch = this.myPreloader.getPatch(this.myChange, this.myCommitContext);
                AppliedTextPatch appliedTextPatch = DiffShelvedChangesActionProvider.createAppliedTextPatch(patch);
                PatchDiffRequest request = new PatchDiffRequest(appliedTextPatch, this.getName(), VcsBundle.message((String)"patch.apply.conflict.patch", (Object[])new Object[0]));
                DiffUtil.addNotification((JComponent)DiffNotifications.createNotification((String)DiffBundle.message((String)"cannot.file.file.error", (Object[])new Object[]{this.getFilePath()})), (UserDataHolder)request);
                return request;
            }
            catch (VcsException e) {
                throw new DiffRequestProducerException("Can't show diff for '" + this.getFilePath() + "'", (Throwable)e);
            }
        }
    }

    private static class BinaryShelveDiffRequestProducer
    extends ShelveDiffRequestProducer {
        @NotNull
        private final Project myProject;
        @NotNull
        private final ShelvedBinaryFile myBinaryChange;

        BinaryShelveDiffRequestProducer(@NotNull Project project, @NotNull ShelvedBinaryFile change, @NotNull FilePath filePath) {
            super(filePath);
            this.myBinaryChange = change;
            this.myProject = project;
        }

        @NotNull
        public DiffRequest process(@NotNull UserDataHolder context, @NotNull ProgressIndicator indicator) throws DiffRequestProducerException, ProcessCanceledException {
            Change change = this.myBinaryChange.createChange(this.myProject);
            return PatchDiffRequestFactory.createDiffRequest(this.myProject, change, this.getName(), context, indicator);
        }

        @Override
        @NotNull
        public FileStatus getFileStatus() {
            return this.myBinaryChange.getFileStatus();
        }

        @Override
        @NotNull
        public ShelvedBinaryFile getBinaryChange() {
            return this.myBinaryChange;
        }
    }

    private static abstract class ShelveDiffRequestProducer
    implements ChangeDiffRequestChain.Producer {
        @NotNull
        protected final FilePath myFilePath;

        ShelveDiffRequestProducer(@NotNull FilePath filePath) {
            this.myFilePath = filePath;
        }

        @Nullable
        public ShelvedChange getTextChange() {
            return null;
        }

        @Nullable
        public ShelvedBinaryFile getBinaryChange() {
            return null;
        }

        @NotNull
        public String getName() {
            return FileUtil.toSystemDependentName((String)this.getFilePath().getPath());
        }

        @Override
        @NotNull
        public FilePath getFilePath() {
            return this.myFilePath;
        }
    }

    static class PatchesPreloader {
        private final Project myProject;
        private final SoftHardCacheMap<String, PatchInfo> myFilePatchesMap = new SoftHardCacheMap(5, 5);
        private final ReadWriteLock myLock = new ReentrantReadWriteLock(true);

        PatchesPreloader(Project project) {
            this.myProject = project;
        }

        @NotNull
        public TextFilePatch getPatch(ShelvedChange shelvedChange, @Nullable CommitContext commitContext) throws VcsException {
            PatchInfo patchInfo;
            String patchPath = shelvedChange.getPatchPath();
            if (this.getInfoFromCache(patchPath) == null || this.isPatchFileChanged(patchPath)) {
                this.readFilePatchAndUpdateCaches(patchPath, commitContext);
            }
            if ((patchInfo = this.getInfoFromCache(patchPath)) != null) {
                for (TextFilePatch textFilePatch : patchInfo.myTextFilePatches) {
                    if (!shelvedChange.getBeforePath().equals(textFilePatch.getBeforeName())) continue;
                    return textFilePatch;
                }
            }
            throw new VcsException("Can not find patch for " + shelvedChange.getBeforePath() + " in patch file.");
        }

        private PatchInfo getInfoFromCache(@NotNull String patchPath) {
            try {
                this.myLock.readLock().lock();
                PatchInfo patchInfo = (PatchInfo)this.myFilePatchesMap.get((Object)patchPath);
                return patchInfo;
            }
            finally {
                this.myLock.readLock().unlock();
            }
        }

        private void readFilePatchAndUpdateCaches(@NotNull String patchPath, @Nullable CommitContext commitContext) throws VcsException {
            try {
                this.myLock.writeLock().lock();
                this.myFilePatchesMap.put((Object)patchPath, (Object)new PatchInfo(ShelveChangesManager.loadPatches(this.myProject, patchPath, commitContext), new File(patchPath).lastModified()));
            }
            catch (PatchSyntaxException | IOException e) {
                throw new VcsException((Throwable)e);
            }
            finally {
                this.myLock.writeLock().unlock();
            }
        }

        public boolean isPatchFileChanged(@NotNull String patchPath) {
            PatchInfo patchInfo = this.getInfoFromCache(patchPath);
            long lastModified = new File(patchPath).lastModified();
            return patchInfo != null && lastModified != patchInfo.myLoadedTimeStamp;
        }

        private static class PatchInfo {
            private final long myLoadedTimeStamp;
            @NotNull
            private final List<TextFilePatch> myTextFilePatches;

            PatchInfo(@NotNull List<TextFilePatch> patches, long loadedTimeStamp) {
                this.myTextFilePatches = patches;
                this.myLoadedTimeStamp = loadedTimeStamp;
            }
        }
    }
}

