/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.shelf;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.changes.shelf.CleanUnshelvedFilterDialog;
import com.intellij.openapi.vcs.changes.shelf.ShelveChangesManager;
import org.jetbrains.annotations.NotNull;

public class CleanUnshelvedAction
extends DumbAwareAction {
    public void update(@NotNull AnActionEvent e) {
        super.update(e);
        Project project = CleanUnshelvedAction.getEventProject((AnActionEvent)e);
        Presentation presentation = e.getPresentation();
        if (project == null) {
            presentation.setEnabledAndVisible(false);
            return;
        }
        presentation.setVisible(true);
        presentation.setEnabled(!ShelveChangesManager.getInstance(project).getRecycledShelvedChangeLists().isEmpty());
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project = (Project)e.getRequiredData(CommonDataKeys.PROJECT);
        CleanUnshelvedFilterDialog dialog = new CleanUnshelvedFilterDialog(project);
        dialog.show();
        if (dialog.isOK()) {
            if (dialog.isUnshelvedWithFilterSelected()) {
                ShelveChangesManager.getInstance(project).cleanUnshelved(dialog.getTimeLimitInMillis());
            } else {
                ShelveChangesManager.getInstance(project).clearRecycled();
            }
        }
    }
}

