/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.patch;

import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vcs.VcsBundle;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RelativePathCalculator {
    private static final int ourNumOfAllowedStepsAbove = 1;
    private static final int ourAllowedStepsDown = 2;
    private final String myShifted;
    private final String myBase;
    private boolean myRename;

    public RelativePathCalculator(@NotNull String base, @NotNull String shifted) {
        this.myShifted = shifted;
        this.myBase = base;
    }

    private static boolean stringEqual(@NotNull String s1, @NotNull String s2) {
        if (!SystemInfo.isFileSystemCaseSensitive) {
            return s1.equalsIgnoreCase(s2);
        }
        return s1.equals(s2);
    }

    @NotNull
    public String execute() {
        int i;
        if (RelativePathCalculator.stringEqual(this.myShifted, this.myBase)) {
            return ".";
        }
        String[] baseParts = RelativePathCalculator.split(this.myBase);
        String[] shiftedParts = RelativePathCalculator.split(this.myShifted);
        this.myRename = RelativePathCalculator.checkRename(baseParts, shiftedParts);
        int cnt = 0;
        while (true) {
            if (baseParts.length <= cnt || shiftedParts.length <= cnt) {
                --cnt;
                break;
            }
            if (!RelativePathCalculator.stringEqual(baseParts[cnt], shiftedParts[cnt])) break;
            ++cnt;
        }
        int stepsUp = baseParts.length - cnt - 1;
        if (!this.myRename && stepsUp > 1 && shiftedParts.length - cnt <= 2) {
            return this.myShifted;
        }
        StringBuilder sb = new StringBuilder();
        for (i = 0; i < stepsUp; ++i) {
            sb.append("../");
        }
        for (i = cnt; i < shiftedParts.length - 1; ++i) {
            String shiftedPart = shiftedParts[i];
            sb.append(shiftedPart);
            sb.append('/');
        }
        String oldName = baseParts[baseParts.length - 1];
        String newName = shiftedParts[shiftedParts.length - 1];
        boolean skipFileName = oldName.equals(newName);
        if (!skipFileName) {
            sb.append(newName);
        }
        return sb.toString();
    }

    private boolean isRename() {
        return this.myRename;
    }

    private static boolean checkRename(String[] baseParts, String[] shiftedParts) {
        if (baseParts.length == shiftedParts.length) {
            for (int i = 0; i < baseParts.length; ++i) {
                if (RelativePathCalculator.stringEqual(baseParts[i], shiftedParts[i])) continue;
                return i == baseParts.length - 1;
            }
        }
        return false;
    }

    @Nullable
    public static String getMovedString(String beforeName, String afterName) {
        if (beforeName != null && afterName != null && !RelativePathCalculator.stringEqual(beforeName, afterName)) {
            RelativePathCalculator calculator = new RelativePathCalculator(beforeName, afterName);
            String result2 = calculator.execute();
            String key = calculator.isRename() ? "change.file.renamed.to.text" : "change.file.moved.to.text";
            return VcsBundle.message((String)key, (Object[])new Object[]{result2});
        }
        return null;
    }

    public static String[] split(String s) {
        return s.replace(File.separatorChar, '/').split("/");
    }
}

