/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.patch;

import com.intellij.diff.DiffManager;
import com.intellij.diff.InvalidDiffRequestException;
import com.intellij.diff.merge.MergeRequest;
import com.intellij.diff.merge.MergeResult;
import com.intellij.diff.util.DiffUserDataKeysEx;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.impl.patch.ApplyPatchContext;
import com.intellij.openapi.diff.impl.patch.ApplyPatchStatus;
import com.intellij.openapi.diff.impl.patch.BaseRevisionTextPatchEP;
import com.intellij.openapi.diff.impl.patch.FilePatch;
import com.intellij.openapi.diff.impl.patch.PatchEP;
import com.intellij.openapi.diff.impl.patch.TextFilePatch;
import com.intellij.openapi.diff.impl.patch.apply.ApplyFilePatch;
import com.intellij.openapi.diff.impl.patch.apply.ApplyFilePatchBase;
import com.intellij.openapi.diff.impl.patch.apply.GenericPatchApplier;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Getter;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsApplicationSettings;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.CommitContext;
import com.intellij.openapi.vcs.changes.patch.AppliedTextPatch;
import com.intellij.openapi.vcs.changes.patch.ApplyPatchDefaultExecutor;
import com.intellij.openapi.vcs.changes.patch.ApplyPatchDifferentiatedDialog;
import com.intellij.openapi.vcs.changes.patch.ApplyPatchForBaseRevisionTexts;
import com.intellij.openapi.vcs.changes.patch.ApplyPatchMode;
import com.intellij.openapi.vcs.changes.patch.ImportToShelfExecutor;
import com.intellij.openapi.vcs.changes.patch.PatchDiffRequestFactory;
import com.intellij.openapi.vcs.changes.patch.PatchFileType;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.vcsUtil.VcsUtil;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ApplyPatchAction
extends DumbAwareAction {
    private static final Logger LOG = Logger.getInstance(ApplyPatchAction.class);

    public void update(@NotNull AnActionEvent e) {
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        if (ActionPlaces.isPopupPlace((String)e.getPlace())) {
            VirtualFile vFile = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
            e.getPresentation().setEnabledAndVisible(project != null && PatchFileType.isPatchFile(vFile));
        } else {
            e.getPresentation().setVisible(true);
            e.getPresentation().setEnabled(project != null);
        }
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project = (Project)e.getRequiredData(CommonDataKeys.PROJECT);
        if (ChangeListManager.getInstance((Project)project).isFreezedWithNotification(VcsBundle.message((String)"patch.apply.cannot.apply.now", (Object[])new Object[0]))) {
            return;
        }
        FileDocumentManager.getInstance().saveAllDocuments();
        VirtualFile vFile = null;
        String place = e.getPlace();
        if (ActionPlaces.isPopupPlace((String)e.getPlace()) || "MainMenu".equals(place)) {
            vFile = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
        }
        if (PatchFileType.isPatchFile(vFile)) {
            ApplyPatchAction.showApplyPatch(project, vFile);
        } else {
            FileChooserDescriptor descriptor = ApplyPatchDifferentiatedDialog.createSelectPatchDescriptor();
            VcsApplicationSettings settings = VcsApplicationSettings.getInstance();
            VirtualFile toSelect = settings.PATCH_STORAGE_LOCATION == null ? null : LocalFileSystem.getInstance().refreshAndFindFileByIoFile(new File(settings.PATCH_STORAGE_LOCATION));
            FileChooser.chooseFile((FileChooserDescriptor)descriptor, (Project)project, (VirtualFile)toSelect, file -> {
                VirtualFile parent = file.getParent();
                if (parent != null) {
                    settings.PATCH_STORAGE_LOCATION = parent.getPath();
                }
                ApplyPatchAction.showApplyPatch(project, file);
            });
        }
    }

    public static void showApplyPatch(@NotNull Project project, @NotNull VirtualFile file) {
        ApplyPatchDifferentiatedDialog dialog = new ApplyPatchDifferentiatedDialog(project, new ApplyPatchDefaultExecutor(project), Collections.singletonList(new ImportToShelfExecutor(project)), ApplyPatchMode.APPLY, file);
        dialog.show();
    }

    public static Boolean showAndGetApplyPatch(@NotNull Project project, @NotNull File file) {
        VirtualFile vFile = VfsUtil.findFileByIoFile((File)file, (boolean)true);
        String patchPath = file.getPath();
        if (vFile == null) {
            VcsNotifier.getInstance(project).notifyWeakError(VcsBundle.message((String)"patch.apply.can.t.find.patch.file.warning", (Object[])new Object[]{patchPath}));
            return false;
        }
        if (!PatchFileType.isPatchFile(vFile)) {
            VcsNotifier.getInstance(project).notifyWeakError(VcsBundle.message((String)"patch.apply.not.patch.type.file.error", (Object[])new Object[]{patchPath}));
            return false;
        }
        ApplyPatchDifferentiatedDialog dialog = new ApplyPatchDifferentiatedDialog(project, new ApplyPatchDefaultExecutor(project), Collections.emptyList(), ApplyPatchMode.APPLY_PATCH_IN_MEMORY, vFile);
        dialog.setModal(true);
        return dialog.showAndGet();
    }

    public static void applySkipDirs(List<? extends FilePatch> patches, int skipDirs) {
        if (skipDirs < 1) {
            return;
        }
        for (FilePatch filePatch : patches) {
            filePatch.setBeforeName(ApplyPatchAction.skipN(filePatch.getBeforeName(), skipDirs));
            filePatch.setAfterName(ApplyPatchAction.skipN(filePatch.getAfterName(), skipDirs));
        }
    }

    private static String skipN(String path2, int num) {
        String[] pieces = path2.split("/");
        StringBuilder sb = new StringBuilder();
        for (int i = num; i < pieces.length; ++i) {
            String piece = pieces[i];
            sb.append('/').append(piece);
        }
        return sb.toString();
    }

    @NotNull
    public static ApplyPatchStatus applyContent(@Nullable Project project, @NotNull ApplyFilePatchBase patch, @Nullable ApplyPatchContext context, @NotNull VirtualFile file, @Nullable CommitContext commitContext, boolean reverse, @Nullable String leftPanelTitle, @Nullable String rightPanelTitle) {
        ApplyFilePatch.Result result2 = ApplyPatchAction.tryApplyPatch(project, patch, context, file, commitContext);
        ApplyPatchStatus status = result2.getStatus();
        if (ApplyPatchStatus.ALREADY_APPLIED.equals((Object)status) || ApplyPatchStatus.SUCCESS.equals((Object)status)) {
            return status;
        }
        ApplyPatchForBaseRevisionTexts mergeData = result2.getMergeData();
        if (mergeData == null) {
            return status;
        }
        Document document = FileDocumentManager.getInstance().getDocument(file);
        if (document == null) {
            return ApplyPatchStatus.FAILURE;
        }
        String baseContent = ApplyPatchAction.convertLineSeparators(mergeData.getBase());
        String localContent = ApplyPatchAction.convertLineSeparators(mergeData.getLocal());
        String patchedContent = mergeData.getPatched();
        Ref applyPatchStatusReference = new Ref();
        Consumer callback2 = result13 -> {
            FileDocumentManager.getInstance().saveDocument(document);
            applyPatchStatusReference.setIfNull((Object)(result13 != MergeResult.CANCEL ? ApplyPatchStatus.SUCCESS : ApplyPatchStatus.FAILURE));
        };
        try {
            MergeRequest request;
            if (baseContent != null) {
                if (reverse) {
                    if (leftPanelTitle == null) {
                        leftPanelTitle = VcsBundle.message((String)"patch.apply.conflict.patched.version", (Object[])new Object[0]);
                    }
                    if (rightPanelTitle == null) {
                        rightPanelTitle = VcsBundle.message((String)"patch.apply.conflict.local.version", (Object[])new Object[0]);
                    }
                    List<String> contents = Arrays.asList(patchedContent, baseContent, localContent);
                    List<String> titles = Arrays.asList(leftPanelTitle, null, rightPanelTitle);
                    request = PatchDiffRequestFactory.createMergeRequest(project, document, file, contents, null, titles, (Consumer<? super MergeResult>)callback2);
                } else {
                    request = PatchDiffRequestFactory.createMergeRequest(project, document, file, baseContent, localContent, patchedContent, (Consumer<? super MergeResult>)callback2);
                }
            } else {
                TextFilePatch textPatch = (TextFilePatch)patch.getPatch();
                GenericPatchApplier applier = new GenericPatchApplier(localContent, textPatch.getHunks());
                applier.execute();
                AppliedTextPatch appliedTextPatch = AppliedTextPatch.create(applier.getAppliedInfo());
                request = PatchDiffRequestFactory.createBadMergeRequest(project, document, file, localContent, appliedTextPatch, (Consumer<? super MergeResult>)callback2);
            }
            request.putUserData(DiffUserDataKeysEx.MERGE_ACTION_CAPTIONS, result12 -> result12.equals((Object)MergeResult.CANCEL) ? VcsBundle.message((String)"patch.apply.abort.action", (Object[])new Object[0]) : null);
            request.putUserData(DiffUserDataKeysEx.MERGE_CANCEL_HANDLER, viewer -> {
                String message = VcsBundle.message((String)"patch.apply.abort.and.rollback.prompt", (Object[])new Object[0]);
                String title2 = VcsBundle.message((String)"patch.apply.abort.title", (Object[])new Object[0]);
                String yesText = VcsBundle.message((String)"patch.apply.abort.and.rollback.action", (Object[])new Object[0]);
                String noText = VcsBundle.message((String)"patch.apply.skip.action", (Object[])new Object[0]);
                String cancelText = VcsBundle.message((String)"patch.apply.continue.resolve.action", (Object[])new Object[0]);
                int result1 = 0;
                result1 = Messages.canShowMacSheetPanel() ? Messages.showYesNoCancelDialog((Component)viewer.getComponent().getRootPane(), (String)"", (String)message, (String)yesText, (String)noText, (String)cancelText, (Icon)Messages.getQuestionIcon()) : Messages.showYesNoCancelDialog((Component)viewer.getComponent().getRootPane(), (String)message, (String)title2, (String)yesText, (String)noText, (String)cancelText, (Icon)Messages.getQuestionIcon());
                if (result1 == 0) {
                    applyPatchStatusReference.set((Object)ApplyPatchStatus.ABORT);
                } else if (result1 == 1) {
                    applyPatchStatusReference.set((Object)ApplyPatchStatus.SKIP);
                }
                return result1 != 2;
            });
            DiffManager.getInstance().showMerge(project, request);
            return (ApplyPatchStatus)((Object)applyPatchStatusReference.get());
        }
        catch (InvalidDiffRequestException e) {
            LOG.warn((Throwable)e);
            return ApplyPatchStatus.FAILURE;
        }
    }

    @NotNull
    private static ApplyFilePatch.Result tryApplyPatch(@Nullable Project project, @NotNull ApplyFilePatchBase patch, @Nullable ApplyPatchContext context, @NotNull VirtualFile file, @Nullable CommitContext commitContext) {
        Object patchBase = patch.getPatch();
        return (ApplyFilePatch.Result)WriteAction.compute(() -> {
            try {
                return patch.apply(file, context, project, VcsUtil.getFilePath((VirtualFile)file), (Getter<CharSequence>)((Getter)() -> {
                    assert (project != null);
                    BaseRevisionTextPatchEP baseRevisionTextPatchEP = (BaseRevisionTextPatchEP)PatchEP.EP_NAME.findExtensionOrFail(BaseRevisionTextPatchEP.class, (AreaInstance)project);
                    String path2 = (String)ObjectUtils.chooseNotNull((Object)patchBase.getBeforeName(), (Object)patchBase.getAfterName());
                    return baseRevisionTextPatchEP.provideContent(path2, commitContext);
                }), commitContext);
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
                return ApplyFilePatch.FAILURE;
            }
        });
    }

    @Nullable
    private static String convertLineSeparators(@Nullable String charSequence) {
        return charSequence != null ? StringUtil.convertLineSeparators((String)charSequence) : null;
    }
}

