/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ignore.lang;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.PsiParser;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.changes.ignore.lang.IgnoreFileType;
import com.intellij.openapi.vcs.changes.ignore.lang.IgnoreLanguage;
import com.intellij.openapi.vcs.changes.ignore.lexer.IgnoreLexerAdapter;
import com.intellij.openapi.vcs.changes.ignore.parser.IgnoreParser;
import com.intellij.openapi.vcs.changes.ignore.psi.IgnoreFile;
import com.intellij.openapi.vcs.changes.ignore.psi.IgnoreTypes;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.IFileElementType;
import com.intellij.psi.tree.TokenSet;
import org.jetbrains.annotations.NotNull;

public class IgnoreParserDefinition
implements ParserDefinition {
    public static final IFileElementType FILE = new IFileElementType(Language.findInstance(IgnoreLanguage.class));

    @NotNull
    public Lexer createLexer(Project project) {
        return new IgnoreLexerAdapter();
    }

    public PsiParser createParser(Project project) {
        return new IgnoreParser();
    }

    public IFileElementType getFileNodeType() {
        return FILE;
    }

    @NotNull
    public TokenSet getWhitespaceTokens() {
        return Lazy.WHITE_SPACES;
    }

    @NotNull
    public TokenSet getCommentTokens() {
        return Lazy.COMMENTS;
    }

    @NotNull
    public TokenSet getStringLiteralElements() {
        return TokenSet.EMPTY;
    }

    @NotNull
    public PsiElement createElement(ASTNode node) {
        return IgnoreTypes.Factory.createElement(node);
    }

    public PsiFile createFile(FileViewProvider viewProvider) {
        if (viewProvider.getBaseLanguage() instanceof IgnoreLanguage) {
            return ((IgnoreLanguage)viewProvider.getBaseLanguage()).createFile(viewProvider);
        }
        return new IgnoreFile(viewProvider, IgnoreFileType.INSTANCE);
    }

    public static final class Lazy {
        public static final TokenSet WHITE_SPACES = TokenSet.WHITE_SPACE;
        public static final TokenSet COMMENTS = TokenSet.create((IElementType[])new IElementType[]{IgnoreTypes.COMMENT});
        public static final TokenSet SECTIONS = TokenSet.create((IElementType[])new IElementType[]{IgnoreTypes.SECTION});
        public static final TokenSet HEADERS = TokenSet.create((IElementType[])new IElementType[]{IgnoreTypes.HEADER});
    }
}

