/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.committed;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.RepositoryLocation;
import com.intellij.openapi.vcs.VcsDirectoryMapping;
import com.intellij.openapi.vcs.changes.committed.RepositoryLocationCache;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcsUtil.VcsUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RootsCalculator {
    private static final Logger LOG = Logger.getInstance(RootsCalculator.class);
    @NotNull
    private final Project myProject;
    @NotNull
    private final AbstractVcs myVcs;
    @NotNull
    private final ProjectLevelVcsManager myPlManager;
    @NotNull
    private final RepositoryLocationCache myLocationCache;

    public RootsCalculator(@NotNull Project project, @NotNull AbstractVcs vcs, @NotNull RepositoryLocationCache locationCache) {
        this.myProject = project;
        this.myLocationCache = locationCache;
        this.myPlManager = ProjectLevelVcsManager.getInstance((Project)this.myProject);
        this.myVcs = vcs;
    }

    @NotNull
    public Map<VirtualFile, RepositoryLocation> getRoots() {
        LOG.debug("Collecting roots for " + this.myVcs);
        List<VirtualFile> roots = this.getRootsFromMappings();
        ContainerUtil.addAll(roots, (Object[])this.myPlManager.getRootsUnderVcs(this.myVcs));
        RootsCalculator.logRoots("Candidates", roots);
        roots.removeIf(file -> this.getLocation((VirtualFile)file) == null);
        RootsCalculator.logRoots("Candidates with repository location", roots);
        Map result2 = ((StreamEx)StreamEx.of((Collection)this.myVcs.filterUniqueRoots(roots, Function.identity())).distinct()).mapToEntry(this::getLocation).nonNullValues().toMap();
        RootsCalculator.logRoots("Unique roots", result2.keySet());
        return result2;
    }

    @NotNull
    private List<VirtualFile> getRootsFromMappings() {
        ArrayList<VirtualFile> result2 = new ArrayList<VirtualFile>();
        for (VcsDirectoryMapping mapping : this.myPlManager.getDirectoryMappings(this.myVcs)) {
            if (mapping.isDefaultMapping()) {
                if (!this.myVcs.equals((Object)this.myPlManager.getVcsFor(this.myProject.getBaseDir()))) continue;
                result2.add(this.myProject.getBaseDir());
                continue;
            }
            VirtualFile newFile = LocalFileSystem.getInstance().refreshAndFindFileByPath(mapping.getDirectory());
            if (newFile != null) {
                result2.add(newFile);
                continue;
            }
            LOG.info("Can not find virtual file for root: " + mapping.getDirectory());
        }
        return result2;
    }

    @Nullable
    private RepositoryLocation getLocation(@NotNull VirtualFile file) {
        return this.myLocationCache.getLocation(this.myVcs, VcsUtil.getFilePath((VirtualFile)file), false);
    }

    private static void logRoots(@NotNull String prefix, @NotNull Collection<? extends VirtualFile> roots) {
        if (LOG.isDebugEnabled()) {
            LOG.debug(prefix + ": " + StringUtil.join(roots, VirtualFile::getPath, (String)", "));
        }
    }
}

