/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.committed;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.CommittedChangesProvider;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.RepositoryLocation;
import com.intellij.openapi.vcs.VcsBundle;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RepositoryLocationCache {
    @NotNull
    private final Project myProject;
    @NotNull
    private final Map<Couple<String>, RepositoryLocation> myMap = Collections.synchronizedMap(new HashMap());

    public RepositoryLocationCache(@NotNull Project project) {
        this.myProject = project;
    }

    @Nullable
    public RepositoryLocation getLocation(@NotNull AbstractVcs vcs, @NotNull FilePath filePath, boolean silent) {
        Couple key = Couple.of((Object)vcs.getName(), (Object)filePath.getPath());
        RepositoryLocation location = this.myMap.get(key);
        if (location == null) {
            location = this.getLocationUnderProgress(vcs, filePath, silent);
            this.myMap.put((Couple<String>)key, location);
        }
        return location;
    }

    @Nullable
    private RepositoryLocation getLocationUnderProgress(@NotNull AbstractVcs vcs, @NotNull FilePath filePath, boolean silent) {
        ThrowableComputable result2 = () -> {
            CommittedChangesProvider committedChangesProvider = vcs.getCommittedChangesProvider();
            return committedChangesProvider != null ? committedChangesProvider.getLocationFor(filePath) : null;
        };
        return !silent && ApplicationManager.getApplication().isDispatchThread() ? (RepositoryLocation)ProgressManager.getInstance().runProcessWithProgressSynchronously(result2, VcsBundle.message((String)"progress.title.discovering.location", (Object[])new Object[]{filePath.getPresentableUrl()}), true, this.myProject) : (RepositoryLocation)result2.compute();
    }

    public void reset() {
        this.myMap.clear();
    }
}

