/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.actions.diff;

import com.intellij.diff.DiffDialogHints;
import com.intellij.diff.DiffManager;
import com.intellij.diff.actions.impl.GoToChangePopupBuilder;
import com.intellij.diff.chains.DiffRequestChain;
import com.intellij.diff.chains.DiffRequestProducerException;
import com.intellij.diff.util.DiffUserDataKeysEx;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.ListSelection;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.AnActionExtensionProvider;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListChange;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.ChangesViewManager;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.FakeRevision;
import com.intellij.openapi.vcs.changes.InvokeAfterUpdateMode;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vcs.changes.actions.diff.ChangeDiffRequestProducer;
import com.intellij.openapi.vcs.changes.actions.diff.UnversionedDiffRequestProducer;
import com.intellij.openapi.vcs.changes.actions.diff.lst.LocalChangeListDiffTool;
import com.intellij.openapi.vcs.changes.ui.ChangeDiffRequestChain;
import com.intellij.openapi.vcs.changes.ui.ChangesListView;
import com.intellij.util.concurrency.FutureResult;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShowDiffFromLocalChangesActionProvider
implements AnActionExtensionProvider {
    public boolean isActive(@NotNull AnActionEvent e) {
        return e.getData(ChangesListView.DATA_KEY) != null;
    }

    public void update(@NotNull AnActionEvent e) {
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        ChangesListView view = (ChangesListView)((Object)e.getRequiredData(ChangesListView.DATA_KEY));
        Stream<Change> changes = view.getSelectedChanges();
        Stream<FilePath> unversionedFiles = view.getSelectedUnversionedFiles();
        if ("MainMenu".equals(e.getPlace())) {
            e.getPresentation().setEnabled(project != null && (changes.findAny().isPresent() || unversionedFiles.findAny().isPresent()));
        } else {
            e.getPresentation().setEnabled(project != null && ShowDiffFromLocalChangesActionProvider.canShowDiff(project, changes, unversionedFiles));
        }
    }

    private static boolean canShowDiff(@Nullable Project project, @NotNull Stream<? extends Change> changes, @NotNull Stream<? extends FilePath> paths) {
        return paths.findAny().isPresent() || changes.anyMatch(it -> ChangeDiffRequestProducer.canCreate(project, it));
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        GoToChangePopupBuilder.Chain chain;
        Project project = (Project)e.getRequiredData(CommonDataKeys.PROJECT);
        ChangesListView view = (ChangesListView)((Object)e.getRequiredData(ChangesListView.DATA_KEY));
        if (ChangeListManager.getInstance((Project)project).isFreezedWithNotification(null)) {
            return;
        }
        List changes = view.getSelectedChanges().collect(Collectors.toList());
        List unversioned = view.getSelectedUnversionedFiles().collect(Collectors.toList());
        boolean needsConversion = ShowDiffFromLocalChangesActionProvider.checkIfThereAreFakeRevisions(project, changes);
        if (needsConversion) {
            final FutureResult resultRef = new FutureResult();
            ChangeListManager.getInstance((Project)project).invokeAfterUpdate(() -> {
                try {
                    ChangesViewManager.getInstanceEx(project).refreshImmediately();
                    List<Change> actualChanges = ShowDiffFromLocalChangesActionProvider.loadFakeRevisions(project, changes);
                    resultRef.set(ShowDiffFromLocalChangesActionProvider.collectRequestProducers(project, actualChanges, unversioned, view));
                }
                catch (Throwable err) {
                    resultRef.setException(err);
                }
            }, InvokeAfterUpdateMode.SILENT, ActionsBundle.actionText((String)"Diff.ShowDiff"), ModalityState.current());
            chain = new ChangeDiffRequestChain.Async(){

                @Override
                @NotNull
                protected ListSelection<? extends ChangeDiffRequestChain.Producer> loadRequestProducers() throws DiffRequestProducerException {
                    try {
                        return (ListSelection)resultRef.get();
                    }
                    catch (InterruptedException | ExecutionException ex) {
                        throw new DiffRequestProducerException((Throwable)ex);
                    }
                }
            };
        } else {
            ListSelection<ChangeDiffRequestChain.Producer> producers = ShowDiffFromLocalChangesActionProvider.collectRequestProducers(project, changes, unversioned, view);
            if (producers.isEmpty()) {
                return;
            }
            chain = new ChangeDiffRequestChain(producers.getList(), producers.getSelectedIndex());
        }
        chain.putUserData(DiffUserDataKeysEx.LAST_REVISION_WITH_LOCAL, (Object)true);
        ShowDiffFromLocalChangesActionProvider.setAllowExcludeFromCommit(project, (DiffRequestChain)chain);
        DiffManager.getInstance().showDiff(project, (DiffRequestChain)chain, DiffDialogHints.DEFAULT);
    }

    private static boolean checkIfThereAreFakeRevisions(@NotNull Project project, @NotNull List<? extends Change> changes) {
        boolean needsConversion = false;
        for (Change change : changes) {
            ContentRevision beforeRevision = change.getBeforeRevision();
            ContentRevision afterRevision = change.getAfterRevision();
            if (beforeRevision instanceof FakeRevision) {
                VcsDirtyScopeManager.getInstance((Project)project).fileDirty(beforeRevision.getFile());
                needsConversion = true;
            }
            if (!(afterRevision instanceof FakeRevision)) continue;
            VcsDirtyScopeManager.getInstance((Project)project).fileDirty(afterRevision.getFile());
            needsConversion = true;
        }
        return needsConversion;
    }

    @NotNull
    private static List<Change> loadFakeRevisions(@NotNull Project project, @NotNull List<? extends Change> changes) {
        ArrayList<Change> actualChanges = new ArrayList<Change>();
        for (Change change : changes) {
            actualChanges.addAll(ChangeListManager.getInstance((Project)project).getChangesIn(ChangesUtil.getFilePath((Change)change)));
        }
        return actualChanges;
    }

    @NotNull
    private static ListSelection<ChangeDiffRequestChain.Producer> collectRequestProducers(@NotNull Project project, @NotNull List<? extends Change> changes, @NotNull List<? extends FilePath> unversioned, @NotNull ChangesListView changesView2) {
        Change selectedChange;
        List<Change> changelistChanges;
        if (changes.size() == 1 && unversioned.isEmpty() && (changelistChanges = changesView2.getAllChangesFromSameChangelist(selectedChange = changes.get(0))) != null) {
            int selectedIndex = ContainerUtil.indexOf(changelistChanges, it -> ChangeListChange.HASHING_STRATEGY.equals((Object)selectedChange, it));
            if (selectedIndex == -1) {
                selectedIndex = changelistChanges.indexOf(selectedChange);
            }
            return ShowDiffFromLocalChangesActionProvider.createChangeProducers(project, changelistChanges, selectedIndex);
        }
        if (unversioned.size() == 1 && changes.isEmpty()) {
            FilePath selectedFile = unversioned.get(0);
            List allUnversioned = changesView2.getUnversionedFiles().collect(Collectors.toList());
            int selectedIndex = allUnversioned.indexOf(selectedFile);
            return ShowDiffFromLocalChangesActionProvider.createUnversionedProducers(project, allUnversioned, selectedIndex);
        }
        ListSelection<ChangeDiffRequestChain.Producer> changeProducers = ShowDiffFromLocalChangesActionProvider.createChangeProducers(project, changes, 0);
        ListSelection<ChangeDiffRequestChain.Producer> unversionedProducers = ShowDiffFromLocalChangesActionProvider.createUnversionedProducers(project, unversioned, 0);
        return ListSelection.createAt((List)ContainerUtil.concat((List)changeProducers.getList(), (List)unversionedProducers.getList()), (int)0);
    }

    private static ListSelection<ChangeDiffRequestChain.Producer> createChangeProducers(@NotNull Project project, @NotNull List<? extends Change> changes, int selected) {
        return ListSelection.createAt(changes, (int)selected).map(change -> ChangeDiffRequestProducer.create(project, change));
    }

    private static ListSelection<ChangeDiffRequestChain.Producer> createUnversionedProducers(@NotNull Project project, @NotNull List<? extends FilePath> unversioned, int selected) {
        return ListSelection.createAt(unversioned, (int)selected).map(path2 -> UnversionedDiffRequestProducer.create(project, path2));
    }

    private static void setAllowExcludeFromCommit(@NotNull Project project, @NotNull DiffRequestChain chain) {
        boolean allowExcludeFromCommit = ChangesViewManager.getInstanceEx(project).isAllowExcludeFromCommit();
        chain.putUserData(LocalChangeListDiffTool.ALLOW_EXCLUDE_FROM_COMMIT, (Object)allowExcludeFromCommit);
    }
}

