/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.ZipperUpdater;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeMap;
import com.intellij.openapi.vfs.AsyncFileListener;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileMoveEvent;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import com.intellij.util.Alarm;
import com.intellij.vcsUtil.VcsUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsDirtyScopeVfsListener
implements AsyncFileListener,
Disposable {
    @NotNull
    private final ProjectLevelVcsManager myVcsManager;
    private boolean myForbid;
    @NotNull
    private final ZipperUpdater myZipperUpdater;
    private final List<FilesAndDirs> myQueue;
    private final Object myLock;
    @NotNull
    private final Runnable myDirtReporter;

    public VcsDirtyScopeVfsListener(@NotNull Project project) {
        this.myVcsManager = ProjectLevelVcsManager.getInstance((Project)project);
        VcsDirtyScopeManager dirtyScopeManager = VcsDirtyScopeManager.getInstance((Project)project);
        this.myLock = new Object();
        this.myQueue = new ArrayList<FilesAndDirs>();
        this.myDirtReporter = () -> {
            ArrayList<FilesAndDirs> list;
            Object object = this.myLock;
            synchronized (object) {
                list = new ArrayList<FilesAndDirs>(this.myQueue);
                this.myQueue.clear();
            }
            ArrayList<FilePath> dirtyFiles = new ArrayList<FilePath>();
            ArrayList<FilePath> dirtyDirs = new ArrayList<FilePath>();
            for (FilesAndDirs filesAndDirs : list) {
                for (Set<FilePath> value : filesAndDirs.files.asMap().values()) {
                    dirtyFiles.addAll(value);
                }
                for (Set<FilePath> value : filesAndDirs.dirs.asMap().values()) {
                    dirtyDirs.addAll(value);
                }
            }
            if (!dirtyFiles.isEmpty() || !dirtyDirs.isEmpty()) {
                dirtyScopeManager.filePathsDirty(dirtyFiles, dirtyDirs);
            }
        };
        this.myZipperUpdater = new ZipperUpdater(300, Alarm.ThreadToUse.POOLED_THREAD, (Disposable)this);
        Disposer.register((Disposable)project, (Disposable)this);
        VirtualFileManager.getInstance().addAsyncFileListener((AsyncFileListener)this, (Disposable)project);
    }

    public static VcsDirtyScopeVfsListener getInstance(@NotNull Project project) {
        return (VcsDirtyScopeVfsListener)ServiceManager.getService((Project)project, VcsDirtyScopeVfsListener.class);
    }

    public static void install(@NotNull Project project) {
        VcsDirtyScopeVfsListener.getInstance(project);
    }

    public void setForbid(boolean forbid) {
        assert (ApplicationManager.getApplication().isUnitTestMode());
        this.myForbid = forbid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Object object = this.myLock;
        synchronized (object) {
            this.myQueue.clear();
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            this.waitForAsyncTaskCompletion();
        }
    }

    public void waitForAsyncTaskCompletion() {
        this.myZipperUpdater.waitForAllExecuted(10L, TimeUnit.SECONDS);
    }

    @Nullable
    public AsyncFileListener.ChangeApplier prepareChange(@NotNull List<? extends VFileEvent> events) {
        if (this.myForbid || !this.myVcsManager.hasActiveVcss()) {
            return null;
        }
        final FilesAndDirs dirtyFilesAndDirs = new FilesAndDirs();
        for (VFileEvent vFileEvent : events) {
            boolean isDirectory;
            ProgressManager.checkCanceled();
            if (vFileEvent instanceof VFileCreateEvent) {
                if (!((VFileCreateEvent)vFileEvent).getParent().isInLocalFileSystem()) continue;
                isDirectory = ((VFileCreateEvent)vFileEvent).isDirectory();
            } else {
                VirtualFile file = Objects.requireNonNull(vFileEvent.getFile(), "All events but VFileCreateEvent have @NotNull getFile()");
                if (!file.isInLocalFileSystem()) continue;
                isDirectory = file.isDirectory();
            }
            if (vFileEvent instanceof VFileMoveEvent) {
                VcsDirtyScopeVfsListener.add(this.myVcsManager, dirtyFilesAndDirs, VcsUtil.getFilePath((String)((VFileMoveEvent)vFileEvent).getOldPath(), (boolean)isDirectory));
                VcsDirtyScopeVfsListener.add(this.myVcsManager, dirtyFilesAndDirs, VcsUtil.getFilePath((String)((VFileMoveEvent)vFileEvent).getNewPath(), (boolean)isDirectory));
                continue;
            }
            if (vFileEvent instanceof VFilePropertyChangeEvent && ((VFilePropertyChangeEvent)vFileEvent).isRename()) {
                FilePath oldPath = VcsUtil.getFilePath((String)((VFilePropertyChangeEvent)vFileEvent).getOldPath(), (boolean)isDirectory);
                FilePath newPath = VcsUtil.getFilePath((String)((VFilePropertyChangeEvent)vFileEvent).getNewPath(), (boolean)isDirectory);
                VcsDirtyScopeVfsListener.add(this.myVcsManager, dirtyFilesAndDirs, oldPath);
                VcsDirtyScopeVfsListener.add(this.myVcsManager, dirtyFilesAndDirs, newPath);
                FilePath parentPath = oldPath.getParentPath();
                if (parentPath == null) continue;
                VcsDirtyScopeVfsListener.addAsFiles(this.myVcsManager, dirtyFilesAndDirs, parentPath);
                continue;
            }
            VcsDirtyScopeVfsListener.add(this.myVcsManager, dirtyFilesAndDirs, VcsUtil.getFilePath((String)vFileEvent.getPath(), (boolean)isDirectory));
        }
        return new AsyncFileListener.ChangeApplier(){

            public void afterVfsChange() {
                VcsDirtyScopeVfsListener.this.markDirtyOnPooled(dirtyFilesAndDirs);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void markDirtyOnPooled(@NotNull FilesAndDirs dirtyFilesAndDirs) {
        if (!dirtyFilesAndDirs.isEmpty()) {
            Object object = this.myLock;
            synchronized (object) {
                this.myQueue.add(dirtyFilesAndDirs);
            }
            this.myZipperUpdater.queue(this.myDirtReporter);
        }
    }

    private static void add(@NotNull ProjectLevelVcsManager vcsManager2, @NotNull FilesAndDirs filesAndDirs, @NotNull FilePath filePath, boolean forceAddAsFiles) {
        AbstractVcs vcs = vcsManager2.getVcsFor(filePath);
        if (vcs == null) {
            return;
        }
        if (forceAddAsFiles || !filePath.isDirectory()) {
            filesAndDirs.files.add(vcs, filePath);
        } else {
            filesAndDirs.dirs.add(vcs, filePath);
        }
    }

    private static void add(@NotNull ProjectLevelVcsManager vcsManager2, @NotNull FilesAndDirs filesAndDirs, @NotNull FilePath filePath) {
        VcsDirtyScopeVfsListener.add(vcsManager2, filesAndDirs, filePath, false);
    }

    private static void addAsFiles(@NotNull ProjectLevelVcsManager vcsManager2, @NotNull FilesAndDirs filesAndDirs, @NotNull FilePath filePath) {
        VcsDirtyScopeVfsListener.add(vcsManager2, filesAndDirs, filePath, true);
    }

    private static class FilesAndDirs {
        @NotNull
        VcsDirtyScopeMap files = new VcsDirtyScopeMap();
        @NotNull
        VcsDirtyScopeMap dirs = new VcsDirtyScopeMap();

        private FilesAndDirs() {
        }

        private boolean isEmpty() {
            return this.files.isEmpty() && this.dirs.isEmpty();
        }
    }
}

