/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.IgnoredFilesHolder;
import com.intellij.openapi.vcs.changes.VcsDirtyScope;
import com.intellij.openapi.vcs.changes.VcsModifiableDirtyScope;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class RecursiveFileHolder
implements IgnoredFilesHolder {
    private final Project myProject;
    private final Set<FilePath> myMap;

    public RecursiveFileHolder(Project project) {
        this.myProject = project;
        this.myMap = new HashSet<FilePath>();
    }

    @Override
    public void cleanAll() {
        this.myMap.clear();
    }

    @Override
    public void addFile(@NotNull FilePath file) {
        if (!this.containsFile(file)) {
            this.myMap.add(file);
        }
    }

    @Override
    public RecursiveFileHolder copy() {
        RecursiveFileHolder copyHolder = new RecursiveFileHolder(this.myProject);
        copyHolder.myMap.addAll(this.myMap);
        return copyHolder;
    }

    @Override
    public boolean containsFile(@NotNull FilePath file) {
        if (this.myMap.isEmpty()) {
            return false;
        }
        for (FilePath parent = file; parent != null; parent = parent.getParentPath()) {
            if (!this.myMap.contains(parent)) continue;
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    public Collection<FilePath> values() {
        return this.myMap;
    }

    @Override
    public void cleanAndAdjustScope(@NotNull VcsModifiableDirtyScope scope2) {
        if (this.myProject.isDisposed()) {
            return;
        }
        Iterator<FilePath> iterator = this.myMap.iterator();
        while (iterator.hasNext()) {
            FilePath file = iterator.next();
            if (!RecursiveFileHolder.isFileDirty((VcsDirtyScope)scope2, file)) continue;
            iterator.remove();
        }
    }

    private static boolean isFileDirty(@NotNull VcsDirtyScope scope2, @NotNull FilePath filePath) {
        return scope2.belongsTo(filePath);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RecursiveFileHolder that = (RecursiveFileHolder)o;
        return this.myMap.equals(that.myMap);
    }

    public int hashCode() {
        return this.myMap.hashCode();
    }
}

