/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListData;
import com.intellij.openapi.vcs.changes.ChangeListWorker;
import com.intellij.openapi.vcs.changes.DelayedNotificator;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.local.AddList;
import com.intellij.openapi.vcs.changes.local.ChangeListCommand;
import com.intellij.openapi.vcs.changes.local.EditComment;
import com.intellij.openapi.vcs.changes.local.EditData;
import com.intellij.openapi.vcs.changes.local.EditName;
import com.intellij.openapi.vcs.changes.local.MoveChanges;
import com.intellij.openapi.vcs.changes.local.RemoveList;
import com.intellij.openapi.vcs.changes.local.SetDefault;
import com.intellij.openapi.vcs.changes.local.SetReadOnly;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Modifier {
    private final ChangeListWorker myWorker;
    private volatile boolean myInsideUpdate;
    private final List<ChangeListCommand> myCommandQueue;
    private final DelayedNotificator myNotificator;

    public Modifier(ChangeListWorker worker, DelayedNotificator notificator) {
        this.myWorker = worker;
        this.myNotificator = notificator;
        this.myCommandQueue = new ArrayList<ChangeListCommand>();
    }

    @NotNull
    public LocalChangeList addChangeList(@NotNull String name, @Nullable String comment, @Nullable ChangeListData data) {
        AddList command = new AddList(name, comment, data);
        this.impl(command);
        return command.getNewListCopy();
    }

    public void setDefault(@NotNull String name, boolean automatic) {
        SetDefault command = new SetDefault(name, automatic);
        this.impl(command);
    }

    public void removeChangeList(@NotNull String name) {
        RemoveList command = new RemoveList(name);
        this.impl(command);
    }

    public void moveChangesTo(@NotNull String name, Change @NotNull [] changes) {
        MoveChanges command = new MoveChanges(name, changes);
        this.impl(command);
    }

    public boolean setReadOnly(@NotNull String name, boolean value) {
        SetReadOnly command = new SetReadOnly(name, value);
        this.impl(command);
        return command.isResult();
    }

    public boolean editName(@NotNull String fromName, @NotNull String toName) {
        EditName command = new EditName(fromName, toName);
        this.impl(command);
        return command.isResult();
    }

    @Nullable
    public String editComment(@NotNull String fromName, @NotNull String newComment) {
        EditComment command = new EditComment(fromName, newComment);
        this.impl(command);
        return command.getOldComment();
    }

    public boolean editData(@NotNull String fromName, @Nullable ChangeListData newData) {
        EditData command = new EditData(fromName, newData);
        this.impl(command);
        return command.isResult();
    }

    private void impl(@NotNull ChangeListCommand command) {
        if (this.myInsideUpdate) {
            command.apply(this.myWorker);
            this.myCommandQueue.add(command);
        } else {
            command.apply(this.myWorker);
            this.myNotificator.callNotify(command);
        }
    }

    public boolean isInsideUpdate() {
        return this.myInsideUpdate;
    }

    public void enterUpdate() {
        this.myInsideUpdate = true;
    }

    public void finishUpdate(@Nullable ChangeListWorker updatedWorker) {
        this.myInsideUpdate = false;
        if (updatedWorker != null) {
            for (ChangeListCommand command : this.myCommandQueue) {
                command.apply(updatedWorker);
            }
        }
        for (ChangeListCommand command : this.myCommandQueue) {
            this.myNotificator.callNotify(command);
        }
        this.myCommandQueue.clear();
    }
}

