/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Getter;
import com.intellij.openapi.util.Pair;
import com.intellij.util.Consumer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class LazyRefreshingSelfQueue<T> {
    private static final Logger LOG = Logger.getInstance(LazyRefreshingSelfQueue.class);
    private final Getter<Long> myUpdateInterval;
    private final LinkedList<Pair<Long, T>> myQueue;
    private final Set<T> myInProgress;
    private final Computable<Boolean> myShouldUpdateOldChecker;
    private final Consumer<? super T> myUpdater;
    private final Object myLock;

    public LazyRefreshingSelfQueue(Getter<Long> updateInterval, Computable<Boolean> shouldUpdateOldChecker, Consumer<? super T> updater) {
        this.myUpdateInterval = updateInterval;
        this.myShouldUpdateOldChecker = shouldUpdateOldChecker;
        this.myUpdater = updater;
        this.myQueue = new LinkedList();
        this.myInProgress = new HashSet<T>();
        this.myLock = new Object();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRequest(@NotNull T t) {
        Object object = this.myLock;
        synchronized (object) {
            this.myQueue.addFirst(new Pair(null, t));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forceRemove(@NotNull T t) {
        Object object = this.myLock;
        synchronized (object) {
            Iterator iterator = this.myQueue.iterator();
            while (iterator.hasNext()) {
                Pair pair = (Pair)iterator.next();
                if (!t.equals(pair.getSecond())) continue;
                iterator.remove();
            }
            this.myInProgress.remove(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateStep() {
        long startTime = System.currentTimeMillis() - (Long)this.myUpdateInterval.get();
        boolean onlyAbsolute = true;
        Object object = this.myLock;
        synchronized (object) {
            for (Pair iterator : this.myQueue) {
                if (iterator.getFirst() == null) continue;
                onlyAbsolute = (Long)iterator.getFirst() > startTime;
                break;
            }
        }
        Boolean shouldUpdateOld = onlyAbsolute ? Boolean.valueOf(false) : (Boolean)this.myShouldUpdateOldChecker.compute();
        ArrayList<Object> dirty = new ArrayList<Object>();
        Object object2 = this.myLock;
        synchronized (object2) {
            Pair<Long, T> pair;
            while (!this.myQueue.isEmpty() && (pair = this.myQueue.get(0)).getFirst() == null) {
                dirty.add(this.myQueue.removeFirst().getSecond());
            }
            if (Boolean.TRUE.equals(shouldUpdateOld) && !this.myQueue.isEmpty()) {
                Pair<Long, T> pair2;
                while (!this.myQueue.isEmpty() && (Long)(pair2 = this.myQueue.get(0)).getFirst() < startTime) {
                    this.myQueue.removeFirst();
                    dirty.add(pair2.getSecond());
                }
            }
            this.myInProgress.addAll(dirty);
        }
        LOG.debug("found something to update: " + !dirty.isEmpty());
        for (Object e : dirty) {
            this.myUpdater.consume(e);
            Object object3 = this.myLock;
            synchronized (object3) {
                if (this.myInProgress.remove(e)) {
                    this.myQueue.addLast(new Pair((Object)System.currentTimeMillis(), e));
                }
            }
        }
    }
}

